/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class FairkeeperBorosCircleAroundPlayerGoal
extends Goal {
    private final FairkeeperBorosEntity boros;
    private Entity circlingTarget;
    private final double radius;
    private final double speed;
    private boolean clockwise;
    private final boolean circlePlayer;
    private double angle;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int arenaSize;
    private BlockPos arenaCenter;
    private FairkeeperBorosEntity.FairkeeperBorosState state;
    private static final double THRESHOLD = 2.0;
    private static final float OFFSET_FROM_WALL = 1.5f;

    public FairkeeperBorosCircleAroundPlayerGoal(FairkeeperBorosEntity.FairkeeperBorosState state, FairkeeperBorosEntity boros, double radius, double speed, boolean clockwise, boolean circlePlayer) {
        this.state = state;
        this.boros = boros;
        this.radius = radius;
        this.speed = speed;
        this.clockwise = clockwise;
        this.angle = 0.0;
        this.circlePlayer = circlePlayer;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        boolean callerExists;
        boolean bl = callerExists = this.boros.getCaller() != null;
        if (!callerExists) {
            return false;
        }
        boolean b = true;
        if (this.circlePlayer) {
            this.circlingTarget = this.boros.m_5448_();
            b = this.circlingTarget != null && this.circlingTarget.m_6084_();
        } else {
            this.circlingTarget = this.boros.getCaller();
        }
        return b && this.boros.isState(this.state);
    }

    public void m_8056_() {
        FairkeeperSerpentCallerEntity caller = this.boros.getCaller();
        this.arenaSize = caller != null ? caller.getArenaSize() : 0;
        BlockPos blockPos = this.arenaCenter = caller != null ? caller.m_20183_() : BlockPos.f_121853_;
        if (this.circlingTarget != null) {
            double deltaX = this.boros.m_20185_() - this.circlingTarget.m_20185_();
            double deltaZ = this.boros.m_20189_() - this.circlingTarget.m_20189_();
            this.angle = Math.toDegrees(Math.atan2(deltaZ, deltaX));
            this.angle = (this.angle + 360.0) % 360.0;
        } else {
            this.angle = 0.0;
        }
        this.updateTargetPosition();
    }

    public void m_8037_() {
        if (this.circlingTarget != null) {
            double deltaZ;
            double deltaX = this.boros.m_20185_() - this.targetX;
            if (deltaX * deltaX + (deltaZ = this.boros.m_20189_() - this.targetZ) * deltaZ < 4.0) {
                this.angle += this.clockwise ? -10.0 : 10.0;
                this.angle %= 360.0;
                this.updateTargetPosition();
            }
            if (this.boros.isStuck()) {
                this.clockwise = !this.clockwise;
            }
            this.boros.m_21566_().m_6849_(this.targetX, this.targetY, this.targetZ, this.speed);
        }
    }

    private void updateTargetPosition() {
        double angleRad = Math.toRadians(this.angle);
        double potentialX = this.circlingTarget.m_20185_() + this.radius * Math.cos(angleRad);
        double potentialZ = this.circlingTarget.m_20189_() + this.radius * Math.sin(angleRad);
        double minX = (float)this.arenaCenter.m_123341_() + 0.5f - (float)this.arenaSize + 1.5f;
        double maxX = (float)this.arenaCenter.m_123341_() + 0.5f + (float)this.arenaSize - 1.5f;
        double minZ = (float)this.arenaCenter.m_123343_() + 0.5f - (float)this.arenaSize + 1.5f;
        double maxZ = (float)this.arenaCenter.m_123343_() + 0.5f + (float)this.arenaSize - 1.5f;
        this.targetX = Math.max(minX, Math.min(maxX, potentialX));
        this.targetZ = Math.max(minZ, Math.min(maxZ, potentialZ));
        this.targetY = this.circlingTarget.m_20186_();
    }
}

