/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import com.google.common.collect.ImmutableList;
import dev.hexnowloading.dungeonnowloading.entity.ai.StoppableGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosPartEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.BorusArrowEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public class FairkeeperBorosCircleAndShootArrowGoal
extends StoppableGoal {
    private final FairkeeperBorosEntity boros;
    private Entity circlingTarget;
    private final double radius;
    private final double speed;
    private final boolean clockwise;
    private final boolean circlePlayer;
    private double angle;
    private double travelledAngle;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int arenaSize;
    private BlockPos arenaCenter;
    private FairkeeperBorosEntity.FairkeeperBorosState state;
    private ShootingPattern pattern;
    private List<FairkeeperBorosPartEntity> partList = new ArrayList<FairkeeperBorosPartEntity>();
    private int stoppingTick;
    private int targetIndex = 0;
    private int playSoundForPart = 0;
    private static final double THRESHOLD = 2.0;
    private static final int STOP_DURATION = 32;
    private static final int SHOOT_ARROW_TICK = 15;
    private static final int BEAM_TICK = 30;
    private static final float FULL_ARENA_SIZE = 49.0f;
    private static List<Integer> ODD_PARTS = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(9), Integer.valueOf(11));
    private static List<Integer> EVEN_PARTS = List.of(Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(8), Integer.valueOf(10), Integer.valueOf(12));
    private static List<Integer> ALL_PARTS = List.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
    public static ShootingPattern PATTERN_SMALL_CIRLCE = new ShootingPattern(false, true, 0.42857143f, (ImmutableList<Triple<ShootingType, List<Integer>, Float>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.BOTH), ALL_PARTS, (Object)Float.valueOf(360.0f)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), ALL_PARTS, (Object)Float.valueOf(400.0f)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), ALL_PARTS, (Object)Float.valueOf(440.0f))));
    public static ShootingPattern PATTERN_LARGE_CIRCLE = new ShootingPattern(false, true, 0.8979592f, (ImmutableList<Triple<ShootingType, List<Integer>, Float>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.BOTH), ALL_PARTS, (Object)Float.valueOf(120.0f)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), ALL_PARTS, (Object)Float.valueOf(240.0f)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), ALL_PARTS, (Object)Float.valueOf(360.0f))));
    public static ShootingPattern PATTERN_PLAYER_LARGE_CIRCLE = new ShootingPattern(false, true, 0.8979592f, (ImmutableList<Triple<ShootingType, List<Integer>, Float>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.BOTH), ODD_PARTS, (Object)Float.valueOf(120.0f)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), EVEN_PARTS, (Object)Float.valueOf(240.0f)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), ODD_PARTS, (Object)Float.valueOf(360.0f))));
    public static ShootingPattern PATTERN_LARGE_CIRCLE_MORE_ARROWS = new ShootingPattern(false, true, 0.8979592f, (ImmutableList<Triple<ShootingType, List<Integer>, Float>>)ImmutableList.of((Object)Triple.of((Object)((Object)ShootingType.BOTH), ALL_PARTS, (Object)Float.valueOf(180.0f)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), ALL_PARTS, (Object)Float.valueOf(300.0f)), (Object)Triple.of((Object)((Object)ShootingType.BOTH), ALL_PARTS, (Object)Float.valueOf(420.0f))));

    public FairkeeperBorosCircleAndShootArrowGoal(FairkeeperBorosEntity.FairkeeperBorosState state, FairkeeperBorosEntity boros, double speed, ShootingPattern pattern) {
        this.state = state;
        this.boros = boros;
        this.radius = pattern.ratio * 49.0f / 2.0f;
        this.speed = speed;
        this.clockwise = pattern.rotateClockWise;
        this.circlePlayer = pattern.circlePlayer;
        this.pattern = pattern;
        this.angle = 0.0;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        boolean b;
        if (this.circlePlayer) {
            this.circlingTarget = this.boros.m_5448_();
            b = this.circlingTarget != null && this.circlingTarget.m_6084_();
        } else {
            this.circlingTarget = this.boros.getCaller();
            b = this.circlingTarget != null;
        }
        return b && this.boros.isState(this.state);
    }

    @Override
    public void m_8056_() {
        FairkeeperBorosPartEntity currentPart;
        super.m_8056_();
        FairkeeperSerpentCallerEntity caller = this.boros.getCaller();
        if (caller != null) {
            this.arenaSize = caller.getArenaSize();
            BlockPos callerPos = caller.m_20183_();
            this.arenaCenter = new BlockPos(callerPos.m_123341_(), (int)this.boros.m_20186_(), callerPos.m_123343_());
        }
        if ((currentPart = (FairkeeperBorosPartEntity)this.boros.getChild()) == null) {
            this.stopGoal();
            return;
        }
        this.partList.add(currentPart);
        for (int i = 0; i < 12; ++i) {
            if ((currentPart = (FairkeeperBorosPartEntity)currentPart.getChild()) == null) {
                this.stopGoal();
                return;
            }
            this.partList.add(currentPart);
        }
        if (this.circlingTarget == null) {
            this.stopGoal();
            return;
        }
        double centerX = this.circlePlayer ? this.circlingTarget.m_20185_() : (double)this.arenaCenter.m_123341_();
        double centerZ = this.circlePlayer ? this.circlingTarget.m_20189_() : (double)this.arenaCenter.m_123343_();
        double deltaX = this.boros.m_20185_() - centerX;
        double deltaZ = this.boros.m_20189_() - centerZ;
        this.angle = Math.toDegrees(Math.atan2(deltaZ, deltaX));
        this.angle = (this.angle + 360.0) % 360.0;
        this.travelledAngle = 0.0;
        this.targetIndex = 0;
        this.stoppingTick = 0;
        this.updateTargetPosition();
    }

    public void m_8041_() {
        this.boros.stopAttacking(20);
    }

    public void m_8037_() {
        if (this.stoppingTick > 0) {
            --this.stoppingTick;
            if (this.stoppingTick == FairkeeperBorosCircleAndShootArrowGoal.m_186073_((int)30)) {
                this.playSoundForPart = 0;
                ((List)((Triple)this.pattern.positionList().get(this.targetIndex)).getMiddle()).stream().forEach(partIndex -> {
                    ShootingType shootingType = (ShootingType)((Object)((Object)((Triple)this.pattern.positionList().get(this.targetIndex)).getLeft()));
                    FairkeeperBorosPartEntity part = this.partList.get((int)partIndex);
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.LEFT) {
                        if (this.pattern.equals(PATTERN_SMALL_CIRLCE)) {
                            this.spawnRedstoneTrail(part, 90.0f, 0.0, 0.0, 15);
                        } else {
                            this.spawnRedstoneTrail(part, 90.0f, 0.0, 0.0, 30);
                        }
                    }
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.RIGHT) {
                        this.spawnRedstoneTrail(part, -90.0f, 0.0, 0.0, 30);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_LEFT) {
                        this.spawnRedstoneTrail(part, 90.0f, -1.5, 0.0, 30);
                        this.spawnRedstoneTrail(part, 90.0f, 0.0, 0.0, 30);
                        this.spawnRedstoneTrail(part, 90.0f, 1.5, 0.0, 30);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_RIGHT) {
                        this.spawnRedstoneTrail(part, -90.0f, -1.5, 0.0, 30);
                        this.spawnRedstoneTrail(part, -90.0f, 0.0, 0.0, 30);
                        this.spawnRedstoneTrail(part, -90.0f, 1.5, 0.0, 30);
                    }
                    if (this.playSoundForPart % 3 == 0) {
                        this.boros.playBeamSound(part.m_20185_(), part.m_20186_(), part.m_20189_(), 3.0f);
                    }
                    ++this.playSoundForPart;
                });
            }
            if (this.stoppingTick == FairkeeperBorosCircleAndShootArrowGoal.m_186073_((int)15)) {
                this.playSoundForPart = 0;
                ((List)((Triple)this.pattern.positionList().get(this.targetIndex)).getMiddle()).stream().forEach(partIndex -> {
                    ShootingType shootingType = (ShootingType)((Object)((Object)((Triple)this.pattern.positionList().get(this.targetIndex)).getLeft()));
                    FairkeeperBorosPartEntity part = this.partList.get((int)partIndex);
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.LEFT) {
                        this.shootArrow(part, 90.0f, 0.0, 0.0);
                    }
                    if (shootingType == ShootingType.BOTH || shootingType == ShootingType.RIGHT) {
                        this.shootArrow(part, -90.0f, 0.0, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_LEFT) {
                        this.shootArrow(part, 90.0f, -1.5, 0.0);
                        this.shootArrow(part, 90.0f, 0.0, 0.0);
                        this.shootArrow(part, 90.0f, 1.5, 0.0);
                    }
                    if (shootingType == ShootingType.TRIPLE_BOTH || shootingType == ShootingType.TRIPLE_RIGHT) {
                        this.shootArrow(part, -90.0f, -1.5, 0.0);
                        this.shootArrow(part, -90.0f, 0.0, 0.0);
                        this.shootArrow(part, -90.0f, 1.5, 0.0);
                    }
                    if (this.playSoundForPart % 3 == 0) {
                        this.boros.playArrowSound(part.m_20185_(), part.m_20186_(), part.m_20189_(), 3.0f);
                    }
                    ++this.playSoundForPart;
                });
            }
            if (this.stoppingTick <= 0) {
                ++this.targetIndex;
                if (this.targetIndex >= this.pattern.positionList().size()) {
                    this.stopGoal();
                    return;
                }
                double difference = ((Float)((Triple)this.pattern.positionList.get(this.targetIndex)).getRight()).floatValue() - ((Float)((Triple)this.pattern.positionList.get(this.targetIndex - 1)).getRight()).floatValue();
                if (difference * difference < 1.0E-7) {
                    this.stoppingTick = FairkeeperBorosCircleAndShootArrowGoal.m_186073_((int)32);
                    return;
                }
            } else {
                return;
            }
        }
        if (this.circlingTarget != null) {
            double deltaZ;
            double deltaX = this.boros.m_20185_() - this.targetX;
            if (deltaX * deltaX + (deltaZ = this.boros.m_20189_() - this.targetZ) * deltaZ < 4.0) {
                this.angle += this.clockwise ? -10.0 : 10.0;
                this.angle = (this.angle + 360.0) % 360.0;
                this.travelledAngle += this.clockwise ? -10.0 : 10.0;
                if (this.hasCompletedRevolution()) {
                    this.stoppingTick = FairkeeperBorosCircleAndShootArrowGoal.m_186073_((int)32);
                    return;
                }
                this.updateTargetPosition();
            }
            this.boros.m_21566_().m_6849_(this.targetX, this.targetY, this.targetZ, this.speed);
        }
    }

    private void updateTargetPosition() {
        double angleRad = Math.toRadians(this.angle);
        double centerX = this.circlePlayer ? this.circlingTarget.m_20185_() : (double)this.arenaCenter.m_123341_();
        double centerZ = this.circlePlayer ? this.circlingTarget.m_20189_() : (double)this.arenaCenter.m_123343_();
        double potentialX = centerX + this.radius * Math.cos(angleRad);
        double potentialZ = centerZ + this.radius * Math.sin(angleRad);
        double minX = this.arenaCenter.m_123341_() - this.arenaSize + 1;
        double maxX = this.arenaCenter.m_123341_() + this.arenaSize - 1;
        double minZ = this.arenaCenter.m_123343_() - this.arenaSize + 1;
        double maxZ = this.arenaCenter.m_123343_() + this.arenaSize - 1;
        this.targetX = Math.max(minX, Math.min(maxX, potentialX));
        this.targetZ = Math.max(minZ, Math.min(maxZ, potentialZ));
        this.targetY = this.boros.m_20186_();
    }

    private boolean hasCompletedRevolution() {
        return Math.abs(this.travelledAngle) >= (double)((Float)((Triple)this.pattern.positionList().get(this.targetIndex)).getRight()).floatValue();
    }

    private void shootArrow(FairkeeperBorosPartEntity partEntity, float angleOffset, double rxOffset, double rzOffset) {
        double viewDistance = 2.0;
        float borosFacingYaw = partEntity.m_146908_();
        double finalAngle = Math.toRadians(borosFacingYaw - angleOffset);
        double cosFinal = Math.cos(finalAngle);
        double sinFinal = Math.sin(finalAngle);
        Vec3 shootDirection = new Vec3(-sinFinal, 0.0, cosFinal).m_82541_();
        double rotatedRxOffset = rxOffset * cosFinal - rzOffset * sinFinal;
        double rotatedRzOffset = rxOffset * sinFinal + rzOffset * cosFinal;
        Vec3 startPos = new Vec3(partEntity.m_20185_() + rotatedRxOffset, partEntity.m_20186_() + partEntity.m_20191_().m_82376_() * (double)0.3f, partEntity.m_20189_() + rotatedRzOffset);
        Vec3 arrowPos = startPos.m_82549_(shootDirection.m_82490_(viewDistance));
        BorusArrowEntity arrow = new BorusArrowEntity((LivingEntity)this.boros, this.boros.m_9236_());
        arrow.m_146884_(arrowPos);
        arrow.m_37251_((Entity)partEntity, partEntity.m_146909_(), borosFacingYaw - angleOffset, 0.0f, 2.0f, 1.0f);
        this.boros.m_9236_().m_7967_((Entity)arrow);
    }

    private void spawnRedstoneTrail(FairkeeperBorosPartEntity partEntity, float angleOffset, double rxOffset, double rzOffset, int length) {
        double viewDistance = 2.0;
        float borosFacingYaw = partEntity.m_146908_();
        double finalAngle = Math.toRadians(borosFacingYaw - angleOffset);
        double cosFinal = Math.cos(finalAngle);
        double sinFinal = Math.sin(finalAngle);
        Vec3 beamDirection = new Vec3(-sinFinal, 0.0, cosFinal).m_82541_();
        double rotatedRxOffset = rxOffset * cosFinal - rzOffset * sinFinal;
        double rotatedRzOffset = rxOffset * sinFinal + rzOffset * cosFinal;
        Vec3 startPos = new Vec3(partEntity.m_20185_() + rotatedRxOffset, partEntity.m_20186_() + partEntity.m_20191_().m_82376_() * (double)0.3f, partEntity.m_20189_() + rotatedRzOffset).m_82549_(beamDirection.m_82490_(viewDistance));
        for (int i = 0; i <= length; ++i) {
            Vec3 particlePos = startPos.m_82549_(beamDirection.m_82490_((double)i));
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.ARROW_HAZARD_INDICATOR.get(), 0.5f);
            ((ServerLevel)partEntity.m_9236_()).m_8767_((ParticleOptions)particleData, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private record ShootingPattern(boolean circlePlayer, boolean rotateClockWise, float ratio, ImmutableList<Triple<ShootingType, List<Integer>, Float>> positionList) {
    }

    private static enum ShootingType {
        NONE,
        LEFT,
        RIGHT,
        BOTH,
        TRIPLE_LEFT,
        TRIPLE_RIGHT,
        TRIPLE_BOTH;

    }
}

