/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class BallistaGolemMeleeAttackGoal
extends Goal {
    private final float rangeInBbPercentage;
    protected final PathfinderMob mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private long lastCanUseCheck;
    private Path path;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;

    public BallistaGolemMeleeAttackGoal(PathfinderMob mob, double speedModifier, boolean followingTargetEvenIfNotSeen, float rangeInBbPercentage) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.rangeInBbPercentage = rangeInBbPercentage;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long gameTime = this.mob.m_9236_().m_46467_();
        if (gameTime - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = gameTime;
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)target, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(target) >= this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
    }

    public boolean m_8045_() {
        Player player;
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(target.m_20183_())) {
            return false;
        }
        return target instanceof Player && !(player = (Player)target).m_5833_() && !player.m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity $$0 = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test($$0)) {
            this.mob.m_6710_((LivingEntity)null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            return;
        }
        double distanceSq = this.mob.m_20280_((Entity)target);
        double attackRangeSq = this.getAttackReachSqr(target);
        float distanceMultiplier = distanceSq > 7.0 ? 0.7f : 1.0f;
        double moveSpeed = this.speedModifier * (double)distanceMultiplier;
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)target)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
            this.pathedTargetX = target.m_20185_();
            this.pathedTargetY = target.m_20186_();
            this.pathedTargetZ = target.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
            if (distanceSq > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (distanceSq > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.m_21573_().m_5624_((Entity)target, moveSpeed)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        if (distanceSq <= attackRangeSq && --this.ticksUntilNextAttack <= 0) {
            Player player;
            this.ticksUntilNextAttack = this.m_183277_(20);
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_7327_((Entity)target);
            if (target instanceof Player && (player = (Player)target).m_21254_()) {
                player.m_36384_(true);
            }
        }
    }

    private double getAttackReachSqr(LivingEntity livingEntity) {
        return this.mob.m_20205_() * this.rangeInBbPercentage * this.mob.m_20205_() * this.rangeInBbPercentage + livingEntity.m_20205_();
    }
}

