/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.datagen.provider;

import dev.hexnowloading.dungeonnowloading.block.FairkeeperSpawnerBlock;
import dev.hexnowloading.dungeonnowloading.block.MendingAuraChestBlock;
import dev.hexnowloading.dungeonnowloading.block.MendstoneChalkMarkBlock;
import dev.hexnowloading.dungeonnowloading.block.PillarCapBlock;
import dev.hexnowloading.dungeonnowloading.block.PreserverBlock;
import dev.hexnowloading.dungeonnowloading.block.RedstoneLaneBlock;
import dev.hexnowloading.dungeonnowloading.block.SignalGateBlock;
import dev.hexnowloading.dungeonnowloading.block.property.RedstoneLaneMode;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.registry.DNLProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class DNLForgeBlockStateProvider
extends BlockStateProvider {
    public DNLForgeBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "dungeonnowloading", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlockWithItem(DNLBlocks.STONE_TILES.get());
        this.simpleBlockWithItem(DNLBlocks.CRACKED_STONE_TILES.get());
        this.simpleBlockWithItem(DNLBlocks.SIGNALING_STONE_EMBLEM.get());
        this.simpleBlockWithItem(DNLBlocks.DUELING_STONE_EMBLEM.get());
        this.simpleBlockWithItem(DNLBlocks.PUZZLING_STONE_EMBLEM.get());
        this.simpleBlockWithItem(DNLBlocks.POLISHED_STONE.get());
        this.simpleBlockWithItem(DNLBlocks.BORDERED_STONE.get());
        this.simpleBlockWithItem(DNLBlocks.STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.COAL_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.COPPER_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.IRON_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.GOLD_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.REDSTONE_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.AMETHYST_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.LAPIS_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.EMERALD_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.QUARTZ_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.GLOWSTONE_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.PRISMARINE_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.CHORUS_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.ECHO_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.DIAMOND_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.NETHERITE_STONE_NOTCH.get());
        this.simpleBlockWithItem(DNLBlocks.OVERCHARGED_REDSTONE_BLOCK.get());
        this.fullyRotatedVarientBlock(DNLBlocks.MENDING_AURA.get());
        this.fullyRotatedVarientStairsLikeBlockWithItem(DNLBlocks.MENDING_AURA_STAIRS.get(), DNLBlocks.MENDING_AURA.get());
        this.fullyRotatedVarientSlabLikeBlockWithItem(DNLBlocks.MENDING_AURA_SLAB.get(), DNLBlocks.MENDING_AURA.get());
        this.fullyRotatedVarientFenceLikeBlockWithItem(DNLBlocks.MENDING_AURA_FENCE.get(), DNLBlocks.MENDING_AURA.get());
        this.fullyRotatedVarientWallLikeBlockWithItem(DNLBlocks.MENDING_AURA_WALL.get(), DNLBlocks.MENDING_AURA.get());
        this.fullyRotatedVarientPathLikeBlockWithItem(DNLBlocks.MENDING_AURA_PATH.get(), DNLBlocks.MENDING_AURA.get());
        this.fullyRotatedPaneLikeBlockWithItem(DNLBlocks.MENDING_AURA_PANE.get(), DNLBlocks.MENDING_AURA.get());
        this.chestLikeRandomTexturedBlock(DNLBlocks.MENDING_AURA_CHEST.get(), DNLBlocks.MENDING_AURA.get(), MendingAuraChestBlock.FACING, MendingAuraChestBlock.CHEST_TYPE, BlockStateProperties.f_61362_);
        this.stairsBlockWithItem((StairBlock)DNLBlocks.STONE_TILE_STAIRS.get(), DNLBlocks.STONE_TILES.get());
        this.slabBlockWithItems((SlabBlock)DNLBlocks.STONE_TILE_SLAB.get(), DNLBlocks.STONE_TILES.get());
        this.wallBlockWithItem((WallBlock)DNLBlocks.STONE_TILE_WALL.get(), DNLBlocks.STONE_TILES.get());
        this.rotatedPillarBlockWithItem((RotatedPillarBlock)DNLBlocks.COILING_STONE_PILLAR.get());
        this.rotatedPillarBlockWithItem((RotatedPillarBlock)DNLBlocks.CHISELED_COILING_STONE_PILLAR.get());
        this.rotatedPillarCapBlockWithItem((PillarCapBlock)DNLBlocks.COILING_STONE_PILLAR_CAPITAL.get());
        this.slabBlockWithItems((SlabBlock)DNLBlocks.COILING_STONE_PILLAR_SLAB.get());
        this.stairsBlockWithItem((StairBlock)DNLBlocks.COILING_STONE_PILLAR_STAIRS.get());
        this.wallBlockWithItem((WallBlock)DNLBlocks.COILING_STONE_PILLAR_WALL.get());
        this.redstoneLaneWithItem((RedstoneLaneBlock)DNLBlocks.REDSTONE_LANE_I.get());
        this.redstoneLaneWithItem((RedstoneLaneBlock)DNLBlocks.REDSTONE_LANE_L.get());
        this.redstoneLaneWithItem((RedstoneLaneBlock)DNLBlocks.REDSTONE_LANE_T.get());
        this.signalGateWithItem((SignalGateBlock)DNLBlocks.SIGNAL_GATE.get());
        this.preserverWithItem((PreserverBlock)DNLBlocks.STONE_PRESERVER.get());
        this.particleOnlyModel(DNLBlocks.PLAYER_STATUE.get());
        this.facingSixWayWithExistingModel(DNLBlocks.DURITE_CLUSTER.get(), "durite_cluster");
        this.facingSixWayWithExistingModel(DNLBlocks.LARGE_DURITE_BUD.get(), "large_durite_bud");
        this.facingSixWayWithExistingModel(DNLBlocks.MEDIUM_DURITE_BUD.get(), "medium_durite_bud");
        this.facingSixWayWithExistingModel(DNLBlocks.SMALL_DURITE_BUD.get(), "small_durite_bud");
        this.rotatedPillarBlockWithItem(DNLBlocks.AZURO_OAK_LOG.get());
        this.rotatedPillarBlockWithItem(DNLBlocks.STRIPPED_AZURO_OAK_LOG.get());
        this.simpleBlockWithItem(DNLBlocks.AZURO_LEAVES.get());
        this.simpleBlockWithItem(DNLBlocks.AZURO_OAK_PLANKS.get());
        this.stairsBlockWithItem((StairBlock)DNLBlocks.AZURO_OAK_PLANK_STAIRS.get(), DNLBlocks.AZURO_OAK_PLANKS.get());
        this.slabBlockWithItems((SlabBlock)DNLBlocks.AZURO_OAK_PLANK_SLAB.get(), DNLBlocks.AZURO_OAK_PLANKS.get());
        this.fenceBlockWithItem((FenceBlock)DNLBlocks.AZURO_OAK_PLANK_FENCE.get(), DNLBlocks.AZURO_OAK_PLANKS.get());
        this.fenceGateBlockWithItem((FenceGateBlock)DNLBlocks.AZURO_OAK_PLANK_FENCE_GATE.get(), DNLBlocks.AZURO_OAK_PLANKS.get());
        this.buttonBlockWithItem((ButtonBlock)DNLBlocks.AZURO_OAK_BUTTON.get(), DNLBlocks.AZURO_OAK_PLANKS.get());
        this.simplePressurePlateBlockWithItem((PressurePlateBlock)DNLBlocks.AZURO_OAK_PRESSURE_PLATE.get(), DNLBlocks.AZURO_OAK_PLANKS.get());
        this.doorBlockWithRenderType((DoorBlock)DNLBlocks.AZURO_OAK_DOOR.get(), new ResourceLocation("dungeonnowloading", "block/azuro_oak_door_bottom"), new ResourceLocation("dungeonnowloading", "block/azuro_oak_door_top"), "cutout");
        this.generateMendstoneChalkMarkModels((MendstoneChalkMarkBlock)DNLBlocks.MENDSTONE_CHALK_MARK.get(), DNLItems.MENDSTONE_CHALK_MARK.get(), MendstoneChalkMarkBlock.OUTLINE);
    }

    private void fenceGateBlockWithItem(FenceGateBlock block, Block parent) {
        this.fenceGateBlock(block, this.blockTexture(parent));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(this.name((Block)block), this.mcLoc("block/template_fence_gate"))).renderType("cutout")).texture("texture", this.blockTexture(parent));
    }

    private void simplePressurePlateBlockWithItem(PressurePlateBlock block, Block parent) {
        this.pressurePlateBlock(block, this.blockTexture(parent));
        this.itemModels().withExistingParent(this.name((Block)block), this.modLoc("block/" + this.name((Block)block)));
    }

    private void buttonBlockWithItem(ButtonBlock block, Block parent) {
        this.buttonBlock(block, this.blockTexture(parent));
        ((ItemModelBuilder)this.itemModels().withExistingParent(this.name((Block)block), this.mcLoc("block/button_inventory"))).texture("texture", this.blockTexture(parent));
    }

    private void fenceBlockWithItem(FenceBlock block, Block parent) {
        this.fenceBlock(block, this.blockTexture(parent));
        ((ItemModelBuilder)this.itemModels().withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), this.mcLoc("block/fence_inventory"))).texture("texture", this.blockTexture(parent));
    }

    private void simpleBlockWithItem(Block block) {
        this.simpleBlock(block);
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_())));
    }

    private void simpleItem(Block block) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ((ItemModelBuilder)this.itemModels().withExistingParent("item/" + name, this.mcLoc("item/generated"))).texture("layer0", "block/" + name);
    }

    private void simpleRandomBlockWithItem(Block block, int numVariants) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ConfiguredModel[] models = new ConfiguredModel[numVariants];
        for (int i = 0; i < numVariants; ++i) {
            models[i] = new ConfiguredModel((ModelFile)this.models().getExistingFile(this.modLoc("block/" + name + "_" + i)));
        }
        this.getVariantBuilder(block).partialState().setModels(models);
        ((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/" + name + "_0")));
    }

    private void stairsBlockWithItem(StairBlock block, Block parent) {
        this.stairsBlock(block, this.blockTexture(parent));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void stairsBlockWithItem(StairBlock block) {
        ResourceLocation side = this.blockTexture((Block)block);
        ResourceLocation ends = this.extend(this.blockTexture((Block)block), "_top");
        ModelBuilder stairs = this.models().stairs(this.name((Block)block), side, ends, ends);
        ModelBuilder stairsInner = this.models().stairsInner(this.name((Block)block) + "_inner", side, ends, ends);
        ModelBuilder stairsOuter = this.models().stairsOuter(this.name((Block)block) + "_outer", side, ends, ends);
        this.stairsBlock(block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void slabBlockWithItems(SlabBlock block, Block parent) {
        ResourceLocation path = this.blockTexture(parent);
        this.slabBlock(block, path, this.blockTexture(parent));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void slabBlockWithItems(SlabBlock block) {
        ResourceLocation side = this.blockTexture((Block)block);
        ResourceLocation bottom = this.extend(this.blockTexture((Block)block), "_top");
        ResourceLocation top = this.extend(this.blockTexture((Block)block), "_top");
        ModelBuilder slabBottom = this.models().slab(this.name((Block)block), side, bottom, top);
        ModelBuilder slabTop = this.models().slabTop(this.name((Block)block) + "_top", side, bottom, top);
        ModelBuilder slabDouble = this.models().cubeColumn(this.name((Block)block) + "_double", side, top);
        this.slabBlock(block, (ModelFile)slabBottom, (ModelFile)slabTop, (ModelFile)slabDouble);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void pressurePlateblockWithItems(PressurePlateBlock block) {
        ResourceLocation deactive = this.blockTexture((Block)block);
        ResourceLocation active = this.extend(this.blockTexture((Block)block), "_on");
        ModelBuilder off = ((BlockModelBuilder)this.models().pressurePlate(this.name((Block)block), deactive)).renderType("cutout");
        ModelBuilder on = ((BlockModelBuilder)this.models().pressurePlateDown(this.name((Block)block) + "_on", active)).renderType("cutout");
        this.pressurePlateBlock(block, (ModelFile)off, (ModelFile)on);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void rotatedPillarBlockWithItem(RotatedPillarBlock block) {
        this.logBlock(block);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void rotatedPillarCapBlockWithItem(PillarCapBlock block) {
        ResourceLocation side = this.blockTexture((Block)block);
        ResourceLocation sideReversed = this.extend(this.blockTexture((Block)block), "_reversed");
        ResourceLocation top = this.extend(this.blockTexture((Block)block), "_top");
        ResourceLocation bottom = this.extend(this.blockTexture((Block)block), "_bottom");
        ModelBuilder normal = this.models().cubeBottomTop(this.name((Block)block), side, bottom, top);
        ModelBuilder reversed = this.models().cubeBottomTop(this.name((Block)block) + "_reversed", sideReversed, bottom, top);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)PillarCapBlock.f_52588_, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)normal).addModel()).partialState().with((Property)PillarCapBlock.f_52588_, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)reversed).rotationX(180).rotationY(180).addModel()).partialState().with((Property)PillarCapBlock.f_52588_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)normal).rotationX(90).addModel()).partialState().with((Property)PillarCapBlock.f_52588_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)normal).rotationX(90).rotationY(90).addModel()).partialState().with((Property)PillarCapBlock.f_52588_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)reversed).rotationX(270).addModel()).partialState().with((Property)PillarCapBlock.f_52588_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)reversed).rotationX(90).rotationY(270).addModel();
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void horizontalRotatedVarientBlock(Block block) {
        ModelBuilder model = this.models().cubeAll(this.name(block), this.blockTexture(block));
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(0).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(90).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(180).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(270).build());
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void fullyRotatedVarientBlock(Block block) {
        ResourceLocation degree_0 = this.extend(this.blockTexture(block), "_0");
        ResourceLocation degree_90 = this.extend(this.blockTexture(block), "_90");
        ResourceLocation degree_180 = this.extend(this.blockTexture(block), "_180");
        ResourceLocation degree_270 = this.extend(this.blockTexture(block), "_270");
        ModelBuilder model_0 = ((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_0", degree_0)).renderType("cutout");
        ModelBuilder model_90 = ((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_90", degree_90)).renderType("cutout");
        ModelBuilder model_180 = ((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_180", degree_180)).renderType("cutout");
        ModelBuilder model_270 = ((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_270", degree_270)).renderType("cutout");
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model_0).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model_90).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model_180).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model_270).build());
        this.simpleBlockItem(block, (ModelFile)model_0);
    }

    private void fullyRotatedVarientStairsLikeBlockWithItem(Block block, Block parent) {
        ResourceLocation degree_0 = this.extend(this.blockTexture(parent), "_0");
        ResourceLocation degree_90 = this.extend(this.blockTexture(parent), "_90");
        ResourceLocation degree_180 = this.extend(this.blockTexture(parent), "_180");
        ResourceLocation degree_270 = this.extend(this.blockTexture(parent), "_270");
        ModelBuilder stairs_model_0 = ((BlockModelBuilder)this.models().stairs(this.name(block) + "_0", degree_0, degree_0, degree_0)).renderType("cutout");
        ModelBuilder stairs_model_90 = ((BlockModelBuilder)this.models().stairs(this.name(block) + "_90", degree_90, degree_90, degree_90)).renderType("cutout");
        ModelBuilder stairs_model_180 = ((BlockModelBuilder)this.models().stairs(this.name(block) + "_180", degree_180, degree_180, degree_180)).renderType("cutout");
        ModelBuilder stairs_model_270 = ((BlockModelBuilder)this.models().stairs(this.name(block) + "_270", degree_270, degree_270, degree_270)).renderType("cutout");
        ModelBuilder stairsInner_model_0 = ((BlockModelBuilder)this.models().stairsInner(this.name(block) + "_inner_0", degree_0, degree_0, degree_0)).renderType("cutout");
        ModelBuilder stairsInner_model_90 = ((BlockModelBuilder)this.models().stairsInner(this.name(block) + "_inner_90", degree_90, degree_90, degree_90)).renderType("cutout");
        ModelBuilder stairsInner_model_180 = ((BlockModelBuilder)this.models().stairsInner(this.name(block) + "_inner_180", degree_180, degree_180, degree_180)).renderType("cutout");
        ModelBuilder stairsInner_model_270 = ((BlockModelBuilder)this.models().stairsInner(this.name(block) + "_inner_270", degree_270, degree_270, degree_270)).renderType("cutout");
        ModelBuilder stairsOuter_model_0 = ((BlockModelBuilder)this.models().stairsOuter(this.name(block) + "_outer_0", degree_0, degree_0, degree_0)).renderType("cutout");
        ModelBuilder stairsOuter_model_90 = ((BlockModelBuilder)this.models().stairsOuter(this.name(block) + "_outer_90", degree_90, degree_90, degree_90)).renderType("cutout");
        ModelBuilder stairsOuter_model_180 = ((BlockModelBuilder)this.models().stairsOuter(this.name(block) + "_outer_180", degree_180, degree_180, degree_180)).renderType("cutout");
        ModelBuilder stairsOuter_model_270 = ((BlockModelBuilder)this.models().stairsOuter(this.name(block) + "_outer_270", degree_270, degree_270, degree_270)).renderType("cutout");
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> DNLForgeBlockStateProvider.lambda$fullyRotatedVarientStairsLikeBlockWithItem$0((ModelFile)stairs_model_90, (ModelFile)stairs_model_180, (ModelFile)stairs_model_270, (ModelFile)stairs_model_0, (ModelFile)stairsInner_model_90, (ModelFile)stairsInner_model_180, (ModelFile)stairsInner_model_270, (ModelFile)stairsInner_model_0, (ModelFile)stairsOuter_model_90, (ModelFile)stairsOuter_model_180, (ModelFile)stairsOuter_model_270, (ModelFile)stairsOuter_model_0, arg_0), new Property[]{BlockStateProperties.f_61362_});
        this.simpleBlockItem(block, (ModelFile)stairs_model_0);
    }

    private void fullyRotatedVarientSlabLikeBlockWithItem(Block block, Block parent) {
        ResourceLocation degree_0 = this.extend(this.blockTexture(parent), "_0");
        ResourceLocation degree_90 = this.extend(this.blockTexture(parent), "_90");
        ResourceLocation degree_180 = this.extend(this.blockTexture(parent), "_180");
        ResourceLocation degree_270 = this.extend(this.blockTexture(parent), "_270");
        ModelBuilder slabBottom_0 = ((BlockModelBuilder)this.models().slab(this.name(block) + "_0", degree_0, degree_0, degree_0)).renderType("cutout");
        ModelBuilder slabBottom_90 = ((BlockModelBuilder)this.models().slab(this.name(block) + "_90", degree_90, degree_90, degree_90)).renderType("cutout");
        ModelBuilder slabBottom_180 = ((BlockModelBuilder)this.models().slab(this.name(block) + "_180", degree_180, degree_180, degree_180)).renderType("cutout");
        ModelBuilder slabBottom_270 = ((BlockModelBuilder)this.models().slab(this.name(block) + "_270", degree_270, degree_270, degree_270)).renderType("cutout");
        ModelBuilder slabTop_0 = ((BlockModelBuilder)this.models().slabTop(this.name(block) + "_top_0", degree_0, degree_0, degree_0)).renderType("cutout");
        ModelBuilder slabTop_90 = ((BlockModelBuilder)this.models().slabTop(this.name(block) + "_top_90", degree_90, degree_90, degree_90)).renderType("cutout");
        ModelBuilder slabTop_180 = ((BlockModelBuilder)this.models().slabTop(this.name(block) + "_top_180", degree_180, degree_180, degree_180)).renderType("cutout");
        ModelBuilder slabTop_270 = ((BlockModelBuilder)this.models().slabTop(this.name(block) + "_top_270", degree_270, degree_270, degree_270)).renderType("cutout");
        ModelBuilder slabDouble_0 = ((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_double_0", this.blockTexture(parent))).renderType("cutout");
        ModelBuilder slabDouble_90 = ((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_double_90", this.blockTexture(parent))).renderType("cutout");
        ModelBuilder slabDouble_180 = ((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_double_180", this.blockTexture(parent))).renderType("cutout");
        ModelBuilder slabDouble_270 = ((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_double_270", this.blockTexture(parent))).renderType("cutout");
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> DNLForgeBlockStateProvider.lambda$fullyRotatedVarientSlabLikeBlockWithItem$1((ModelFile)slabBottom_0, (ModelFile)slabBottom_90, (ModelFile)slabBottom_180, (ModelFile)slabBottom_270, (ModelFile)slabTop_0, (ModelFile)slabTop_90, (ModelFile)slabTop_180, (ModelFile)slabTop_270, (ModelFile)slabDouble_0, (ModelFile)slabDouble_90, (ModelFile)slabDouble_180, (ModelFile)slabDouble_270, arg_0), new Property[]{BlockStateProperties.f_61362_});
        this.simpleBlockItem(block, (ModelFile)slabBottom_0);
    }

    private void fullyRotatedVarientFenceLikeBlockWithItem(Block block, Block parent) {
        ResourceLocation degree_0 = this.extend(this.blockTexture(parent), "_0");
        ResourceLocation degree_90 = this.extend(this.blockTexture(parent), "_90");
        ResourceLocation degree_180 = this.extend(this.blockTexture(parent), "_180");
        ResourceLocation degree_270 = this.extend(this.blockTexture(parent), "_270");
        ModelBuilder post_0 = ((BlockModelBuilder)this.models().fencePost(this.name(block) + "_post_0", degree_0)).renderType("cutout");
        ModelBuilder post_90 = ((BlockModelBuilder)this.models().fencePost(this.name(block) + "_post_90", degree_90)).renderType("cutout");
        ModelBuilder post_180 = ((BlockModelBuilder)this.models().fencePost(this.name(block) + "_post_180", degree_180)).renderType("cutout");
        ModelBuilder post_270 = ((BlockModelBuilder)this.models().fencePost(this.name(block) + "_post_270", degree_270)).renderType("cutout");
        ModelBuilder side_0 = ((BlockModelBuilder)this.models().fenceSide(this.name(block) + "_side_0", degree_0)).renderType("cutout");
        ModelBuilder side_90 = ((BlockModelBuilder)this.models().fenceSide(this.name(block) + "_side_90", degree_90)).renderType("cutout");
        ModelBuilder side_180 = ((BlockModelBuilder)this.models().fenceSide(this.name(block) + "_side_180", degree_180)).renderType("cutout");
        ModelBuilder side_270 = ((BlockModelBuilder)this.models().fenceSide(this.name(block) + "_side_270", degree_270)).renderType("cutout");
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)post_0).addModel()).end();
        PipeBlock.f_55154_.entrySet().forEach(arg_0 -> DNLForgeBlockStateProvider.lambda$fullyRotatedVarientFenceLikeBlockWithItem$2(builder, (ModelFile)side_0, arg_0));
        ((ItemModelBuilder)this.itemModels().withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), this.mcLoc("block/fence_inventory"))).texture("texture", degree_0);
    }

    private void fullyRotatedVarientWallLikeBlockWithItem(Block block, Block parent) {
        ResourceLocation degree_0 = this.extend(this.blockTexture(parent), "_0");
        ResourceLocation degree_90 = this.extend(this.blockTexture(parent), "_90");
        ResourceLocation degree_180 = this.extend(this.blockTexture(parent), "_180");
        ResourceLocation degree_270 = this.extend(this.blockTexture(parent), "_270");
        ModelBuilder post_0 = ((BlockModelBuilder)this.models().wallPost(this.name(block) + "_post_0", degree_0)).renderType("cutout");
        ModelBuilder post_90 = ((BlockModelBuilder)this.models().wallPost(this.name(block) + "_post_90", degree_90)).renderType("cutout");
        ModelBuilder post_180 = ((BlockModelBuilder)this.models().wallPost(this.name(block) + "_post_180", degree_180)).renderType("cutout");
        ModelBuilder post_270 = ((BlockModelBuilder)this.models().wallPost(this.name(block) + "_post_270", degree_270)).renderType("cutout");
        ModelBuilder side_0 = ((BlockModelBuilder)this.models().wallSide(this.name(block) + "_side_0", degree_0)).renderType("cutout");
        ModelBuilder side_90 = ((BlockModelBuilder)this.models().wallSide(this.name(block) + "_side_90", degree_90)).renderType("cutout");
        ModelBuilder side_180 = ((BlockModelBuilder)this.models().wallSide(this.name(block) + "_side_180", degree_180)).renderType("cutout");
        ModelBuilder side_270 = ((BlockModelBuilder)this.models().wallSide(this.name(block) + "_side_270", degree_270)).renderType("cutout");
        ModelBuilder side_tall_0 = ((BlockModelBuilder)this.models().wallSideTall(this.name(block) + "_side_tall_0", degree_0)).renderType("cutout");
        ModelBuilder side_tall_90 = ((BlockModelBuilder)this.models().wallSideTall(this.name(block) + "_side_tall_90", degree_90)).renderType("cutout");
        ModelBuilder side_tall_180 = ((BlockModelBuilder)this.models().wallSideTall(this.name(block) + "_side_tall_180", degree_180)).renderType("cutout");
        ModelBuilder side_tall_270 = ((BlockModelBuilder)this.models().wallSideTall(this.name(block) + "_side_tall_270", degree_270)).renderType("cutout");
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)post_0).addModel()).condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{true}).end();
        WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).m_122434_().m_122479_()).forEach(arg_0 -> this.lambda$fullyRotatedVarientWallLikeBlockWithItem$4(builder, (ModelFile)side_0, (ModelFile)side_tall_0, arg_0));
        ((ItemModelBuilder)this.itemModels().withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", degree_0);
    }

    private void wallSidePart(MultiPartBlockStateBuilder builder, ModelFile model, Map.Entry<Direction, Property<WallSide>> entry, WallSide height) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(model).rotationY(((int)entry.getKey().m_122435_() + 180) % 360).uvLock(true).addModel()).condition(entry.getValue(), (Comparable[])new WallSide[]{height});
    }

    private void fullyRotatedVarientPathLikeBlockWithItem(Block block, Block parent) {
        ResourceLocation degree_0 = this.extend(this.blockTexture(parent), "_0");
        ResourceLocation degree_90 = this.extend(this.blockTexture(parent), "_90");
        ResourceLocation degree_180 = this.extend(this.blockTexture(parent), "_180");
        ResourceLocation degree_270 = this.extend(this.blockTexture(parent), "_270");
        ModelBuilder model_0 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_crop_0", this.mcLoc("block/template_farmland"))).texture("dirt", degree_0)).texture("top", degree_0)).renderType("cutout");
        ModelBuilder model_90 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_crop_90", this.mcLoc("block/template_farmland"))).texture("dirt", degree_90)).texture("top", degree_90)).renderType("cutout");
        ModelBuilder model_180 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_crop_180", this.mcLoc("block/template_farmland"))).texture("dirt", degree_180)).texture("top", degree_180)).renderType("cutout");
        ModelBuilder model_270 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_crop_270", this.mcLoc("block/template_farmland"))).texture("dirt", degree_270)).texture("top", degree_270)).renderType("cutout");
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model_0).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model_90).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model_180).build()).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model_270).build());
        this.simpleBlockItem(block, (ModelFile)model_0);
    }

    private void fullyRotatedPaneLikeBlockWithItem(Block block, Block parent) {
        ResourceLocation degree_0 = this.extend(this.blockTexture(parent), "_0");
        ResourceLocation degree_90 = this.extend(this.blockTexture(parent), "_90");
        ResourceLocation degree_180 = this.extend(this.blockTexture(parent), "_180");
        ResourceLocation degree_270 = this.extend(this.blockTexture(parent), "_270");
        ModelBuilder post_0 = ((BlockModelBuilder)this.models().panePost(this.name(block) + "_post_0", degree_0, degree_0)).renderType("cutout");
        ModelBuilder post_90 = ((BlockModelBuilder)this.models().panePost(this.name(block) + "_post_90", degree_90, degree_90)).renderType("cutout");
        ModelBuilder post_180 = ((BlockModelBuilder)this.models().panePost(this.name(block) + "_post_180", degree_180, degree_180)).renderType("cutout");
        ModelBuilder post_270 = ((BlockModelBuilder)this.models().panePost(this.name(block) + "_post_270", degree_270, degree_270)).renderType("cutout");
        ModelBuilder side_0 = ((BlockModelBuilder)this.models().paneSide(this.name(block) + "_side_0", degree_0, degree_0)).renderType("cutout");
        ModelBuilder side_90 = ((BlockModelBuilder)this.models().paneSide(this.name(block) + "_side_90", degree_90, degree_90)).renderType("cutout");
        ModelBuilder side_180 = ((BlockModelBuilder)this.models().paneSide(this.name(block) + "_side_180", degree_180, degree_180)).renderType("cutout");
        ModelBuilder side_270 = ((BlockModelBuilder)this.models().paneSide(this.name(block) + "_side_270", degree_270, degree_270)).renderType("cutout");
        ModelBuilder no_side_0 = ((BlockModelBuilder)this.models().paneNoSide(this.name(block) + "_no_side_0", degree_0)).renderType("cutout");
        ModelBuilder no_side_90 = ((BlockModelBuilder)this.models().paneNoSide(this.name(block) + "_no_side_90", degree_90)).renderType("cutout");
        ModelBuilder no_side_180 = ((BlockModelBuilder)this.models().paneNoSide(this.name(block) + "_no_side_180", degree_180)).renderType("cutout");
        ModelBuilder no_side_270 = ((BlockModelBuilder)this.models().paneNoSide(this.name(block) + "_no_side_270", degree_270)).renderType("cutout");
        ModelBuilder side_alt_0 = ((BlockModelBuilder)this.models().paneSideAlt(this.name(block) + "_side_alt_0", degree_0, degree_0)).renderType("cutout");
        ModelBuilder side_alt_90 = ((BlockModelBuilder)this.models().paneSideAlt(this.name(block) + "_side_alt_90", degree_90, degree_90)).renderType("cutout");
        ModelBuilder side_alt_180 = ((BlockModelBuilder)this.models().paneSideAlt(this.name(block) + "_side_alt_180", degree_180, degree_180)).renderType("cutout");
        ModelBuilder side_alt_270 = ((BlockModelBuilder)this.models().paneSideAlt(this.name(block) + "_side_alt_270", degree_270, degree_270)).renderType("cutout");
        ModelBuilder no_side_alt_0 = ((BlockModelBuilder)this.models().paneNoSideAlt(this.name(block) + "_no_side_alt_0", degree_0)).renderType("cutout");
        ModelBuilder no_side_alt_90 = ((BlockModelBuilder)this.models().paneNoSideAlt(this.name(block) + "_no_side_alt_90", degree_90)).renderType("cutout");
        ModelBuilder no_side_alt_180 = ((BlockModelBuilder)this.models().paneNoSideAlt(this.name(block) + "_no_side_alt_180", degree_180)).renderType("cutout");
        ModelBuilder no_side_alt_270 = ((BlockModelBuilder)this.models().paneNoSideAlt(this.name(block) + "_no_side_alt_270", degree_270)).renderType("cutout");
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)post_0).addModel()).end();
        PipeBlock.f_55154_.entrySet().forEach(arg_0 -> DNLForgeBlockStateProvider.lambda$fullyRotatedPaneLikeBlockWithItem$5(builder, (ModelFile)side_0, (ModelFile)side_alt_0, (ModelFile)no_side_0, (ModelFile)no_side_alt_0, arg_0));
        ((ItemModelBuilder)this.itemModels().withExistingParent(this.key(block).m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + this.key(parent).m_135815_() + "_0"));
    }

    private void chestLikeRandomTexturedBlock(Block block, Block textureParent, DirectionProperty facingProp, EnumProperty<ChestType> typeProp, @Nullable BooleanProperty waterloggedProp) {
        ResourceLocation tex0 = this.extend(this.blockTexture(textureParent), "_0");
        ResourceLocation tex90 = this.extend(this.blockTexture(textureParent), "_90");
        ResourceLocation tex180 = this.extend(this.blockTexture(textureParent), "_180");
        ResourceLocation tex270 = this.extend(this.blockTexture(textureParent), "_270");
        ModelFile single_0 = this.chestBoxModel(this.name(block) + "_single_0", tex0);
        ModelFile single_90 = this.chestBoxModel(this.name(block) + "_single_90", tex90);
        ModelFile single_180 = this.chestBoxModel(this.name(block) + "_single_180", tex180);
        ModelFile single_270 = this.chestBoxModel(this.name(block) + "_single_270", tex270);
        ModelFile left_0 = this.chestBoxModel(this.name(block) + "_left_0", tex0);
        ModelFile left_90 = this.chestBoxModel(this.name(block) + "_left_90", tex90);
        ModelFile left_180 = this.chestBoxModel(this.name(block) + "_left_180", tex180);
        ModelFile left_270 = this.chestBoxModel(this.name(block) + "_left_270", tex270);
        ModelFile right_0 = this.chestBoxModel(this.name(block) + "_right_0", tex0);
        ModelFile right_90 = this.chestBoxModel(this.name(block) + "_right_90", tex90);
        ModelFile right_180 = this.chestBoxModel(this.name(block) + "_right_180", tex180);
        ModelFile right_270 = this.chestBoxModel(this.name(block) + "_right_270", tex270);
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        Function<BlockState, ConfiguredModel[]> states = state -> {
            ModelFile[] modelFileArray;
            Direction facing = (Direction)state.m_61143_((Property)facingProp);
            ChestType type = (ChestType)state.m_61143_((Property)typeProp);
            int y = switch (facing) {
                case Direction.NORTH -> 0;
                case Direction.EAST -> 90;
                case Direction.SOUTH -> 180;
                case Direction.WEST -> 270;
                default -> 0;
            };
            switch (type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case SINGLE: {
                    ModelFile[] modelFileArray2 = new ModelFile[4];
                    modelFileArray2[0] = single_0;
                    modelFileArray2[1] = single_90;
                    modelFileArray2[2] = single_180;
                    modelFileArray = modelFileArray2;
                    modelFileArray2[3] = single_270;
                    break;
                }
                case LEFT: {
                    ModelFile[] modelFileArray3 = new ModelFile[4];
                    modelFileArray3[0] = left_0;
                    modelFileArray3[1] = left_90;
                    modelFileArray3[2] = left_180;
                    modelFileArray = modelFileArray3;
                    modelFileArray3[3] = left_270;
                    break;
                }
                case RIGHT: {
                    ModelFile[] modelFileArray4 = new ModelFile[4];
                    modelFileArray4[0] = right_0;
                    modelFileArray4[1] = right_90;
                    modelFileArray4[2] = right_180;
                    modelFileArray = modelFileArray4;
                    modelFileArray4[3] = right_270;
                }
            }
            ModelFile[] pool = modelFileArray;
            return new ConfiguredModel[]{new ConfiguredModel(pool[0], 0, y, false, 1), new ConfiguredModel(pool[1], 0, y, false, 1), new ConfiguredModel(pool[2], 0, y, false, 1), new ConfiguredModel(pool[3], 0, y, false, 1)};
        };
        if (waterloggedProp != null && block.m_49966_().m_61138_((Property)waterloggedProp)) {
            builder.forAllStatesExcept(states, new Property[]{waterloggedProp});
        } else {
            builder.forAllStates(states);
        }
        this.simpleBlockItem(block, single_0);
    }

    private ModelFile chestBoxModel(String modelName, ResourceLocation tex) {
        BlockModelBuilder b = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelName)).renderType("cutout")).texture("all", tex)).texture("particle", tex);
        b.element().from(1.0f, 0.0f, 1.0f).to(15.0f, 14.0f, 15.0f).face(Direction.NORTH).texture("#all").end().face(Direction.SOUTH).texture("#all").end().face(Direction.WEST).texture("#all").end().face(Direction.EAST).texture("#all").end().face(Direction.UP).texture("#all").end().face(Direction.DOWN).texture("#all").end().end();
        b.element().from(7.0f, 7.0f, 0.0f).to(9.0f, 11.0f, 1.0f).face(Direction.NORTH).texture("#all").end().face(Direction.SOUTH).texture("#all").end().face(Direction.WEST).texture("#all").end().face(Direction.EAST).texture("#all").end().face(Direction.UP).texture("#all").end().face(Direction.DOWN).texture("#all").end().end();
        return b;
    }

    public static boolean always(BlockState blockState) {
        return true;
    }

    private void orientableWithBottomBlockWithItem(HorizontalDirectionalBlock block) {
        ResourceLocation side = this.extend(this.blockTexture((Block)block), "_side");
        ResourceLocation front = this.extend(this.blockTexture((Block)block), "_front");
        ResourceLocation bottom = this.extend(this.blockTexture((Block)block), "_bottom");
        ResourceLocation top = this.extend(this.blockTexture((Block)block), "_top");
        ModelBuilder normal = this.models().orientableWithBottom(this.name((Block)block), side, front, bottom, top);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)normal).addModel()).partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)normal).rotationY(90).addModel()).partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)normal).addModel()).partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)normal).rotationX(90).addModel();
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void preserverWithItem(PreserverBlock block) {
        ResourceLocation m_on = this.extend(this.blockTexture((Block)block), "_on_0");
        ResourceLocation e_on = this.extend(this.blockTexture((Block)block), "_on_1");
        ResourceLocation n_on = this.extend(this.blockTexture((Block)block), "_on_2");
        ResourceLocation d_on = this.extend(this.blockTexture((Block)block), "_on_3");
        ResourceLocation i_on = this.extend(this.blockTexture((Block)block), "_on_4");
        ResourceLocation g_on = this.extend(this.blockTexture((Block)block), "_on_5");
        ResourceLocation m_off = this.extend(this.blockTexture((Block)block), "_off_0");
        ResourceLocation e_off = this.extend(this.blockTexture((Block)block), "_off_1");
        ResourceLocation n_off = this.extend(this.blockTexture((Block)block), "_off_2");
        ResourceLocation d_off = this.extend(this.blockTexture((Block)block), "_off_3");
        ResourceLocation i_off = this.extend(this.blockTexture((Block)block), "_off_4");
        ResourceLocation g_off = this.extend(this.blockTexture((Block)block), "_off_5");
        ModelBuilder m_on_model = this.models().cubeAll(this.name((Block)block) + "_on_0", m_on);
        ModelBuilder e_on_model = this.models().cubeAll(this.name((Block)block) + "_on_1", e_on);
        ModelBuilder n_on_model = this.models().cubeAll(this.name((Block)block) + "_on_2", n_on);
        ModelBuilder d_on_model = this.models().cubeAll(this.name((Block)block) + "_on_3", d_on);
        ModelBuilder i_on_model = this.models().cubeAll(this.name((Block)block) + "_on_4", i_on);
        ModelBuilder g_on_model = this.models().cubeAll(this.name((Block)block) + "_on_5", g_on);
        ModelBuilder m_off_model = this.models().cubeAll(this.name((Block)block) + "_off_0", m_off);
        ModelBuilder e_off_model = this.models().cubeAll(this.name((Block)block) + "_off_1", e_off);
        ModelBuilder n_off_model = this.models().cubeAll(this.name((Block)block) + "_off_2", n_off);
        ModelBuilder d_off_model = this.models().cubeAll(this.name((Block)block) + "_off_3", d_off);
        ModelBuilder i_off_model = this.models().cubeAll(this.name((Block)block) + "_off_4", i_off);
        ModelBuilder g_off_model = this.models().cubeAll(this.name((Block)block) + "_off_5", g_off);
        this.getVariantBuilder((Block)block).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)m_on_model).build()).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)e_on_model).build()).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)n_on_model).build()).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)d_on_model).build()).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)i_on_model).build()).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.builder().modelFile((ModelFile)g_on_model).build()).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)m_off_model).build()).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)e_off_model).build()).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)n_off_model).build()).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)d_off_model).build()).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)i_off_model).build()).partialState().with((Property)PreserverBlock.LIT, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.builder().modelFile((ModelFile)g_off_model).build());
        this.simpleBlockItem((Block)block, (ModelFile)m_off_model);
    }

    private void signalGateWithItem(SignalGateBlock block) {
        ResourceLocation front = this.extend(this.blockTexture((Block)block), "_front");
        ResourceLocation back_on = this.extend(this.blockTexture((Block)block), "_back_on");
        ResourceLocation back_off = this.extend(this.blockTexture((Block)block), "_back_off");
        ResourceLocation bottom = this.extend(this.blockTexture((Block)block), "_bottom");
        ResourceLocation side_on = this.extend(this.blockTexture((Block)block), "_side_on");
        ResourceLocation side_on_reverse = this.extend(this.blockTexture((Block)block), "_side_on_reverse");
        ResourceLocation side_off = this.extend(this.blockTexture((Block)block), "_side_off");
        ResourceLocation side_off_reverse = this.extend(this.blockTexture((Block)block), "_side_off_reverse");
        ResourceLocation top_00 = this.extend(this.blockTexture((Block)block), "_top_00");
        ResourceLocation top_01 = this.extend(this.blockTexture((Block)block), "_top_01");
        ResourceLocation top_02 = this.extend(this.blockTexture((Block)block), "_top_02");
        ResourceLocation top_03 = this.extend(this.blockTexture((Block)block), "_top_03");
        ResourceLocation top_04 = this.extend(this.blockTexture((Block)block), "_top_04");
        ResourceLocation top_05 = this.extend(this.blockTexture((Block)block), "_top_05");
        ResourceLocation top_06 = this.extend(this.blockTexture((Block)block), "_top_06");
        ResourceLocation top_07 = this.extend(this.blockTexture((Block)block), "_top_07");
        ResourceLocation top_08 = this.extend(this.blockTexture((Block)block), "_top_08");
        ResourceLocation top_09 = this.extend(this.blockTexture((Block)block), "_top_09");
        ResourceLocation top_10 = this.extend(this.blockTexture((Block)block), "_top_10");
        ResourceLocation top_11 = this.extend(this.blockTexture((Block)block), "_top_11");
        ResourceLocation top_12 = this.extend(this.blockTexture((Block)block), "_top_12");
        ResourceLocation top_13 = this.extend(this.blockTexture((Block)block), "_top_13");
        ResourceLocation top_14 = this.extend(this.blockTexture((Block)block), "_top_14");
        ResourceLocation top_15 = this.extend(this.blockTexture((Block)block), "_top_15");
        ModelBuilder off_00 = ((BlockModelBuilder)this.models().cube(this.name((Block)block), bottom, top_00, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_01 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_01", bottom, top_01, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_02 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_02", bottom, top_02, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_03 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_03", bottom, top_03, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_04 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_04", bottom, top_04, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_05 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_05", bottom, top_05, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_06 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_06", bottom, top_06, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_07 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_07", bottom, top_07, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_08 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_08", bottom, top_08, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_09 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_09", bottom, top_09, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_10 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_10", bottom, top_10, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_11 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_11", bottom, top_11, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_12 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_12", bottom, top_12, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_13 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_13", bottom, top_13, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_14 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_14", bottom, top_14, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder off_15 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_off_15", bottom, top_15, front, back_off, side_off_reverse, side_off)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_00 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_00", bottom, top_00, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_01 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_01", bottom, top_01, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_02 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_02", bottom, top_02, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_03 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_03", bottom, top_03, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_04 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_04", bottom, top_04, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_05 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_05", bottom, top_05, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_06 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_06", bottom, top_06, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_07 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_07", bottom, top_07, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_08 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_08", bottom, top_08, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_09 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_09", bottom, top_09, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_10 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_10", bottom, top_10, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_11 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_11", bottom, top_11, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_12 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_12", bottom, top_12, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_13 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_13", bottom, top_13, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_14 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_14", bottom, top_14, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        ModelBuilder on_15 = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_on_15", bottom, top_15, front, back_on, side_on_reverse, side_on)).texture("particle", this.extend(this.blockTexture((Block)block), "_front"));
        List<ModelFile> modelFileListOff = Arrays.asList(off_00, off_01, off_02, off_03, off_04, off_05, off_06, off_07, off_08, off_09, off_10, off_11, off_12, off_13, off_14, off_15);
        int j = 0;
        for (ModelFile model : modelFileListOff) {
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.UP).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(j)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).rotationX(270).addModel()).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.DOWN).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(j)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).rotationX(90).addModel()).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.NORTH).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(j)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).addModel()).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.EAST).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(j)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).rotationY(90).addModel()).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.SOUTH).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(j)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).rotationY(180).addModel()).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.WEST).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(j)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).rotationY(270).addModel();
            ++j;
        }
        List<ModelFile> modelFileList = Arrays.asList(on_00, on_01, on_02, on_03, on_04, on_05, on_06, on_07, on_08, on_09, on_10, on_11, on_12, on_13, on_14, on_15);
        int i = 0;
        for (ModelFile model : modelFileList) {
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.UP).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(i)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(model).rotationX(270).addModel()).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.DOWN).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(i)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(model).rotationX(90).addModel()).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.NORTH).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(i)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(model).addModel()).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.EAST).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(i)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(model).rotationY(90).addModel()).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.SOUTH).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(i)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(model).rotationY(180).addModel()).partialState().with((Property)SignalGateBlock.f_52588_, (Comparable)Direction.WEST).with((Property)SignalGateBlock.POWER, (Comparable)Integer.valueOf(i)).with((Property)SignalGateBlock.POWERED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(model).rotationY(270).addModel();
            ++i;
        }
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block)));
    }

    private void redstoneLaneWithItem(RedstoneLaneBlock block) {
        ResourceLocation base_lane = new ResourceLocation("dungeonnowloading:block/redstone_lane");
        ResourceLocation side = this.extend(base_lane, "_side");
        ResourceLocation front = this.extend(base_lane, "_front");
        ResourceLocation front_powered = this.extend(base_lane, "_front_powered");
        ResourceLocation front_overpowered = this.extend(base_lane, "_front_overpowered");
        ResourceLocation bottom = this.extend(base_lane, "_bottom");
        ResourceLocation top = this.extend(this.blockTexture((Block)block), "_top_unpowered");
        ResourceLocation top_powered = this.extend(this.blockTexture((Block)block), "_top_powered");
        ResourceLocation top_overpowered = this.extend(this.blockTexture((Block)block), "_top_overpowered");
        ModelBuilder unpowered = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_unpowered", bottom, top, front, front, side, side)).texture("particle", top);
        ModelBuilder powered = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_powered", bottom, top_powered, front_powered, front_powered, side, side)).texture("particle", top_powered);
        ModelBuilder overpowered = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_overpowered", bottom, top_overpowered, front_overpowered, front_overpowered, side, side)).texture("particle", top_overpowered);
        if (this.name((Block)block).equals("redstone_lane_l")) {
            unpowered = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_unpowered", bottom, top, side, front, front, side)).texture("particle", top);
            powered = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_powered", bottom, top_powered, side, front_powered, front_powered, side)).texture("particle", top_powered);
            overpowered = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_overpowered", bottom, top_overpowered, side, front_overpowered, front_overpowered, side)).texture("particle", top_overpowered);
        } else if (this.name((Block)block).equals("redstone_lane_t")) {
            unpowered = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_unpowered", bottom, top, side, front, front, front)).texture("particle", top);
            powered = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_powered", bottom, top_powered, side, front_powered, front_powered, front_powered)).texture("particle", top_powered);
            overpowered = ((BlockModelBuilder)this.models().cube(this.name((Block)block) + "_overpowered", bottom, top_overpowered, side, front_overpowered, front_overpowered, front_overpowered)).texture("particle", top_overpowered);
        }
        if (this.name((Block)block).equals("redstone_lane_i")) {
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.NORTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED)).modelForState().modelFile((ModelFile)unpowered).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.EAST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED)).modelForState().modelFile((ModelFile)unpowered).rotationY(90).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.SOUTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED)).modelForState().modelFile((ModelFile)unpowered).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.WEST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED)).modelForState().modelFile((ModelFile)unpowered).rotationY(90).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.NORTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED)).modelForState().modelFile((ModelFile)powered).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.EAST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED)).modelForState().modelFile((ModelFile)powered).rotationY(90).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.SOUTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED)).modelForState().modelFile((ModelFile)powered).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.WEST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED)).modelForState().modelFile((ModelFile)powered).rotationY(90).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.NORTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED)).modelForState().modelFile((ModelFile)overpowered).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.EAST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED)).modelForState().modelFile((ModelFile)overpowered).rotationY(90).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.SOUTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED)).modelForState().modelFile((ModelFile)overpowered).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.WEST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED)).modelForState().modelFile((ModelFile)overpowered).rotationY(90).addModel();
        } else {
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.NORTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED)).modelForState().modelFile((ModelFile)unpowered).rotationY(180).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.EAST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED)).modelForState().modelFile((ModelFile)unpowered).rotationY(270).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.SOUTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED)).modelForState().modelFile((ModelFile)unpowered).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.WEST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.UNPOWERED)).modelForState().modelFile((ModelFile)unpowered).rotationY(90).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.NORTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED)).modelForState().modelFile((ModelFile)powered).rotationY(180).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.EAST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED)).modelForState().modelFile((ModelFile)powered).rotationY(270).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.SOUTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED)).modelForState().modelFile((ModelFile)powered).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.WEST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.POWERED)).modelForState().modelFile((ModelFile)powered).rotationY(90).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.NORTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED)).modelForState().modelFile((ModelFile)overpowered).rotationY(180).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.EAST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED)).modelForState().modelFile((ModelFile)overpowered).rotationY(270).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.SOUTH).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED)).modelForState().modelFile((ModelFile)overpowered).addModel()).partialState().with((Property)RedstoneLaneBlock.FACING, (Comparable)Direction.WEST).with(RedstoneLaneBlock.REDSTONE_LANE_MODE, (Comparable)((Object)RedstoneLaneMode.OVERPOWERED)).modelForState().modelFile((ModelFile)overpowered).rotationY(90).addModel();
        }
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.extend(this.blockTexture((Block)block), "_unpowered")));
    }

    private void wallBlockWithItem(WallBlock block, Block parent) {
        this.wallBlock(block, this.blockTexture(parent));
        ((ItemModelBuilder)this.itemModels().withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation("dungeonnowloading", "block/" + ForgeRegistries.BLOCKS.getKey((Object)parent).m_135815_()));
    }

    private void wallBlockWithItem(WallBlock block) {
        this.wallBlock(block, this.blockTexture((Block)block));
        ((ItemModelBuilder)this.itemModels().withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation("dungeonnowloading", "block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_()));
    }

    private static int xRotFor(Direction f) {
        return switch (f) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST -> 0;
            case Direction.UP -> 270;
            case Direction.DOWN -> 90;
        };
    }

    private static int yRotFor(Direction f) {
        return switch (f) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> 0;
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.UP, Direction.DOWN -> 0;
        };
    }

    private ResourceLocation baseTex(String baseName, int variant, boolean lit) {
        return this.modLoc("block/" + baseName + "_base_" + variant + (lit ? "_lit" : ""));
    }

    private ResourceLocation outlineTex(String baseName, int outlineStage, boolean lit) {
        return this.modLoc("block/" + baseName + "_outline_" + outlineStage + (lit ? "_lit" : ""));
    }

    private BlockModelBuilder mendingChalkMarkCompositeExact(String modelName, ResourceLocation base, @Nullable ResourceLocation outline) {
        float eps = 0.001f;
        float thick = 0.002f;
        float fx = 0.0f;
        float fy = 0.0f;
        float fz = 15.997f;
        float tx = 16.0f;
        float ty = 16.0f;
        float tz = 15.999f;
        BlockModelBuilder b = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelName)).ao(false)).renderType("cutout")).texture("particle", base)).texture("base", base);
        ModelBuilder.ElementBuilder elem = b.element().from(fx, fy, fz).to(tx, ty, tz);
        elem.face(Direction.SOUTH).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#base").end();
        elem.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#base").end();
        elem.end();
        if (outline != null) {
            b.texture("outline", outline);
            float z = 15.99725f;
            ModelBuilder.ElementBuilder elem2 = b.element().from(0.0f, 0.0f, z).to(16.0f, 16.0f, z);
            elem2.face(Direction.SOUTH).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#outline").end();
            elem2.face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#outline").end();
            elem2.end();
        }
        return b;
    }

    private void generateMendstoneChalkMarkModels(MendstoneChalkMarkBlock block, Item item, IntegerProperty OUTLINE) {
        String baseName = this.name((Block)block);
        String itemName = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        VariantBlockStateBuilder vb = this.getVariantBuilder((Block)block);
        for (Direction f : Direction.values()) {
            int xr = DNLForgeBlockStateProvider.xRotFor(f);
            int yr = DNLForgeBlockStateProvider.yRotFor(f);
            for (boolean lit : new boolean[]{false, true}) {
                for (int outline = 0; outline <= 4; ++outline) {
                    ConfiguredModel[] variants = new ConfiguredModel[6];
                    for (int v = 0; v < 6; ++v) {
                        ResourceLocation base = this.baseTex(baseName, v, lit);
                        ResourceLocation outlineTex = outline <= 3 ? this.outlineTex(baseName, outline, lit) : null;
                        String modelId = baseName + "_lit" + (lit ? "1" : "0") + "_outline" + outline + "_base_" + v;
                        BlockModelBuilder mf = this.mendingChalkMarkCompositeExact(modelId, base, outlineTex);
                        variants[v] = new ConfiguredModel((ModelFile)mf, xr, yr, false, 1);
                    }
                    vb.partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)f).with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(lit)).with((Property)OUTLINE, (Comparable)Integer.valueOf(outline)).addModels(variants);
                }
            }
        }
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(itemName, this.mcLoc("item/generated"))).texture("layer0", this.baseTex(baseName, 0, false))).texture("layer1", this.outlineTex(baseName, 0, false));
    }

    private void fairkeeperSpawnerWithItem(FairkeeperSpawnerBlock block) {
        ResourceLocation side_on = this.extend(this.blockTexture((Block)block), "_on");
        ResourceLocation side_off = this.extend(this.blockTexture((Block)block), "_off");
        ResourceLocation top = this.extend(this.blockTexture((Block)block), "_top");
        ModelBuilder on = ((BlockModelBuilder)this.models().cubeBottomTop(this.name((Block)block) + "_on", side_on, top, top)).renderType("cutout");
        ModelBuilder off = ((BlockModelBuilder)this.models().cubeBottomTop(this.name((Block)block) + "_off", side_off, top, top)).renderType("cutout");
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)DNLProperties.FAIRKEEPER_ALERT, (Comparable)Boolean.TRUE).modelForState().modelFile((ModelFile)on).addModel()).partialState().with((Property)DNLProperties.FAIRKEEPER_ALERT, (Comparable)Boolean.FALSE).modelForState().modelFile((ModelFile)off).addModel();
        this.simpleBlockItem((Block)block, (ModelFile)this.models().getExistingFile(this.extend(this.blockTexture((Block)block), "_off")));
    }

    private void facingSixWayWithExistingModel(Block block, String modelName) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/" + modelName));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> DNLForgeBlockStateProvider.lambda$facingSixWayWithExistingModel$7((ModelFile)model, arg_0), new Property[]{BlockStateProperties.f_61362_});
        this.simpleItem(block);
    }

    private void particleOnlyModel(Block block) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String ns = ForgeRegistries.BLOCKS.getKey((Object)block).m_135827_();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + "_particle")).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:builtin/entity"))).texture("particle", new ResourceLocation(ns, "block/" + name + "_particle"));
        this.getVariantBuilder(block).forAllStates(arg_0 -> DNLForgeBlockStateProvider.lambda$particleOnlyModel$8((ModelFile)model, arg_0));
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$particleOnlyModel$8(ModelFile model, BlockState s) {
        return new ConfiguredModel[]{new ConfiguredModel(model)};
    }

    private static /* synthetic */ ConfiguredModel[] lambda$facingSixWayWithExistingModel$7(ModelFile model, BlockState state) {
        Direction f = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        int x = 0;
        int y = 0;
        switch (f) {
            case UP: {
                x = 0;
                y = 0;
                break;
            }
            case DOWN: {
                x = 180;
                y = 0;
                break;
            }
            case NORTH: {
                x = 90;
                y = 0;
                break;
            }
            case SOUTH: {
                x = 90;
                y = 180;
                break;
            }
            case WEST: {
                x = 90;
                y = 270;
                break;
            }
            case EAST: {
                x = 90;
                y = 90;
            }
        }
        return ConfiguredModel.builder().modelFile(model).rotationX(x).rotationY(y).build();
    }

    private static /* synthetic */ void lambda$fullyRotatedPaneLikeBlockWithItem$5(MultiPartBlockStateBuilder builder, ModelFile side_0, ModelFile side_alt_0, ModelFile no_side_0, ModelFile no_side_alt_0, Map.Entry e) {
        Direction dir = (Direction)e.getKey();
        if (dir.m_122434_().m_122479_()) {
            boolean alt = dir == Direction.SOUTH;
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(!alt && dir != Direction.WEST ? side_0 : side_alt_0).rotationY(dir.m_122434_() == Direction.Axis.X ? 90 : 0).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true}).end().part().modelFile(!alt && dir != Direction.EAST ? no_side_0 : no_side_alt_0).rotationY(dir == Direction.WEST ? 270 : (dir == Direction.SOUTH ? 90 : 0)).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{false});
        }
    }

    private /* synthetic */ void lambda$fullyRotatedVarientWallLikeBlockWithItem$4(MultiPartBlockStateBuilder builder, ModelFile side_0, ModelFile side_tall_0, Map.Entry e) {
        this.wallSidePart(builder, side_0, e, WallSide.LOW);
        this.wallSidePart(builder, side_tall_0, e, WallSide.TALL);
    }

    private static /* synthetic */ void lambda$fullyRotatedVarientFenceLikeBlockWithItem$2(MultiPartBlockStateBuilder builder, ModelFile side_0, Map.Entry e) {
        Direction dir = (Direction)e.getKey();
        if (dir.m_122434_().m_122479_()) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side_0).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$fullyRotatedVarientSlabLikeBlockWithItem$1(ModelFile slabBottom_0, ModelFile slabBottom_90, ModelFile slabBottom_180, ModelFile slabBottom_270, ModelFile slabTop_0, ModelFile slabTop_90, ModelFile slabTop_180, ModelFile slabTop_270, ModelFile slabDouble_0, ModelFile slabDouble_90, ModelFile slabDouble_180, ModelFile slabDouble_270, BlockState state) {
        SlabType slabType = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
        boolean uvlock = false;
        ConfiguredModel[] randomVariants = slabType == SlabType.BOTTOM ? new ConfiguredModel[]{new ConfiguredModel(slabBottom_0), new ConfiguredModel(slabBottom_90), new ConfiguredModel(slabBottom_180), new ConfiguredModel(slabBottom_270)} : (slabType == SlabType.TOP ? new ConfiguredModel[]{new ConfiguredModel(slabTop_0), new ConfiguredModel(slabTop_90), new ConfiguredModel(slabTop_180), new ConfiguredModel(slabTop_270)} : new ConfiguredModel[]{new ConfiguredModel(slabDouble_0), new ConfiguredModel(slabDouble_90), new ConfiguredModel(slabDouble_180), new ConfiguredModel(slabDouble_270)});
        return randomVariants;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$fullyRotatedVarientStairsLikeBlockWithItem$0(ModelFile stairs_model_90, ModelFile stairs_model_180, ModelFile stairs_model_270, ModelFile stairs_model_0, ModelFile stairsInner_model_90, ModelFile stairsInner_model_180, ModelFile stairsInner_model_270, ModelFile stairsInner_model_0, ModelFile stairsOuter_model_90, ModelFile stairsOuter_model_180, ModelFile stairsOuter_model_270, ModelFile stairsOuter_model_0, BlockState state) {
        ModelFile selectedModel;
        boolean uvlock;
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        Half half = (Half)state.m_61143_((Property)BlockStateProperties.f_61402_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)BlockStateProperties.f_61398_);
        int yRot = (int)facing.m_122427_().m_122435_();
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
            yRot += 270;
        }
        if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
            yRot += 90;
        }
        boolean bl = uvlock = (yRot %= 360) != 0 || half == Half.TOP;
        if (shape == StairsShape.STRAIGHT) {
            selectedModel = switch (yRot) {
                case 90 -> stairs_model_90;
                case 180 -> stairs_model_180;
                case 270 -> stairs_model_270;
                default -> stairs_model_0;
            };
        } else if (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT) {
            selectedModel = switch (yRot) {
                case 90 -> stairsInner_model_90;
                case 180 -> stairsInner_model_180;
                case 270 -> stairsInner_model_270;
                default -> stairsInner_model_0;
            };
        } else {
            selectedModel = switch (yRot) {
                case 90 -> stairsOuter_model_90;
                case 180 -> stairsOuter_model_180;
                case 270 -> stairsOuter_model_270;
                default -> stairsOuter_model_0;
            };
        }
        return ConfiguredModel.builder().modelFile(selectedModel).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
    }
}

