/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.client;

import com.google.common.hash.Hashing;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public final class StatueSkinCache {
    private static final boolean LOG = true;
    private static final ResourceLocation DEFAULT_STONE = new ResourceLocation("dungeonnowloading", "textures/block/player_statue_stone.png");
    private static final float DEFAULT_OVERLAY_ALPHA = 0.35f;
    private static final Map<String, StatueSkin> READY = new ConcurrentHashMap<String, StatueSkin>();
    private static final Set<String> INFLIGHT = ConcurrentHashMap.newKeySet();
    private static final ExecutorService EXEC = Executors.newFixedThreadPool(2, r -> {
        Thread t = new Thread(r, "DNL-StatueSkin");
        t.setDaemon(true);
        return t;
    });

    private StatueSkinCache() {
    }

    public static void clear() {
        READY.clear();
        INFLIGHT.clear();
    }

    private static String cacheKey(GameProfile p) {
        if (p.getName() != null && !p.getName().isEmpty()) {
            return "name:" + p.getName().toLowerCase(Locale.ROOT);
        }
        return "uuid:" + (p.getId() != null ? p.getId().toString() : "unknown");
    }

    public static StatueSkin get(GameProfile profile) {
        return StatueSkinCache.get(profile, 0.35f, DEFAULT_STONE);
    }

    public static StatueSkin get(GameProfile profile, float overlayAlpha, ResourceLocation stoneTex) {
        StatueSkin ready;
        if (profile == null) {
            return StatueSkinCache.buildPlaceholder(overlayAlpha, stoneTex, "null-profile");
        }
        String k1 = StatueSkinCache.primaryKey(profile);
        String k2 = k1 != null && k1.startsWith("name:") ? StatueSkinCache.uuidKey(profile) : StatueSkinCache.nameKey(profile);
        StatueSkin statueSkin = ready = k1 != null ? READY.get(k1) : null;
        if (ready == null && k2 != null) {
            ready = READY.get(k2);
        }
        if (ready != null) {
            return ready;
        }
        if (k1 != null && INFLIGHT.add(k1)) {
            StatueSkinCache.startAsyncBuild(profile, k1, overlayAlpha, stoneTex);
        }
        return StatueSkinCache.buildPlaceholder(overlayAlpha, stoneTex, k1 != null ? k1 : "unknown");
    }

    private static void startAsyncBuild(GameProfile profile, String key, float overlayAlpha, ResourceLocation stoneTex) {
        EXEC.submit(() -> {
            try {
                SkinImg s;
                SkinImg skinImg = s = profile != null ? StatueSkinCache.resolveSkinImageAndModel(profile) : null;
                if (s == null || s.img == null) {
                    UUID derived = profile != null ? UUIDUtil.m_235875_((GameProfile)profile) : new UUID(0L, 0L);
                    ResourceLocation def = DefaultPlayerSkin.m_118627_((UUID)derived);
                    boolean slim = "slim".equals(DefaultPlayerSkin.m_118629_((UUID)derived));
                    NativeImage img = StatueSkinCache.readResource(def);
                    if (img == null) {
                        return;
                    }
                    s = new SkinImg(img, slim);
                }
                StatueSkinCache.grayscale(s.img);
                NativeImage stone = StatueSkinCache.readResource(stoneTex);
                if (stone != null) {
                    StatueSkinCache.blendOverlay(s.img, stone, overlayAlpha);
                    stone.close();
                }
                NativeImage finalImg = s.img;
                String seed = key + "|" + String.format(Locale.ROOT, "%.2f", Float.valueOf(overlayAlpha)) + "|" + stoneTex;
                String digest = Hashing.sha1().hashString((CharSequence)seed, StandardCharsets.UTF_8).toString();
                ResourceLocation loc = new ResourceLocation("dungeonnowloading", "statue/" + digest);
                boolean isSlim = s.slim;
                Minecraft.m_91087_().execute(() -> {
                    Minecraft.m_91087_().m_91097_().m_118495_(loc, (AbstractTexture)new DynamicTexture(finalImg));
                    StatueSkin ss = new StatueSkin(loc, isSlim);
                    READY.put(key, ss);
                    String nk = StatueSkinCache.nameKey(profile);
                    String uk = StatueSkinCache.uuidKey(profile);
                    if (nk != null) {
                        READY.put(nk, ss);
                    }
                    if (uk != null) {
                        READY.put(uk, ss);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                INFLIGHT.remove(key);
            }
        });
    }

    private static SkinImg resolveSkinImageAndModel(GameProfile profile) {
        String uuidNoDash;
        try {
            SkinManager sm = Minecraft.m_91087_().m_91109_();
            Map map = sm.m_118815_(profile);
            MinecraftProfileTexture skin = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
            if (skin != null) {
                String model = skin.getMetadata("model");
                boolean slim = "slim".equals(model);
                NativeImage img = StatueSkinCache.downloadPng(skin.getUrl());
                if (img != null) {
                    return new SkinImg(img, slim);
                }
            }
        }
        catch (Exception sm) {
            // empty catch block
        }
        String string = profile.getId() != null ? profile.getId().toString().replace("-", "") : (uuidNoDash = profile.getName() != null ? StatueSkinCache.lookupUuidByName(profile.getName()) : null);
        if (uuidNoDash == null) {
            return null;
        }
        try {
            JsonObject prof = StatueSkinCache.httpJson("https://sessionserver.mojang.com/session/minecraft/profile/" + uuidNoDash);
            if (prof != null && prof.has("properties")) {
                JsonArray props = prof.getAsJsonArray("properties");
                for (int i = 0; i < props.size(); ++i) {
                    NativeImage img;
                    JsonObject md;
                    JsonObject p = props.get(i).getAsJsonObject();
                    if (!"textures".equals(p.get("name").getAsString())) continue;
                    String val = p.get("value").getAsString();
                    String decoded = new String(Base64.getDecoder().decode(val), StandardCharsets.UTF_8);
                    JsonObject textures = JsonParser.parseString((String)decoded).getAsJsonObject().getAsJsonObject("textures");
                    if (textures == null || !textures.has("SKIN")) continue;
                    JsonObject skin = textures.getAsJsonObject("SKIN");
                    String url = skin.get("url").getAsString();
                    boolean slim = false;
                    if (skin.has("metadata") && (md = skin.getAsJsonObject("metadata")).has("model")) {
                        slim = "slim".equals(md.get("model").getAsString());
                    }
                    if ((img = StatueSkinCache.downloadPng(url)) == null) continue;
                    return new SkinImg(img, slim);
                }
            }
        }
        catch (Exception prof) {
            // empty catch block
        }
        boolean slim = "slim".equals(DefaultPlayerSkin.m_118629_((UUID)UUID.fromString(uuidNoDash.replaceFirst("(........)(....)(....)(....)(............)", "$1-$2-$3-$4-$5"))));
        NativeImage img = StatueSkinCache.downloadPng("https://crafatar.com/skins/" + uuidNoDash);
        return img != null ? new SkinImg(img, slim) : null;
    }

    private static NativeImage resolveSkinImage(GameProfile profile) {
        String url = StatueSkinCache.trySkinManager(profile);
        if (url != null) {
            System.out.println("[DNL][Statue] SkinManager URL: " + url);
            NativeImage img = StatueSkinCache.downloadPng(url);
            if (img != null) {
                return img;
            }
        }
        String uuidNoDash = null;
        if (profile.getId() != null) {
            uuidNoDash = profile.getId().toString().replace("-", "");
        } else if (profile.getName() != null && !profile.getName().isEmpty()) {
            uuidNoDash = StatueSkinCache.lookupUuidByName(profile.getName());
            System.out.println("[DNL][Statue] Mojang name\u2192uuid: " + profile.getName() + " -> " + uuidNoDash);
        }
        if (uuidNoDash == null) {
            return null;
        }
        String mojangUrl = StatueSkinCache.lookupSkinUrlViaSessionServer(uuidNoDash);
        if (mojangUrl != null) {
            System.out.println("[DNL][Statue] SessionServer SKIN URL: " + mojangUrl);
            NativeImage img = StatueSkinCache.downloadPng(mojangUrl);
            if (img != null) {
                return img;
            }
        }
        String crafatarUrl = "https://crafatar.com/skins/" + uuidNoDash;
        System.out.println("[DNL][Statue] Crafatar fallback: " + crafatarUrl);
        return StatueSkinCache.downloadPng(crafatarUrl);
    }

    private static String trySkinManager(GameProfile profile) {
        try {
            SkinManager sm = Minecraft.m_91087_().m_91109_();
            Map map = sm.m_118815_(profile);
            MinecraftProfileTexture skin = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
            return skin != null ? skin.getUrl() : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static String lookupUuidByName(String name) {
        try {
            JsonObject o = StatueSkinCache.httpJson("https://api.mojang.com/users/profiles/minecraft/" + name);
            if (o == null || !o.has("id")) {
                return null;
            }
            return o.get("id").getAsString();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static String lookupSkinUrlViaSessionServer(String uuidNoDash) {
        try {
            JsonObject prof = StatueSkinCache.httpJson("https://sessionserver.mojang.com/session/minecraft/profile/" + uuidNoDash);
            if (prof == null || !prof.has("properties")) {
                return null;
            }
            JsonArray props = prof.getAsJsonArray("properties");
            for (int i = 0; i < props.size(); ++i) {
                JsonObject skin;
                JsonObject p = props.get(i).getAsJsonObject();
                if (!"textures".equals(p.get("name").getAsString())) continue;
                String val = p.get("value").getAsString();
                String decoded = new String(Base64.getDecoder().decode(val), StandardCharsets.UTF_8);
                JsonObject textures = JsonParser.parseString((String)decoded).getAsJsonObject().getAsJsonObject("textures");
                if (textures == null || !textures.has("SKIN") || !(skin = textures.getAsJsonObject("SKIN")).has("url")) continue;
                return skin.get("url").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static JsonObject httpJson(String urlStr) {
        try {
            HttpURLConnection c = (HttpURLConnection)new URL(urlStr).openConnection();
            c.setConnectTimeout(5000);
            c.setReadTimeout(5000);
            c.setRequestProperty("User-Agent", "DNL-Statue/1.0");
            try (InputStream in = c.getInputStream();){
                JsonObject jsonObject;
                try (InputStreamReader r = new InputStreamReader(in, StandardCharsets.UTF_8);){
                    jsonObject = JsonParser.parseReader((Reader)r).getAsJsonObject();
                }
                return jsonObject;
            }
        }
        catch (Exception e) {
            System.out.println("[DNL][Statue] httpJson fail " + urlStr + " : " + e.getMessage());
            return null;
        }
    }

    private static NativeImage downloadPng(String urlStr) {
        NativeImage nativeImage;
        block8: {
            HttpURLConnection c = (HttpURLConnection)new URL(urlStr).openConnection();
            c.setConnectTimeout(6000);
            c.setReadTimeout(6000);
            c.setRequestProperty("User-Agent", "DNL-Statue/1.0");
            InputStream in = c.getInputStream();
            try {
                nativeImage = NativeImage.m_85058_((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.out.println("[DNL][Statue] download fail " + urlStr + " : " + e.getMessage());
                    return null;
                }
            }
            in.close();
        }
        return nativeImage;
    }

    private static NativeImage readResource(ResourceLocation rl) {
        NativeImage nativeImage;
        block9: {
            Optional res = Minecraft.m_91087_().m_91098_().m_213713_(rl);
            if (res.isEmpty()) {
                return null;
            }
            InputStream in = ((Resource)res.get()).m_215507_();
            try {
                nativeImage = NativeImage.m_85058_((InputStream)in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.out.println("[DNL][Statue] resource fail " + rl + " : " + e.getMessage());
                    return null;
                }
            }
            in.close();
        }
        return nativeImage;
    }

    private static void grayscale(NativeImage img) {
        int w = img.m_84982_();
        int h = img.m_85084_();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int abgr = img.m_84985_(x, y);
                int a = abgr >>> 24 & 0xFF;
                int b = abgr >>> 16 & 0xFF;
                int g = abgr >>> 8 & 0xFF;
                int r = abgr & 0xFF;
                int gray = (int)(0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b) & 0xFF;
                img.m_84988_(x, y, a << 24 | gray << 16 | gray << 8 | gray);
            }
        }
    }

    private static void blendOverlay(NativeImage base, NativeImage overlay, float alpha) {
        int w = base.m_84982_();
        int h = base.m_85084_();
        int ow = overlay.m_84982_();
        int oh = overlay.m_85084_();
        alpha = Math.max(0.0f, Math.min(1.0f, alpha));
        for (int y = 0; y < h; ++y) {
            int oy = y % oh;
            for (int x = 0; x < w; ++x) {
                int ox = x % ow;
                int bc = base.m_84985_(x, y);
                int a = bc >>> 24 & 0xFF;
                if (a == 0) continue;
                int bb = bc >>> 16 & 0xFF;
                int bg = bc >>> 8 & 0xFF;
                int br = bc & 0xFF;
                int oc = overlay.m_84985_(ox, oy);
                int ob = oc >>> 16 & 0xFF;
                int og = oc >>> 8 & 0xFF;
                int or = oc & 0xFF;
                int oa = oc >>> 24 & 0xFF;
                float oaf = (float)oa / 255.0f * alpha;
                int r = (int)((float)br * (1.0f - oaf) + (float)or * oaf);
                int g = (int)((float)bg * (1.0f - oaf) + (float)og * oaf);
                int b = (int)((float)bb * (1.0f - oaf) + (float)ob * oaf);
                base.m_84988_(x, y, a << 24 | b << 16 | g << 8 | r);
            }
        }
    }

    private static StatueSkin buildPlaceholder(float overlayAlpha, ResourceLocation stoneTex, String keySeed) {
        try {
            UUID derived = new UUID(0L, 0L);
            ResourceLocation def = DefaultPlayerSkin.m_118627_((UUID)derived);
            boolean slim = "slim".equals(DefaultPlayerSkin.m_118629_((UUID)derived));
            NativeImage img = StatueSkinCache.readResource(def);
            if (img != null) {
                StatueSkinCache.grayscale(img);
                NativeImage stone = StatueSkinCache.readResource(stoneTex);
                if (stone != null) {
                    StatueSkinCache.blendOverlay(img, stone, overlayAlpha);
                    stone.close();
                }
                DynamicTexture dyn = new DynamicTexture(img);
                String seed = keySeed + "|ph|" + String.format(Locale.ROOT, "%.2f", Float.valueOf(overlayAlpha)) + "|" + stoneTex;
                String digest = Hashing.sha1().hashString((CharSequence)seed, StandardCharsets.UTF_8).toString();
                ResourceLocation loc = new ResourceLocation("dungeonnowloading", "statue/" + digest);
                Minecraft.m_91087_().m_91097_().m_118495_(loc, (AbstractTexture)dyn);
                return new StatueSkin(loc, slim);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new StatueSkin(stoneTex, false);
    }

    private static String nameKey(GameProfile p) {
        if (p == null) {
            return null;
        }
        return p.getName() != null && !p.getName().isEmpty() ? "name:" + p.getName().toLowerCase(Locale.ROOT) : null;
    }

    private static String uuidKey(GameProfile p) {
        if (p == null) {
            return null;
        }
        return p.getId() != null ? "uuid:" + p.getId() : null;
    }

    private static String primaryKey(GameProfile p) {
        if (p == null) {
            return "null";
        }
        String nk = StatueSkinCache.nameKey(p);
        String uk = StatueSkinCache.uuidKey(p);
        return nk != null ? nk : (uk != null ? uk : "unknown");
    }

    public record StatueSkin(ResourceLocation texture, boolean slim) {
    }

    private static final class SkinImg {
        final NativeImage img;
        final boolean slim;

        SkinImg(NativeImage img, boolean slim) {
            this.img = img;
            this.slim = slim;
        }
    }
}

