/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DuriteClusterBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Map<Direction, VoxelShape> shapes;

    public DuriteClusterBlock(HitboxPreset preset, BlockBehaviour.Properties props) {
        super(props);
        this.shapes = preset.oriented;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    private static Map<Direction, VoxelShape> buildAmethystLikeShapes(int height, int arm) {
        EnumMap<Direction, VoxelShape> m = new EnumMap<Direction, VoxelShape>(Direction.class);
        int a = arm;
        int invA = 16 - arm;
        int invH = 16 - height;
        VoxelShape up = DuriteClusterBlock.m_49796_((double)a, (double)0.0, (double)a, (double)invA, (double)height, (double)invA);
        VoxelShape down = DuriteClusterBlock.m_49796_((double)a, (double)invH, (double)a, (double)invA, (double)16.0, (double)invA);
        VoxelShape north = DuriteClusterBlock.m_49796_((double)a, (double)a, (double)invH, (double)invA, (double)invA, (double)16.0);
        VoxelShape south = DuriteClusterBlock.m_49796_((double)a, (double)a, (double)0.0, (double)invA, (double)invA, (double)height);
        VoxelShape east = DuriteClusterBlock.m_49796_((double)0.0, (double)a, (double)a, (double)height, (double)invA, (double)invA);
        VoxelShape west = DuriteClusterBlock.m_49796_((double)invH, (double)a, (double)a, (double)16.0, (double)invA, (double)invA);
        m.put(Direction.UP, up);
        m.put(Direction.DOWN, down);
        m.put(Direction.NORTH, north);
        m.put(Direction.SOUTH, south);
        m.put(Direction.EAST, east);
        m.put(Direction.WEST, west);
        return m;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        b.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction face = ctx.m_43719_();
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)face)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        BlockPos behind = pos.m_121945_(face.m_122424_());
        return level.m_8055_(behind).m_60783_((BlockGetter)level, behind, face);
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return dir == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, dir, neighbor, level, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.shapes.get(state.m_61143_((Property)FACING));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static enum HitboxPreset {
        SMALL(3, 10),
        MEDIUM(4, 10),
        LARGE(6, 8),
        CLUSTER(7, 6);

        final Map<Direction, VoxelShape> oriented;

        private HitboxPreset(int height, int cross) {
            int arm = cross / 2;
            this.oriented = DuriteClusterBlock.buildAmethystLikeShapes(height, arm);
        }
    }

    public static enum Stage {
        SMALL,
        MEDIUM,
        LARGE,
        CLUSTER;

    }
}

