/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.math.Transformation;
import corgitaco.corgilib.platform.ModPlatform;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class PlaceAllCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder placeAll = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"place_all").requires(commandSourceStack -> commandSourceStack.m_6761_(3) && commandSourceStack.m_81377_().m_129792_());
        placeAll.then(LiteralArgumentBuilder.literal((String)"templates").then(Commands.m_82129_((String)"mod_id", (ArgumentType)StringArgumentType.word()).suggests((context1, builder) -> SharedSuggestionProvider.m_82970_(ModPlatform.PLATFORM.getModIDS(), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)commandBuildContext)).then(Commands.m_82129_((String)"depth", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            BlockInput blockInput = BlockStateArgument.m_116123_((CommandContext)context, (String)"block");
            PlaceAllCommand.dumpTemplates(((CommandSourceStack)context.getSource()).m_81371_(), ((CommandSourceStack)context.getSource()).m_81372_(), StringArgumentType.getString((CommandContext)context, (String)"mod_id"), blockInput.m_114669_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"depth"));
            return 1;
        })))));
        placeAll.then(LiteralArgumentBuilder.literal((String)"features").then(Commands.m_82129_((String)"mod_id", (ArgumentType)StringArgumentType.word()).suggests((context1, builder) -> SharedSuggestionProvider.m_82970_(ModPlatform.PLATFORM.getModIDS(), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)commandBuildContext)).then(Commands.m_82129_((String)"depth", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            BlockInput blockInput = BlockStateArgument.m_116123_((CommandContext)context, (String)"block");
            PlaceAllCommand.dumpConfiguredFeatures(((CommandSourceStack)context.getSource()).m_81371_(), ((CommandSourceStack)context.getSource()).m_81372_(), StringArgumentType.getString((CommandContext)context, (String)"mod_id"), blockInput.m_114669_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"depth"));
            return 1;
        })))));
        placeAll.then(LiteralArgumentBuilder.literal((String)"structures").then(Commands.m_82129_((String)"mod_id", (ArgumentType)StringArgumentType.word()).suggests((context1, builder) -> SharedSuggestionProvider.m_82970_(ModPlatform.PLATFORM.getModIDS(), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)commandBuildContext)).then(Commands.m_82129_((String)"depth", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            BlockInput blockInput = BlockStateArgument.m_116123_((CommandContext)context, (String)"block");
            PlaceAllCommand.dumpStructures(((CommandSourceStack)context.getSource()).m_81371_(), ((CommandSourceStack)context.getSource()).m_81372_(), StringArgumentType.getString((CommandContext)context, (String)"mod_id"), blockInput.m_114669_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"depth"));
            return 1;
        })))));
        dispatcher.then((ArgumentBuilder)placeAll);
    }

    private static void dumpTemplates(Vec3 position, ServerLevel serverLevel, String modId, BlockState state, int floorDepth) {
        StructureTemplateManager structureManager = serverLevel.m_215082_();
        List<ResourceLocation> list = structureManager.m_230355_().filter(location -> location.m_135827_().equalsIgnoreCase(modId)).sorted().toList();
        int size = list.size();
        int rowsAndCols = (int)Math.floor(Math.sqrt(size) / 2.0);
        PlaceAllCommand.generateObject(position, serverLevel, rowsAndCols, 48, state, floorDepth, (idx, pos) -> {
            ResourceLocation templateLocation = (ResourceLocation)list.get((int)idx);
            StructureTemplate structureTemplate = (StructureTemplate)structureManager.m_230407_(templateLocation).get();
            structureTemplate.m_230328_((ServerLevelAccessor)serverLevel, pos, pos, new StructurePlaceSettings(), serverLevel.f_46441_, 2);
            Vec3i structureTemplateSize = structureTemplate.m_163801_();
            PlaceAllCommand.generateText(serverLevel, Vec3.m_82512_((Vec3i)pos.m_7918_(structureTemplateSize.m_123341_() / 2, structureTemplateSize.m_123342_() + 3, structureTemplateSize.m_123343_() / 2)), templateLocation.toString());
        });
    }

    public static void dumpConfiguredFeatures(Vec3 position, ServerLevel serverLevel, String modId, BlockState state, int floorDepth) {
        List<Holder.Reference> list = ((Registry)serverLevel.m_9598_().m_6632_(Registries.f_256911_).get()).m_203611_().filter(reference -> reference.m_205785_().m_135782_().m_135827_().equalsIgnoreCase(modId)).sorted(Comparator.comparing(holder -> holder.m_205785_().m_135782_())).toList();
        int size = list.size();
        int rowsAndCols = (int)Math.floor(Math.sqrt(size) / 2.0);
        PlaceAllCommand.generateObject(position, serverLevel, rowsAndCols, 32, state, floorDepth, (idx, offset) -> {
            Holder.Reference configuredFeatureReference = (Holder.Reference)list.get((int)idx);
            String textComponent = "";
            if (!((ConfiguredFeature)configuredFeatureReference.m_203334_()).m_224953_((WorldGenLevel)serverLevel, serverLevel.m_7726_().m_8481_(), serverLevel.f_46441_, offset)) {
                textComponent = "Failed: ";
            }
            PlaceAllCommand.generateText(serverLevel, Vec3.m_82512_((Vec3i)offset.m_6630_(32)), textComponent + configuredFeatureReference.m_205785_().m_135782_().toString());
        });
    }

    public static void dumpStructures(Vec3 position, ServerLevel serverLevel, String modId, BlockState state, int floorDepth) {
        List<Holder.Reference> list = ((Registry)serverLevel.m_9598_().m_6632_(Registries.f_256944_).get()).m_203611_().filter(reference -> reference.m_205785_().m_135782_().m_135827_().equalsIgnoreCase(modId)).sorted(Comparator.comparing(holder -> holder.m_205785_().m_135782_())).toList();
        int size = list.size();
        int rowsAndCols = (int)Math.floor(Math.sqrt(size) / 2.0);
        PlaceAllCommand.generateObject(position, serverLevel, rowsAndCols, 512, state, floorDepth, (idx, offset) -> {
            Holder.Reference structureReference = (Holder.Reference)list.get((int)idx);
            structureReference.m_203439_().right().ifPresent(structure -> {
                ChunkGenerator generator = serverLevel.m_7726_().m_8481_();
                StructureStart generatedStart = structure.m_226596_(serverLevel.m_9598_(), generator, generator.m_62218_(), serverLevel.m_7726_().m_214994_(), serverLevel.m_215082_(), serverLevel.m_7328_(), new ChunkPos(offset), 0, (LevelHeightAccessor)serverLevel, biomeHolder -> true);
                BoundingBox boundingBox = generatedStart.m_73601_();
                ChunkPos start = new ChunkPos(SectionPos.m_123171_((int)boundingBox.m_162395_()), SectionPos.m_123171_((int)boundingBox.m_162398_()));
                ChunkPos end = new ChunkPos(SectionPos.m_123171_((int)boundingBox.m_162399_()), SectionPos.m_123171_((int)boundingBox.m_162401_()));
                ChunkPos.m_45599_((ChunkPos)start, (ChunkPos)end).forEach(chunkPos -> generatedStart.m_226850_((WorldGenLevel)serverLevel, serverLevel.m_215010_(), generator, serverLevel.m_213780_(), new BoundingBox(chunkPos.m_45604_(), serverLevel.m_141937_(), chunkPos.m_45605_(), chunkPos.m_45608_(), serverLevel.m_151558_(), chunkPos.m_45609_()), chunkPos));
            });
        });
    }

    public static void generateObject(Vec3 position, ServerLevel serverLevel, int rowsAndCols, int size, BlockState floorBlock, int floorDepth, BiConsumer<Integer, BlockPos> consumer) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int templateIDX = 0;
        for (int x = -rowsAndCols; x <= rowsAndCols; ++x) {
            for (int z = -rowsAndCols; z <= rowsAndCols; ++z) {
                for (int xFill = 0; xFill <= size; ++xFill) {
                    for (int zFill = 0; zFill <= size; ++zFill) {
                        for (int y = 0; y < floorDepth; ++y) {
                            mutableBlockPos.m_122178_((int)position.m_7096_() + x * size + xFill, (int)position.f_82480_ - y, (int)position.m_7094_() + z * size + zFill);
                            serverLevel.m_6933_((BlockPos)mutableBlockPos, floorBlock, 2, 0);
                        }
                    }
                }
                mutableBlockPos.m_122169_((double)((int)position.f_82479_ + x * size + 16), position.f_82480_ + 1.0, (double)((int)position.f_82481_ + z * size + 16));
                consumer.accept(templateIDX, (BlockPos)mutableBlockPos);
                ++templateIDX;
            }
        }
    }

    private static void generateText(ServerLevel serverLevel, Vec3 spawnPos, String displayText) {
        Display.TextDisplay textDisplay = new Display.TextDisplay(EntityType.f_268607_, (Level)serverLevel);
        textDisplay.m_146884_(spawnPos);
        textDisplay.m_269037_((Component)Component.m_237113_((String)displayText));
        Matrix4f matrix = new Matrix4f();
        matrix.scale(5.0f);
        textDisplay.m_269214_(new Transformation(matrix));
        textDisplay.m_269423_(Display.BillboardConstraints.CENTER);
        serverLevel.m_7967_((Entity)textDisplay);
    }
}

