/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.block.component.tile;

import codechicken.lib.block.ModularBlockEntity;
import codechicken.lib.block.ModularTileBlock;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class InventoryComponent
extends ModularTileBlock.TileComponent<Data> {
    private final int size;
    private final int limit;
    private final List<Listener> changeListeners = new LinkedList<Listener>();

    private InventoryComponent(int size, int limit) {
        this.size = size;
        this.limit = limit;
    }

    public void onChanged(Listener listener) {
        this.changeListeners.add(listener);
    }

    @Override
    protected Data createData(ModularBlockEntity ent) {
        return new Data(ent, this, this.size, this.limit);
    }

    public class Data
    extends ModularBlockEntity.DataComponent
    implements Container {
        private final ItemStack[] items;
        private final int limit;

        protected Data(ModularBlockEntity tile, ModularTileBlock.TileComponent<?> tileComponent, int size, int limit) {
            super(tile, tileComponent);
            this.items = ArrayUtils.fill(new ItemStack[size], ItemStack.f_41583_);
            this.limit = limit;
        }

        public void m_6211_() {
            ArrayUtils.fill(this.items, ItemStack.f_41583_);
        }

        public int m_6643_() {
            return this.items.length;
        }

        public boolean m_7983_() {
            for (ItemStack item : this.items) {
                if (item.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int slot) {
            return this.items[slot];
        }

        public ItemStack m_7407_(int slot, int amount) {
            return InventoryUtils.decrStackSize(this, slot, amount);
        }

        public ItemStack m_8016_(int slot) {
            return InventoryUtils.removeStackFromSlot(this, slot);
        }

        public void m_6836_(int slot, ItemStack stack) {
            this.items[slot] = stack;
            this.m_6596_();
        }

        public void m_6596_() {
            this.tile.m_6596_();
            for (Listener listener : InventoryComponent.this.changeListeners) {
                listener.onChanged(this);
            }
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public int m_6893_() {
            return this.limit;
        }

        @Override
        protected void save(CompoundTag tag) {
            tag.m_128365_("Items", (Tag)InventoryUtils.writeItemStacksToTag(this.items));
        }

        @Override
        protected void load(CompoundTag tag) {
            InventoryUtils.readItemStacksFromTag(this.items, tag.m_128437_("Items", 10));
        }
    }

    public static interface Listener {
        public void onChanged(Data var1);
    }
}

