/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.TeleportUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class TargetPos {
    private Vector3 pos;
    private float yaw;
    private float pitch;
    private boolean includeHeading = true;
    private ResourceKey<Level> dimension;

    public TargetPos() {
    }

    public TargetPos(Entity entity) {
        this(entity, true);
    }

    public TargetPos(CompoundTag nbt) {
        this.readFromNBT(nbt);
    }

    public TargetPos(Entity entity, boolean includeHeading) {
        this.update(entity);
        this.includeHeading = includeHeading;
    }

    public TargetPos(double x, double y, double z, ResourceKey<Level> dimension) {
        this(new Vector3(x, y, z), dimension);
    }

    public TargetPos(double x, double y, double z, ResourceKey<Level> dimension, float pitch, float yaw) {
        this(new Vector3(x, y, z), dimension, pitch, yaw);
    }

    public TargetPos(Vector3 pos, ResourceKey<Level> dimension) {
        this(pos, dimension, 0.0f, 0.0f);
    }

    public TargetPos(Vector3 pos, ResourceKey<Level> dimension, float pitch, float yaw) {
        this.pos = pos;
        this.dimension = dimension;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public void update(Entity player) {
        this.pos = Vector3.fromEntity((Entity)player);
        this.dimension = player.m_9236_().m_46472_();
        this.pitch = player.m_146909_();
        this.yaw = player.m_146908_();
    }

    public double getX() {
        return this.pos.x;
    }

    public double getY() {
        return this.pos.y;
    }

    public double getZ() {
        return this.pos.z;
    }

    public Vector3 getPos() {
        return this.pos;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public String getReadableName(boolean fullDim) {
        return "X: " + (int)Math.floor(this.pos.x) + ", Y: " + (int)Math.floor(this.pos.y) + ", Z: " + (int)Math.floor(this.pos.z) + ", " + (Comparable)(fullDim ? this.dimension.m_135782_() : this.dimension.m_135782_().m_135815_());
    }

    public TargetPos setIncludeHeading(boolean includeHeading) {
        this.includeHeading = includeHeading;
        return this;
    }

    public TargetPos setX(double x) {
        this.pos.x = x;
        return this;
    }

    public TargetPos setY(double y) {
        this.pos.y = y;
        return this;
    }

    public TargetPos setZ(double z) {
        this.pos.z = z;
        return this;
    }

    public TargetPos setPos(Vector3 pos) {
        this.pos = pos;
        return this;
    }

    public TargetPos setDimension(ResourceKey<Level> d) {
        this.dimension = d;
        return this;
    }

    public TargetPos setPitch(float p) {
        this.pitch = p;
        return this;
    }

    public TargetPos setYaw(float y) {
        this.yaw = y;
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        this.pos.writeToNBT(nbt);
        nbt.m_128359_("dim", this.dimension.m_135782_().toString());
        nbt.m_128379_("heading", this.includeHeading);
        if (this.includeHeading) {
            nbt.m_128350_("pitch", this.pitch);
            nbt.m_128350_("yaw", this.yaw);
        }
        return nbt;
    }

    public CompoundTag writeToNBT() {
        return this.writeToNBT(new CompoundTag());
    }

    public void readFromNBT(CompoundTag nbt) {
        this.pos = Vector3.fromNBT((CompoundTag)nbt);
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dim")));
        this.includeHeading = nbt.m_128471_("heading");
        if (this.includeHeading) {
            this.pitch = nbt.m_128457_("pitch");
            this.yaw = nbt.m_128457_("yaw");
        }
    }

    public void write(MCDataOutput output) {
        output.writeVector(this.pos);
        output.writeResourceLocation(this.dimension.m_135782_());
        output.writeBoolean(this.includeHeading);
        if (this.includeHeading) {
            output.writeFloat(this.pitch);
            output.writeFloat(this.yaw);
        }
    }

    public void read(MCDataInput input) {
        this.pos = input.readVector();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)input.readResourceLocation());
        this.includeHeading = input.readBoolean();
        if (this.includeHeading) {
            this.pitch = input.readFloat();
            this.yaw = input.readFloat();
        }
    }

    public Entity teleport(Entity entity) {
        if (this.includeHeading) {
            return TeleportUtils.teleportEntity(entity, this.dimension, this.pos, this.yaw, this.pitch);
        }
        return TeleportUtils.teleportEntity(entity, this.dimension, this.pos);
    }
}

