/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.IMCDataSerializable;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterGroup;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class FilterBase
implements INBTSerializable<CompoundTag>,
IMCDataSerializable {
    private final EntityFilter filter;
    protected int nodeID = -1;
    private FilterGroup parent;

    public FilterBase(EntityFilter filter) {
        this.filter = filter;
    }

    public abstract boolean test(Entity var1);

    public int getNodeId() {
        return this.nodeID;
    }

    protected void initNode(FilterGroup parent) {
        this.parent = parent;
        this.nodeID = this.getFilter().getNextNodeID();
        this.getFilter().trackNode(this);
    }

    public void onLoaded(FilterGroup parent) {
        this.parent = parent;
    }

    public FilterGroup getParent() {
        return this.parent;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("node_id", this.nodeID);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.nodeID = compound.m_128451_("node_id");
        this.getFilter().trackNode(this);
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        output.writeVarInt(this.nodeID);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        this.nodeID = input.readVarInt();
        this.getFilter().trackNode(this);
    }

    public abstract FilterType getType();

    public EntityFilter getFilter() {
        return this.filter;
    }

    public String getTranslationKey() {
        return "mod_gui.brandonscore.entity_filter." + this.getType().name().toLowerCase(Locale.ENGLISH);
    }
}

