/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.ModularGuiScreen;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiColourPicker;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiEntityRenderer;
import codechicken.lib.gui.modular.elements.GuiEventProvider;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.lib.ColourState;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiProvider;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.handlers.contributor.ContributorConfig;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ContributorConfigGui
implements GuiProvider {
    protected GuiToolkit toolkit = new GuiToolkit("");
    private final Player player;
    private final ContributorProperties props;
    private final ContributorConfig cfg;
    private final ColourState wingColourA;
    private final ColourState wingColourB;
    private final ColourState shieldColour;
    private final Map<Integer, GuiColourPicker> pickers = new HashMap<Integer, GuiColourPicker>();
    private boolean dragging = false;
    private GuiManipulable container;
    private GuiEntityRenderer playerRender;
    double lastMouseX = 0.0;

    public ContributorConfigGui(Player player, ContributorProperties props) {
        this.player = player;
        this.props = props;
        this.cfg = props.getConfig();
        this.wingColourA = ColourState.create(this.cfg::getWingsOverrideBoneColour, this.cfg::setWingsOverrideBoneColour);
        this.wingColourB = ColourState.create(this.cfg::getWingsOverrideWebColour, this.cfg::setWingsOverrideWebColour);
        this.shieldColour = ColourState.create(this.cfg::getShieldOverride, this.cfg::setShieldOverride);
    }

    public GuiElement<?> createRootElement(ModularGui gui) {
        return super.createRootElement(gui);
    }

    public void buildGui(ModularGui gui) {
        gui.initFullscreenGui();
        gui.setGuiTitle((Component)Component.m_237113_((String)"Contributor Configuration"));
        GuiElement root = gui.getRoot();
        GuiElement<?> title = this.toolkit.floatingHeading(gui);
        Constraints.placeInside(title, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)15.0);
        this.container = new GuiManipulable((GuiParent)root).addMoveHandle(100).enableCursors(true);
        Constraints.size((ConstrainedGeometry)this.container, (double)100.0, (double)100.0);
        Constraints.center((ConstrainedGeometry)this.container, (ConstrainedGeometry)root);
        gui.onResize(() -> this.container.resetBounds());
        this.playerRender = new GuiEntityRenderer((GuiParent)this.container.getContentElement()).setForce2dSize(true).setEntity((Entity)this.player);
        Constraints.size((ConstrainedGeometry)this.playerRender, (double)100.0, (double)100.0);
        Constraints.center((ConstrainedGeometry)this.playerRender, (ConstrainedGeometry)this.container.getContentElement());
        GuiButton rotateButton = this.createButton(root, "Rotate").setToggleMode(() -> !this.playerRender.isRotationLocked()).onPress(() -> this.playerRender.setRotationLocked(!this.playerRender.isRotationLocked()));
        Constraints.size((ConstrainedGeometry)rotateButton, (double)80.0, (double)16.0);
        Constraints.placeInside((ConstrainedGeometry)rotateButton, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-9.0);
        this.createControls(root);
        new GuiEventProvider((GuiParent)root).onMouseClick(this::mouseClicked).onMouseRelease(this::mouseReleased).onScroll(this::mouseScrolled).onMouseMove(this::mouseDragged);
    }

    private void createControls(GuiElement<?> root) {
        double width = 150.0;
        double height = 14.0;
        GuiElement last = this.createEnableButton(root, "Shield Colour: ", this.cfg::overrideShield, this.cfg::setOverrideShield, "Custom", "Default").setEnabled(this.props::hasShieldRGB);
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        Constraints.placeInside((ConstrainedGeometry)last, root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_LEFT, (double)3.0, (double)-3.0);
        GuiButton pickerBtn = this.colourPickerButton(root, this.shieldColour, 2, () -> this.cfg.getBaseColourI(this.cfg.getWingsTier()));
        pickerBtn.setEnabled(this.cfg::overrideShield);
        Constraints.size((ConstrainedGeometry)pickerBtn, (double)height, (double)height);
        Constraints.placeOutside((ConstrainedGeometry)pickerBtn, (ConstrainedGeometry)last, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)1.0, (double)0.0);
        GuiButton rgbBtn = this.colourRGBButton(root, this.cfg::getShieldRGB, this.cfg::setShieldRGB);
        rgbBtn.setEnabled(this.cfg::overrideShield);
        Constraints.size((ConstrainedGeometry)rgbBtn, (double)height, (double)height);
        Constraints.placeOutside((ConstrainedGeometry)rgbBtn, (ConstrainedGeometry)pickerBtn, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)1.0, (double)0.0);
        last = (GuiElement)((GuiButton)((GuiButton)this.createEnableButton(root, "Wings Shader B: ", this.cfg::getWingsWebShader, this.cfg::setWingsWebShader).setEnabled(this.props::hasWings)).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)last.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.TOP), (double)-1.0));
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        last = (GuiElement)((GuiButton)((GuiButton)this.createEnableButton(root, "Wings Shader A: ", this.cfg::getWingsBoneShader, this.cfg::setWingsBoneShader).setEnabled(this.props::hasWings)).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)last.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.TOP), (double)-1.0));
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        last = (GuiElement)((GuiButton)((GuiButton)this.createEnableButton(root, "Wings Colour B: ", this.cfg::overrideWingWebColour, this.cfg::setOverrideWingsWebColour, "Custom", "Default").setEnabled(this.props::hasWingsRGB)).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)last.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.TOP), (double)-1.0));
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        pickerBtn = this.colourPickerButton(root, this.wingColourB, 1, () -> this.cfg.getBaseColourI(this.cfg.getWingsTier()));
        pickerBtn.setEnabled(this.cfg::overrideWingWebColour);
        Constraints.size((ConstrainedGeometry)pickerBtn, (double)height, (double)height);
        Constraints.placeOutside((ConstrainedGeometry)pickerBtn, (ConstrainedGeometry)last, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)1.0, (double)0.0);
        rgbBtn = this.colourRGBButton(root, this.cfg::getWingRGBWebColour, this.cfg::setWingRGBWebColour);
        rgbBtn.setEnabled(this.cfg::overrideWingWebColour);
        Constraints.size((ConstrainedGeometry)rgbBtn, (double)height, (double)height);
        Constraints.placeOutside((ConstrainedGeometry)rgbBtn, (ConstrainedGeometry)pickerBtn, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)1.0, (double)0.0);
        last = (GuiElement)((GuiButton)((GuiButton)this.createEnableButton(root, "Wings Colour A: ", this.cfg::overrideWingBoneColour, this.cfg::setOverrideWingBoneColour, "Custom", "Default").setEnabled(this.props::hasWingsRGB)).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)last.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.TOP), (double)-1.0));
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        pickerBtn = this.colourPickerButton(root, this.wingColourA, 0, () -> this.cfg.getBaseColourI(this.cfg.getWingsTier()));
        pickerBtn.setEnabled(this.cfg::overrideWingBoneColour);
        Constraints.size((ConstrainedGeometry)pickerBtn, (double)height, (double)height);
        Constraints.placeOutside((ConstrainedGeometry)pickerBtn, (ConstrainedGeometry)last, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)1.0, (double)0.0);
        rgbBtn = this.colourRGBButton(root, this.cfg::getWingRGBBoneColour, this.cfg::setWingRGBBoneColour);
        rgbBtn.setEnabled(this.cfg::overrideWingBoneColour);
        Constraints.size((ConstrainedGeometry)rgbBtn, (double)height, (double)height);
        Constraints.placeOutside((ConstrainedGeometry)rgbBtn, (ConstrainedGeometry)pickerBtn, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)1.0, (double)0.0);
        last = (GuiElement)((GuiButton)((GuiButton)this.createListButton(root, "Wings: ", this.cfg::getWingsTier, this.cfg::setWingsTier, this.props.getWingTiers(), true).setEnabled(() -> !this.props.getWingTiers().isEmpty())).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)last.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.TOP), (double)-1.0));
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        last = this.createEnumButton(root, "Elytra: ", ContributorConfig.WingElytraCompat.class, this.cfg::getWingsElytra, this.cfg::setWingsElytra).setEnabled(this.props::hasWings);
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        Constraints.placeInside((ConstrainedGeometry)last, root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_RIGHT, (double)-3.0, (double)-3.0);
        last = (GuiElement)((GuiButton)((GuiButton)((GuiButton)this.createEnumButton(root, "Creative: ", ContributorConfig.WingBehavior.class, this.cfg::getWingsCreative, this.cfg::setWingsCreative).setEnabled(this.props::hasWings)).setTooltip(new Component[]{Component.m_237113_((String)"When using creative style flight")})).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)last.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.TOP), (double)-1.0));
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        last = (GuiElement)((GuiButton)((GuiButton)((GuiButton)this.createEnumButton(root, "Grounded: ", ContributorConfig.WingBehavior.class, this.cfg::getWingsGround, this.cfg::setWingsGround).setEnabled(this.props::hasWings)).setTooltip(new Component[]{Component.m_237113_((String)"What happens when you are not flying")})).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)last.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.TOP), (double)-1.0));
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        last = (GuiElement)((GuiText)((GuiText)new GuiText(root, (Component)Component.m_237113_((String)" Wing Behavior ").m_130940_(ChatFormatting.UNDERLINE)).setEnabled(this.props::hasWings)).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)last.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.TOP), (double)-1.0));
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        last = (GuiElement)((GuiButton)((GuiButton)this.createListButton(root, "Back Badge: ", this.cfg::getBackBadge, this.cfg::setBackBadge, this.props.getBadges(), false).setEnabled(() -> !this.props.getBadges().isEmpty())).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)last.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.TOP), (double)-1.0));
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        last = (GuiElement)((GuiButton)((GuiButton)this.createListButton(root, "Front Badge: ", this.cfg::getChestBadge, this.cfg::setChestBadge, this.props.getBadges(), false).setEnabled(() -> !this.props.getBadges().isEmpty())).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)last.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.TOP), (double)-1.0));
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
        last = (GuiElement)((GuiButton)this.createEnableButton(root, "Welcome Message: ", this.cfg::showWelcome, this.cfg::setShowWelcome).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)last.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.TOP), (double)-1.0));
        Constraints.size((ConstrainedGeometry)last, (double)width, (double)height);
    }

    public void mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.playerRender.isMouseOver()) {
            this.dragging = true;
            this.lastMouseX = mouseX;
        }
    }

    public void mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
    }

    public void mouseDragged(double mouseX, double mouseY) {
        if (this.dragging) {
            this.playerRender.setLockedRotation(this.playerRender.getLockedRotation() + (float)(mouseX - this.lastMouseX));
            this.lastMouseX = mouseX;
        }
    }

    public void mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        double size = this.playerRender.xSize();
        size = (int)MathHelper.clip((double)(size + scrollAmount * Math.max(size / 10.0, 1.0)), (double)10.0, (double)500.0);
        this.playerRender.setSize(size, size);
    }

    private GuiButton createButton(GuiElement<?> parent, String text) {
        GuiButton button = GuiButton.flatColourButton(parent, () -> Component.m_237113_((String)text), hover -> hover != false ? -1877909487 : -1879048192, hover -> hover != false ? -7302913 : -10461088);
        button.getLabel().setTextColour(() -> GuiToolkit.Palette.Ctrl.textH(button.isMouseOver()));
        return button;
    }

    private GuiButton createEnableButton(GuiElement<?> parent, String text, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return this.createEnableButton(parent, text, getter, setter, "Enabled", "Disabled");
    }

    private GuiButton createEnableButton(GuiElement<?> parent, String text, Supplier<Boolean> getter, Consumer<Boolean> setter, String trueText, String falseText) {
        GuiButton button = GuiButton.flatColourButton(parent, () -> Component.m_237113_((String)(text + ((Boolean)getter.get() != false ? trueText : falseText))), hover -> hover != false ? -1877909487 : -1879048192, hover -> hover != false ? -7302913 : -10461088).setToggleMode(getter).onPress(() -> setter.accept((Boolean)getter.get() == false));
        button.getLabel().setTextColour(() -> GuiToolkit.Palette.Ctrl.textH(button.isMouseOver()));
        return button;
    }

    private <T> GuiButton createListButton(GuiElement<?> parent, String text, Supplier<T> getter, Consumer<T> setter, List<T> values, boolean nullOption) {
        Consumer<Integer> onPress = dir -> {
            if (values.isEmpty()) {
                return;
            }
            Object current = getter.get();
            int index = current == null ? values.size() : values.indexOf(current);
            index = Math.floorMod(index + dir, nullOption ? values.size() + 1 : values.size());
            setter.accept(index == values.size() ? null : (Object)values.get(index));
        };
        GuiButton button = ((GuiButton)GuiButton.flatColourButton(parent, () -> Component.m_237113_((String)(text + (getter.get() == null ? "Disabled" : getter.get().toString()))), hover -> hover != false ? -1877909487 : -1879048192, hover -> hover != false ? -7302913 : -10461088).setTooltip(() -> {
            List<Object> list;
            Object patt14324$temp = getter.get();
            if (patt14324$temp instanceof ContributorConfig.HoverText) {
                ContributorConfig.HoverText h = (ContributorConfig.HoverText)patt14324$temp;
                list = h.getHoverText();
            } else {
                list = Collections.emptyList();
            }
            return list;
        })).onPress(() -> onPress.accept(1), 0).onPress(() -> onPress.accept(-1), 1);
        button.getLabel().setTextColour(() -> GuiToolkit.Palette.Ctrl.textH(button.isMouseOver()));
        return button;
    }

    private GuiButton colourPickerButton(GuiElement<?> parent, ColourState state, int index, Supplier<Integer> defCol) {
        GuiButton button = this.toolkit.createIconButton((GuiParent<?>)parent, 14, BCGuiTextures.getter("color_picker"));
        button.onPress(() -> {
            GuiColourPicker picker = this.pickers.remove(index);
            if (picker != null && !picker.isRemoved()) {
                picker.getParent().removeChild((GuiElement)picker);
                return;
            }
            picker = GuiColourPicker.create((GuiParent)parent, (ColourState)state, (boolean)true);
            this.pickers.put(index, picker);
            picker.addMoveHandle((int)picker.ySize());
            picker.enableCursors(true);
            if (index < 2) {
                Constraints.placeInside((ConstrainedGeometry)picker, (ConstrainedGeometry)parent, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)(4.0 + (picker.xSize() + 4.0) * (double)index), (double)4.0);
            } else {
                Constraints.placeInside((ConstrainedGeometry)picker, (ConstrainedGeometry)parent, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)(-4.0 - (picker.xSize() + 4.0) * (double)(index - 2)), (double)4.0);
            }
        });
        return button;
    }

    private GuiButton colourRGBButton(GuiElement<?> parent, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return ((GuiButton)this.toolkit.createIconButton((GuiParent<?>)parent, 14, BCGuiTextures.getter("rgb_checker")).setToggleMode(getter).setTooltip(new Component[]{Component.m_237113_((String)"Enable rainbow RGB mode."), Component.m_237113_((String)"Use the colour picker to configure,"), Component.m_237113_((String)"Red = Cycle Speed"), Component.m_237113_((String)"Green = Saturation"), Component.m_237113_((String)"Blue = Brightness")})).onPress(() -> setter.accept((Boolean)getter.get() == false));
    }

    private <E extends Enum<E>> GuiButton createEnumButton(GuiElement<?> parent, String text, Class<E> clazz, Supplier<E> getter, Consumer<E> setter) {
        GuiButton button = ((GuiButton)GuiButton.flatColourButton(parent, () -> Component.m_237113_((String)(text + ((Enum)getter.get()).toString())), hover -> hover != false ? -1877909487 : -1879048192, hover -> hover != false ? -7302913 : -10461088).setTooltip(() -> {
            List<Object> list;
            Object patt16718$temp = getter.get();
            if (patt16718$temp instanceof ContributorConfig.HoverText) {
                ContributorConfig.HoverText h = (ContributorConfig.HoverText)patt16718$temp;
                list = h.getHoverText();
            } else {
                list = Collections.emptyList();
            }
            return list;
        })).onPress(() -> setter.accept(((Enum[])clazz.getEnumConstants())[(((Enum)getter.get()).ordinal() + 1) % ((Enum[])clazz.getEnumConstants()).length]), 0).onPress(() -> setter.accept(((Enum[])clazz.getEnumConstants())[(((Enum)getter.get()).ordinal() - 1) % ((Enum[])clazz.getEnumConstants()).length]), 1);
        button.getLabel().setTextColour(() -> GuiToolkit.Palette.Ctrl.textH(button.isMouseOver()));
        return button;
    }

    public static class Screen
    extends ModularGuiScreen {
        public Screen(Player player, ContributorProperties props) {
            super((GuiProvider)new ContributorConfigGui(player, props));
        }
    }
}

