/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityProviderSerializable<T extends INBTSerializable<CompoundTag>>
implements ICapabilitySerializable<CompoundTag> {
    protected final Capability<T> capability;
    protected final T instance;
    protected final LazyOptional<T> instanceOpt;

    public CapabilityProviderSerializable(Capability<T> capability, T instance) {
        this.capability = capability;
        this.instance = instance;
        this.instanceOpt = LazyOptional.of(() -> this.instance);
    }

    @Nonnull
    public <R> LazyOptional<R> getCapability(@Nonnull Capability<R> cap, @Nullable Direction side) {
        if (this.capability == cap) {
            return this.instanceOpt.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)this.instance.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.instance.deserializeNBT((Tag)nbt);
    }
}

