/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.FloatingSpecialFlowerBlock;

public class ForgeSpecialFlowerBlock
extends FlowerBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = ForgeSpecialFlowerBlock.m_49796_((double)4.8, (double)0.0, (double)4.8, (double)12.8, (double)16.0, (double)12.8);
    private final Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> blockEntityType;
    private final boolean hasComparatorOutput;

    public ForgeSpecialFlowerBlock(MobEffect stewEffect, int stewDuration, BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> blockEntityType) {
        this(stewEffect, stewDuration, props, blockEntityType, false);
    }

    public ForgeSpecialFlowerBlock(MobEffect stewEffect, int stewDuration, BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> blockEntityType, boolean hasComparatorOutput) {
        super(() -> stewEffect, stewDuration, props);
        this.blockEntityType = blockEntityType;
        this.hasComparatorOutput = hasComparatorOutput;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, CollisionContext ctx) {
        Vec3 shift = state.m_60824_(world, pos);
        return SHAPE.m_83216_(shift.f_82479_, shift.f_82480_, shift.f_82481_);
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_60713_(BotaniaBlocks.redStringRelay) || super.m_6266_(state, worldIn, pos);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int event, int param) {
        super.m_8133_(state, world, pos, event, param);
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity != null && tileentity.m_7531_(event, param);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return this.blockEntityType.get().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BotaniaBlock.createTickerHelper(type, this.blockEntityType.get(), SpecialFlowerBlockEntity::commonTick);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        ((SpecialFlowerBlockEntity)level.m_7702_(pos)).setPlacedBy(level, pos, state, placer, stack);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (this.hasComparatorOutput && !newState.m_60807_()) {
            level.m_46717_(pos, newState.m_60734_());
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        FloatingSpecialFlowerBlock.redstoneParticlesIfPowered(state, world, pos, rand);
    }

    public boolean m_7278_(BlockState bs) {
        return this.hasComparatorOutput;
    }

    public int m_6782_(BlockState bs, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SpecialFlowerBlockEntity) {
            SpecialFlowerBlockEntity flower = (SpecialFlowerBlockEntity)blockEntity;
            return flower.getComparatorSignal();
        }
        return 0;
    }
}

