/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.worldgen.feature.configurations.MagicTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class MagicTreeFeature
extends BOPTreeFeature<MagicTreeConfiguration> {
    public MagicTreeFeature(Codec<MagicTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean m_225257_(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        MagicTreeConfiguration config = (MagicTreeConfiguration)configBase;
        int height = random.m_188503_(config.maxHeight - config.minHeight) + config.minHeight;
        boolean hasSpace = true;
        if (pos.m_123342_() >= world.m_141937_() + 1 && pos.m_123342_() + height + 1 <= world.m_151558_()) {
            for (int y = pos.m_123342_(); y <= pos.m_123342_() + 1 + height; ++y) {
                int radius = 1;
                if (y == pos.m_123342_()) {
                    radius = 0;
                }
                if (y >= pos.m_123342_() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x = pos.m_123341_() - radius; x <= pos.m_123341_() + radius && hasSpace; ++x) {
                    for (int z = pos.m_123343_() - radius; z <= pos.m_123343_() + radius && hasSpace; ++z) {
                        if (y >= world.m_141937_() && y < world.m_151558_()) {
                            if (this.canReplace((LevelAccessor)world, new BlockPos(x, y, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos soilPos = pos.m_7495_();
            Block soil = world.m_8055_(soilPos).m_60734_();
            if (pos.m_123342_() < world.m_151558_() - height - 1) {
                world.m_7731_(soilPos, Blocks.f_50493_.m_49966_(), 3);
                this.generateTrunk(logs, leaves, (LevelAccessor)world, pos, height, config);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void generateTrunk(BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, LevelAccessor world, BlockPos start, int height, MagicTreeConfiguration config) {
        int endHeight = height;
        for (int layer = 0; layer <= endHeight; ++layer) {
            BlockPos middlePos = start.m_6630_(layer);
            if (!this.canReplace(world, middlePos)) continue;
            this.placeLog(world, middlePos, logs, config);
        }
        BlockPos smallOrbPos = start.m_6630_(endHeight + 2);
        BlockPos mediumOrbPos = start.m_6630_(endHeight - 3);
        BlockPos largeOrbPos = start.m_6630_(endHeight - 8);
        if (world.m_213780_().m_188503_(2) != 0) {
            this.generateSmallOrb(logs, leaves, world, smallOrbPos, config);
        }
        this.generateMediumOrb(logs, leaves, world, mediumOrbPos, config);
        if (height > 9) {
            this.generateLargeOrb(logs, leaves, world, largeOrbPos, config);
        }
    }

    private void generateLargeOrb(BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, LevelAccessor world, BlockPos middle, MagicTreeConfiguration config) {
        int i;
        BlockPos pos = middle;
        for (i = 0; i < 5; ++i) {
            this.placeLeaves(world, pos.m_7918_(0, i, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-1, i, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, i, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(0, i, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(0, i, 1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-1, i, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, i, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-1, i, 1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, i, 1), leaves, config);
        }
        for (i = 1; i < 4; ++i) {
            this.placeLeaves(world, pos.m_7918_(-1, i, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, i, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(0, i, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(0, i, 1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-1, i, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, i, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-1, i, 1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, i, 1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-2, i, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-2, i, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-2, i, 1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(2, i, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(2, i, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(2, i, 1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-1, i, -2), leaves, config);
            this.placeLeaves(world, pos.m_7918_(0, i, -2), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, i, -2), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-1, i, 2), leaves, config);
            this.placeLeaves(world, pos.m_7918_(0, i, 2), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, i, 2), leaves, config);
        }
    }

    private void generateMediumOrb(BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, LevelAccessor world, BlockPos middle, MagicTreeConfiguration config) {
        int i;
        BlockPos pos = middle;
        for (i = 0; i < 5; ++i) {
            this.placeLeaves(world, pos.m_7918_(0, i, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-1, i, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, i, 0), leaves, config);
            this.placeLeaves(world, pos.m_7918_(0, i, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(0, i, 1), leaves, config);
        }
        for (i = 1; i < 4; ++i) {
            this.placeLeaves(world, pos.m_7918_(-1, i, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, i, -1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(-1, i, 1), leaves, config);
            this.placeLeaves(world, pos.m_7918_(1, i, 1), leaves, config);
        }
        this.placeLeaves(world, pos.m_7918_(-2, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, -2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 2, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 2, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 2, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 2, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 2, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 2, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 2, -2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 2, -2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 2, -2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 2, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 2, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 2, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 3, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 3, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 3, -2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 3, 2), leaves, config);
    }

    private void generateSmallOrb(BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, LevelAccessor world, BlockPos middle, MagicTreeConfiguration config) {
        BlockPos pos = middle;
        this.placeLeaves(world, pos.m_7918_(0, 0, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 2, 0), leaves, config);
    }
}

