/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.surfer;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import net.wanmine.wab.entity.Surfer;

public class SurferRandomStrollGoal
extends RandomStrollGoal {
    public static final int MIN_TIME_WHEN_CAN_RELAX = -2400;
    private final Surfer surfer;
    private boolean searchingRelaxingPlace = false;

    public SurferRandomStrollGoal(Surfer surfer, double speedFactor, int interval) {
        super((PathfinderMob)surfer, speedFactor, interval);
        this.surfer = surfer;
    }

    public boolean m_8036_() {
        return this.surfer.isAwake() && super.m_8036_();
    }

    public boolean m_8045_() {
        return this.surfer.isAwake() && super.m_8045_();
    }

    @Nullable
    protected Vec3 m_7037_() {
        Vec3 pos = null;
        if (this.f_25725_.m_20072_()) {
            if (this.shouldGoOnLand()) {
                Vec3 landPos = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)24, (int)8);
                if (landPos != null) {
                    pos = landPos;
                    this.searchingRelaxingPlace = true;
                } else {
                    pos = BehaviorUtils.m_147444_((PathfinderMob)this.f_25725_, (int)16, (int)6);
                }
            } else {
                pos = BehaviorUtils.m_147444_((PathfinderMob)this.f_25725_, (int)10, (int)6);
            }
        } else if (this.shouldGoOnWater()) {
            BlockPos waterPos = BlockPos.m_121930_((BlockPos)this.f_25725_.m_20183_(), (int)16, (int)1, position -> this.f_25725_.m_9236_().m_46801_(position)).orElse(null);
            pos = waterPos != null ? waterPos.m_252807_() : LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)16, (int)7);
        } else if (this.shouldRelax()) {
            this.surfer.setRelaxingTime(this.surfer.m_217043_().m_216339_(1800, 3000));
            this.searchingRelaxingPlace = false;
        } else {
            pos = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)10, (int)7);
        }
        return pos;
    }

    public boolean shouldGoOnLand() {
        return this.surfer.m_9236_().m_46461_() && !this.surfer.m_9236_().m_46471_() && this.surfer.m_217043_().m_188503_(9600) < -(this.surfer.getRelaxingTime() - -2400);
    }

    public boolean shouldGoOnWater() {
        return !this.surfer.m_9236_().m_46461_() || this.surfer.m_9236_().m_46471_() || !this.searchingRelaxingPlace && this.surfer.m_217043_().m_188503_(3) == 0;
    }

    public boolean shouldRelax() {
        return this.surfer.m_9236_().m_45527_(this.surfer.m_20183_()) && this.surfer.m_217043_().m_188503_(3) == 0;
    }
}

