/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.blood;

import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class EekSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "eek");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(1).setCooldownSeconds(20.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.range", (Object[])new Object[]{Utils.stringTruncation((double)EekSpell.getRange(), (int)1)}), Component.m_237115_((String)"ui.traveloptics.eek.warning"), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }

    public EekSpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 100;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)TravelopticsSounds.EEK.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Entity target;
        HitResult hitResult = Utils.raycastForEntity((Level)level, (Entity)entity, (float)EekSpell.getRange(), (boolean)true, (float)0.15f);
        ParticleOptions particleType = (ParticleOptions)ACParticleRegistry.WATCHER_APPEARANCE.get();
        MagicManager.spawnParticles((Level)level, (ParticleOptions)particleType, (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, false, false));
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)entity.m_20182_(), (float)3.0f, (float)0.04f, (int)10, (int)20);
        if (hitResult.m_6662_() == HitResult.Type.ENTITY && (target = ((EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)target;
            MagicManager.spawnParticles((Level)level, (ParticleOptions)particleType, (double)targetEntity.m_20185_(), (double)(targetEntity.m_20186_() + (double)targetEntity.m_20192_()), (double)targetEntity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            targetEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, false, false));
            ScreenShake_Entity.ScreenShake((Level)level, (Vec3)targetEntity.m_20182_(), (float)3.0f, (float)0.04f, (int)10, (int)20);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public static float getRange() {
        return 20.0f;
    }
}

