/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.aqua;

import com.gametechbc.traveloptics.api.init.TravelopticsSchools;
import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.entity.projectiles.maelstrom_trident_phantom.MaelstromTridentPhantomEntity;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.spells.TravelopticsSpellAnimations;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.spells.TargetAreaCastData;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

@AutoSpellConfig
public class SkypiercerSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "skypiercer");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(TravelopticsSchools.AQUA_RESOURCE).setMaxLevel(1).setCooldownSeconds(60.0).build();

    public SkypiercerSpell() {
        this.manaCostPerLevel = 40;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 12;
        this.baseManaCost = 140;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)TravelopticsSounds.AQUA_CAST_2.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_12090_);
    }

    public AnimationHolder getCastStartAnimation() {
        return TravelopticsSpellAnimations.SKYPIERCER_CAST;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        Vec3 vec3;
        Item mainHandItem = entity.m_21205_().m_41720_();
        if (mainHandItem != TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_ONE.get() && mainHandItem != TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_TWO.get() && mainHandItem != TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT.get() && mainHandItem != TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_THREE.get()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"spell.traveloptics.skypiercer.warning").m_130940_(ChatFormatting.RED), true);
            }
            return false;
        }
        float radius = this.getRadius(spellLevel);
        HitResult hitResult = Utils.raycastForEntity((Level)level, (Entity)entity, (float)32.0f, (boolean)true, (float)0.2f);
        TargetedAreaEntity area = TargetedAreaEntity.createTargetAreaEntity((Level)level, (Vec3)hitResult.m_82450_(), (float)radius, (int)Utils.packRGB((Vector3f)this.getTargetingColor()));
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hitResult;
            vec3 = entityHit.m_82443_().m_20182_();
        } else {
            vec3 = hitResult.m_82450_();
        }
        playerMagicData.setAdditionalCastData((ICastData)new TargetAreaCastData(vec3, area));
        return true;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetAreaCastData) {
            TargetAreaCastData castData = (TargetAreaCastData)iCastData;
            Vec3 targetArea = castData.getCenter();
            MaelstromTridentPhantomEntity phantom = new MaelstromTridentPhantomEntity(level, entity, entity.m_146908_() + 90.0f);
            phantom.m_6034_(targetArea.f_82479_, targetArea.f_82480_, targetArea.f_82481_);
            phantom.setRadius(this.getRadius(spellLevel));
            phantom.setFirstImpactDamage(this.getImpactDamage(spellLevel, entity));
            phantom.setPulseDamage(this.getPulseDamage(spellLevel, entity));
            phantom.setMaxAgeTicks(this.getDuration(spellLevel));
            Item mainHandItem = entity.m_21205_().m_41720_();
            if (mainHandItem == TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_TWO.get() || mainHandItem == TravelopticsItems.ETERNAL_MAELSTROM_TRIDENT_LEVEL_THREE.get()) {
                phantom.setApplyReplenish(true);
            }
            level.m_7967_((Entity)phantom);
            LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
            assert (lightningBolt != null);
            lightningBolt.m_20874_(true);
            lightningBolt.setDamage(0.0f);
            lightningBolt.m_6034_(targetArea.f_82479_, targetArea.f_82480_, targetArea.f_82481_);
            level.m_7967_((Entity)lightningBolt);
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.f_123769_, (double)targetArea.f_82479_, (double)targetArea.f_82480_, (double)targetArea.f_82481_, (int)50, (double)1.0, (double)0.5, (double)1.0, (double)0.2, (boolean)false);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(spellLevel), (int)1)}), Component.m_237110_((String)"ui.traveloptics.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getImpactDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.traveloptics.duration", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel), (int)1)}), Component.m_237110_((String)"ui.traveloptics.tidal_torment_amp", (Object[])new Object[]{Utils.stringTruncation((double)1.0, (int)2)}), Component.m_237110_((String)"ui.traveloptics.slowness_percent", (Object[])new Object[]{Utils.stringTruncation((double)20.0, (int)2)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }

    private float getRadius(int spellLevel) {
        return 10.0f + (float)spellLevel * 2.0f;
    }

    private float getImpactDamage(int spellLevel, LivingEntity caster) {
        return 12.5f + this.getSpellPower(spellLevel, (Entity)caster) * 12.5f;
    }

    private float getPulseDamage(int spellLevel, LivingEntity caster) {
        return this.getImpactDamage(spellLevel, caster) * 0.5f;
    }

    private int getDuration(int spellLevel) {
        return 200 + spellLevel * 40;
    }

    public Vector3f getTargetingColor() {
        return TOGeneralUtils.hexToVector3f("#57acdd");
    }
}

