/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SpectralBlinkOverlay {
    private static final int TOTAL_FRAMES = 13;
    private static long ANIMATION_DURATION = 500L;
    private static boolean isActive = false;
    private static long effectStartTime = 0L;
    private static final ResourceLocation[] FRAME_TEXTURES = new ResourceLocation[13];

    public static void renderOverlay(GuiGraphics graphics, Player player, int screenWidth, int screenHeight) {
        if (!isActive || player == null) {
            return;
        }
        long elapsed = System.currentTimeMillis() - effectStartTime;
        if (elapsed >= ANIMATION_DURATION) {
            isActive = false;
            return;
        }
        float progress = (float)elapsed / (float)ANIMATION_DURATION;
        int currentFrame = Math.min((int)(progress * 13.0f), 12);
        SpectralBlinkOverlay.renderFrame(graphics, currentFrame, screenWidth, screenHeight);
    }

    private static void renderFrame(GuiGraphics graphics, int frameIndex, int screenWidth, int screenHeight) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280163_(FRAME_TEXTURES[frameIndex], 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        RenderSystem.disableBlend();
    }

    public static void triggerEffect() {
        isActive = true;
        effectStartTime = System.currentTimeMillis();
    }

    public static void setAnimationDuration(long durationMs) {
        ANIMATION_DURATION = Math.max(50L, durationMs);
    }

    public static long getAnimationDuration() {
        return ANIMATION_DURATION;
    }

    public static boolean isEffectActive() {
        return isActive;
    }

    public static void stopEffect() {
        isActive = false;
    }

    static {
        for (int i = 0; i < 13; ++i) {
            String frameName = String.format("spectral_blink_overlay_%02d", i + 1);
            SpectralBlinkOverlay.FRAME_TEXTURES[i] = new ResourceLocation("traveloptics", "textures/gui/spectral_blink_teleport/" + frameName + ".png");
        }
    }
}

