/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.effects;

import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.util.TravelopticsParticleHelper;
import com.gametechbc.traveloptics.util.TravelopticsTags;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AstralSenseEffect
extends MobEffect {
    private static final int TNT_RADIUS = 8;
    private static final int THREAT_RADIUS = 20;
    private static final int PROJECTILE_RADIUS = 30;
    private static final int ENTITY_SENSE_RADIUS = 8;

    public AstralSenseEffect() {
        super(MobEffectCategory.BENEFICIAL, 16766720);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level level = player.m_9236_();
        this.detectPrimedTNT(player, level, 8);
        this.detectEntityThreats(player, level, 20);
        this.detectIncomingProjectiles(player, level, 30);
        this.detectAndHighlightEntities(player, level, 8);
    }

    private void detectAndHighlightEntities(Player player, Level level, int radius) {
        AABB searchBox = player.m_20191_().m_82400_((double)radius);
        level.m_6443_(Entity.class, searchBox, e -> e.m_6095_().m_204039_(TravelopticsTags.SENSED_ENTITIES)).forEach(sensedEntity -> {
            Vec3 pos = sensedEntity.m_20182_().m_82520_(0.0, (double)(sensedEntity.m_20206_() / 2.0f), 0.0);
            if (!player.m_9236_().f_46443_) {
                MagicManager.spawnParticles((Level)level, (ParticleOptions)TravelopticsParticleHelper.ABYSS_SPIKE_PARTICLE, (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.01, (boolean)false);
            }
        });
    }

    private boolean detectPrimedTNT(Player player, Level level, int radius) {
        if (!level.m_45976_(PrimedTnt.class, player.m_20191_().m_82400_((double)radius)).isEmpty()) {
            return this.sendMessage(player, (Component)Component.m_237115_((String)"spell.traveloptics.message.astral_sense.tnt").m_130940_(ChatFormatting.RED));
        }
        return false;
    }

    private void detectEntityThreats(Player player, Level level, int radius) {
        AABB searchBox = player.m_20191_().m_82400_((double)radius);
        List nearbyMobs = level.m_6443_(Mob.class, searchBox, mob -> mob.m_6084_() && !mob.m_6095_().m_204039_(TravelopticsTags.APPROACH_ENTITY_BLACKLIST) && Math.abs(mob.m_20186_() - player.m_20186_()) <= 4.0);
        Mob targetingMob = null;
        Mob approachingMob = null;
        double targetDistanceSqr = Double.MAX_VALUE;
        double approachDistanceSqr = Double.MAX_VALUE;
        for (Mob mob2 : nearbyMobs) {
            double distanceSqr = mob2.m_20280_((Entity)player);
            if (mob2.m_5448_() == player && distanceSqr < targetDistanceSqr) {
                targetingMob = mob2;
                targetDistanceSqr = distanceSqr;
                continue;
            }
            if (mob2.m_21573_().m_26570_() == null || !(distanceSqr < approachDistanceSqr)) continue;
            approachingMob = mob2;
            approachDistanceSqr = distanceSqr;
        }
        if (targetingMob != null) {
            this.sendMessage(player, (Component)Component.m_237110_((String)"spell.traveloptics.message.astral_sense.targeting", (Object[])new Object[]{targetingMob.m_5446_(), (int)Math.sqrt(targetDistanceSqr)}).m_130940_(ChatFormatting.RED));
        } else if (approachingMob != null) {
            this.sendMessage(player, (Component)Component.m_237110_((String)"spell.traveloptics.message.astral_sense.approaching", (Object[])new Object[]{approachingMob.m_5446_(), (int)Math.sqrt(approachDistanceSqr)}).m_130940_(ChatFormatting.GOLD));
        }
    }

    private void detectIncomingProjectiles(Player player, Level level, int radius) {
        if (!level.m_6443_(Projectile.class, player.m_20191_().m_82400_((double)radius), proj -> proj.m_19749_() != player && proj.m_20184_().m_82526_(player.m_20182_().m_82546_(proj.m_20182_()).m_82541_()) > 0.5).isEmpty()) {
            this.sendMessage(player, (Component)Component.m_237115_((String)"spell.traveloptics.message.astral_sense.projectile").m_130940_(ChatFormatting.RED));
        }
    }

    private boolean sendMessage(Player player, Component message) {
        player.m_5661_(message, true);
        return true;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 5 == 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AstralSenseFogFunction
    implements FogRenderer.MobEffectFogFunction {
        public MobEffect m_213948_() {
            return (MobEffect)TravelopticsEffects.ASTRAL_SENSE.get();
        }

        public void m_213725_(FogRenderer.FogData fogData, LivingEntity entity, MobEffectInstance mobEffectInstance, float p_234184_, float p_234185_) {
            float f = 160.0f;
            if (fogData.f_234199_ == FogRenderer.FogMode.FOG_SKY) {
                fogData.f_234200_ = 0.0f;
                fogData.f_234201_ = f * 0.25f;
            } else {
                fogData.f_234200_ = -f * 0.5f;
                fogData.f_234201_ = f;
            }
        }
    }
}

