/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.screens.AbstractBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.UpgradeSlot;
import com.tiviacz.travelersbackpack.client.screens.buttons.AbilitySliderButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.EquipButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.MoreButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.SleepingBagButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.UnequipButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.FilterUpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.SortingButtons;
import com.tiviacz.travelersbackpack.client.screens.widgets.ToolSlotsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.CommonFluid;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class BackpackScreen
extends AbstractBackpackScreen<BackpackBaseMenu>
implements MenuAccess<BackpackBaseMenu> {
    public boolean tanksVisible;
    public List<UpgradeSlot> upgradeSlots = new ArrayList<UpgradeSlot>();
    public List<IButton> buttons = new ArrayList<IButton>();
    public SortingButtons sortingButtons;
    public ToolSlotsWidget toolSlotsWidget;
    public SettingsWidget settingsWidget;
    public int warningTicks = 0;

    public BackpackScreen(BackpackBaseMenu backpackMenu, Inventory inventory, Component component) {
        super(backpackMenu, inventory, backpackMenu.getWrapper().getBackpackScreenTitle());
        this.recalculate();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
        this.f_97728_ = 8 + (this.tanksVisible ? 22 : 0);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initButtons();
        this.initWidgets();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        this.updateScreen(true);
        ((BackpackBaseMenu)this.m_6262_()).updateSlots();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.warningTicks > 0) {
            --this.warningTicks;
        }
    }

    public void recalculate() {
        boolean wideTexture;
        this.m_169413_();
        this.upgradeSlots.clear();
        this.visibleSlots = this.slotCount = this.getWrapper().getStorage().getSlots();
        this.slotsHeight = this.calculateSlotHeight(this.slotCount > 81);
        this.tanksVisible = this.getWrapper().tanksVisible();
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.wider = wideTexture = this.slotCount > 81;
        this.visibleRows = (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
        int playerInventoryHeight = 96;
        this.f_97726_ = wideTexture ? (this.tanksVisible ? 256 : 212) : (this.tanksVisible ? 220 : 176);
        this.f_97727_ = 17 + this.slotsHeight + playerInventoryHeight;
        this.updateDimensions();
        this.f_97731_ = 20 + this.visibleRows * 18;
        this.f_97730_ = 8;
        this.f_97728_ = 8 + (this.tanksVisible ? 22 : 0);
        this.f_97729_ = 6;
        if (this.tanksVisible) {
            this.f_97730_ += 22;
        }
        if (wideTexture) {
            this.f_97730_ += 18;
        }
        if (((BackpackBaseMenu)this.f_97732_).m_38853_((int)0).f_40221_ >= 0) {
            this.slotYPos = ((BackpackBaseMenu)this.f_97732_).m_38853_((int)0).f_40221_;
        }
    }

    public int getMiddleBar() {
        return 17 + this.calculateSlotHeight(this.visibleRows) + 1;
    }

    public int getWidthAdditions() {
        int addition = 0;
        if (this.tanksVisible) {
            addition += 22;
        }
        if (this.wider) {
            addition += 18;
        }
        return addition;
    }

    public void updateScreen(boolean duplicatedCall) {
        this.isScrollable = false;
        this.recalculate();
        this.m_7856_();
        if (!duplicatedCall) {
            this.updateBackpackSlotsPosition();
            this.updatePlayerSlotsPosition();
        }
    }

    @Override
    public void renderScreen(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.renderUpgradeSlots(guiGraphics, x, y);
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        int inventoryXOffset = this.tanksVisible ? 22 : 0;
        this.renderInventoryBackground(guiGraphics, x + inventoryXOffset, y, wideTexture ? BACKGROUND_11 : BACKGROUND_9, this.f_97726_, this.slotsHeight);
        int slotsXOffset = 7;
        if (this.tanksVisible) {
            slotsXOffset = 29;
            int halfTankHeight = this.slotsHeight / 2;
            int tanksHeight = 90;
            int uOffset = 56;
            int posOffset = 193;
            if (wideTexture) {
                uOffset = 0;
                posOffset = 229;
            }
            guiGraphics.m_280218_(TANKS, x, y, 0, 0, 27, 8 + halfTankHeight);
            guiGraphics.m_280218_(TANKS, x, y + 17 - 9 + halfTankHeight, uOffset, 256 - (tanksHeight + halfTankHeight + 17), 27, tanksHeight + halfTankHeight + 17 - 9);
            guiGraphics.m_280218_(TANKS, x + posOffset, y, uOffset + 28, 0, 27, 8 + halfTankHeight);
            guiGraphics.m_280218_(TANKS, x + posOffset, y + 17 - 9 + halfTankHeight, uOffset + 28, 256 - (tanksHeight + halfTankHeight + 17), 27, tanksHeight + halfTankHeight + 17 - 9);
        }
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 17, this.slotCount);
        this.renderLockedBackpackSlot(guiGraphics);
    }

    public void renderUpgradeSlots(GuiGraphics guiGraphics, int x, int y) {
        for (UpgradeSlot slot : this.upgradeSlots) {
            slot.render(guiGraphics, x, y);
        }
    }

    public void initializeUpgradeSlots() {
        for (int i = 0; i < this.getWrapper().getUpgrades().getSlots(); ++i) {
            int x = ((BackpackBaseMenu)this.f_97732_).upgradeSlot.get((int)i).f_40220_ - 4;
            int y = ((BackpackBaseMenu)this.f_97732_).upgradeSlot.get((int)i).f_40221_ - 4;
            this.upgradeSlots.add(new UpgradeSlot(this.getWrapper(), new Point(this.getGuiLeft() + x, this.getGuiTop() + y), i, x, y, ((BackpackBaseMenu)this.f_97732_).upgradeSlot.get((int)i).isHidden));
        }
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4), false);
        this.m_142416_(this.settingsWidget);
        int xPos = this.f_97735_ + (this.wider ? 36 : 0) + (this.tanksVisible ? 22 : 0) + 120;
        this.sortingButtons = new SortingButtons(this, new Point(xPos, this.f_97736_ - 10 + 12), 50, 13);
        this.m_142416_(this.sortingButtons);
        int xPosTools = (this.wider ? 36 : 0) + (this.tanksVisible ? 22 : 0);
        this.toolSlotsWidget = new ToolSlotsWidget(this, new Point(this.f_97735_ + xPosTools + 110, this.f_97736_ - 10 + 15), xPosTools);
        this.m_142416_(this.toolSlotsWidget);
        UpgradeManager manager = this.getWrapper().getUpgradeManager();
        Iterator iterator = manager.mappedUpgrades.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Optional upgrade = (Optional)manager.mappedUpgrades.get((Object)i);
            upgrade.ifPresent(loadedUpgrade -> {
                int x = ((BackpackBaseMenu)this.f_97732_).upgradeSlot.get((int)i).f_40220_ - 4;
                int y = ((BackpackBaseMenu)this.f_97732_).upgradeSlot.get((int)i).f_40221_ - 4;
                this.m_142416_(loadedUpgrade.createWidget(this, x, y));
            });
        }
        this.initializeUpgradeSlots();
        if (this.isScrollable) {
            int scrollXPos = this.f_97735_ + 7 + (this.tanksVisible ? 22 : 0);
            this.scroll = new InventoryScroll(this, Minecraft.m_91087_(), 4, this.visibleRows * 18, this.f_97736_ + 17, scrollXPos + this.getSlotsInRow() * 18);
            if (this.scrollAmount != 0) {
                this.scroll.setScrollDistance(this.scrollAmount);
            }
            this.m_142416_((GuiEventListener)this.scroll);
        }
    }

    public void initButtons() {
        this.buttons.clear();
        int xOffset = 0;
        if (this.getWrapper().getScreenID() == 1 && !TravelersBackpack.enableIntegration()) {
            this.buttons.add(new EquipButton(this, this.getWrapper().getBackpackSlotIndex() == this.getScreenPlayer().m_150109_().f_35977_));
            xOffset += 12;
        }
        if (this.getWrapper().getScreenID() == 2 && this.getWrapper().isOwner(((BackpackBaseMenu)this.m_6262_()).player)) {
            this.buttons.add(new MoreButton(this));
            if (!TravelersBackpack.enableIntegration()) {
                this.buttons.add(new UnequipButton(this));
                xOffset += 12;
            }
            if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.quickSleepingBag.get()).booleanValue()) {
                this.buttons.add(new SleepingBagButton(this, true, xOffset));
                xOffset += 12;
            }
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.getWrapper().getBackpackStack())) {
                this.buttons.add(new AbilitySliderButton(this, false, xOffset));
            }
        }
        if (this.getWrapper().getScreenID() == 3) {
            this.buttons.add(new MoreButton(this));
            this.buttons.add(new SleepingBagButton(this, false, 0));
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.getWrapper().getBackpackStack())) {
                this.buttons.add(new AbilitySliderButton(this, true, 12));
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.buttons.forEach(button -> {
            if (this.getWrapper().showMoreButtons() || button instanceof MoreButton || button instanceof EquipButton) {
                button.render(guiGraphics, mouseX, mouseY, partialTicks);
            }
        });
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        this.buttons.forEach(button -> {
            if (this.getWrapper().showMoreButtons() || button instanceof MoreButton || button instanceof EquipButton) {
                button.renderTooltip(guiGraphics, mouseX, mouseY);
            }
        });
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
        this.renderFluidWarningTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    public void drawUnsortableSlots(GuiGraphics guiGraphics) {
        if (!this.getWrapper().getUnsortableSlots().isEmpty()) {
            this.getWrapper().getUnsortableSlots().forEach(i -> guiGraphics.m_280218_(ICONS, this.getGuiLeft() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40220_, this.getGuiTop() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40221_, 25, 55, 16, 16));
        }
    }

    @Override
    public void drawMemorySlots(GuiGraphics guiGraphics) {
        if (!this.getWrapper().getMemorySlots().isEmpty()) {
            this.getWrapper().getMemorySlots().forEach(pair -> {
                if (((BackpackBaseMenu)this.m_6262_()).m_38853_((Integer)pair.getFirst()).m_7993_().m_41619_()) {
                    ItemStack itemstack = (ItemStack)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.m_280203_(itemstack, this.getGuiLeft() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_);
                    guiGraphics.m_285944_(RenderType.m_285811_(), this.getGuiLeft() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, this.getGuiLeft() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_ + 16, this.getGuiTop() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_ + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected boolean m_7467_(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        if (!((BackpackBaseMenu)this.f_97732_).m_142621_().m_41619_()) {
            for (GuiEventListener widget : this.m_6702_()) {
                WidgetBase base;
                if (!(widget instanceof WidgetBase) || !(base = (WidgetBase)widget).m_5953_(pMouseX, pMouseY)) continue;
                return false;
            }
        }
        return pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.f_97726_) || pMouseY >= (double)(pGuiTop + this.f_97727_);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.buttons.forEach(b -> {
            if (this.getWrapper().showMoreButtons() || b instanceof MoreButton || b instanceof EquipButton) {
                b.mouseClicked(mouseX, mouseY, button);
            }
        });
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        FilterUpgradeWidgetBase widget;
        GuiEventListener child;
        if (this.m_94729_(mouseX, mouseY).isPresent() && (child = (GuiEventListener)this.m_94729_(mouseX, mouseY).get()) instanceof FilterUpgradeWidgetBase && ((FilterUpgradeBase)(widget = (FilterUpgradeWidgetBase)child).getUpgrade()).isTagSelector() && widget.m_6050_(mouseX, mouseY, scrollY)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (ModClientEventHandler.SORT_BACKPACK.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            ServerboundActionTagPacket.create(3, 0, KeyHelper.isShiftPressed());
            this.playUIClickSound();
            return true;
        }
        if (ModClientEventHandler.OPEN_BACKPACK.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            LocalPlayer playerEntity = this.getMinecraft().f_91074_;
            if (!(playerEntity == null || this.getSlotUnderMouse() != null && this.getSlotUnderMouse().m_7993_().m_41720_() instanceof TravelersBackpackItem)) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public static void displayTanksUpgradeWarning(Player player) {
        Screen screen;
        if (player.m_9236_().f_46443_ && (screen = Minecraft.m_91087_().f_91080_) instanceof BackpackScreen) {
            BackpackScreen screen2 = (BackpackScreen)screen;
            screen2.warningTicks = 60;
        }
    }

    public void renderFluidWarningTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.warningTicks > 0) {
            if (!(((BackpackBaseMenu)this.f_97732_).m_142621_().m_41720_() instanceof TanksUpgradeItem)) {
                this.warningTicks = 0;
            }
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(Component.m_237115_((String)"screen.travelersbackpack.cant_apply_upgrade"));
            tooltip.add(Component.m_237115_((String)"screen.travelersbackpack.too_much_fluid"));
            FluidStack leftFluidStack = TanksUpgradeItem.getLeftFluidStack(((BackpackBaseMenu)this.f_97732_).m_142621_());
            FluidStack rightFluidStack = TanksUpgradeItem.getRightFluidStack(((BackpackBaseMenu)this.f_97732_).m_142621_());
            if (!leftFluidStack.isEmpty() && leftFluidStack.getAmount() > this.getWrapper().getBackpackTankCapacity()) {
                tooltip.add(this.crateFluidWarning(leftFluidStack, this.getWrapper().getBackpackTankCapacity()));
            }
            if (!rightFluidStack.isEmpty() && rightFluidStack.getAmount() > this.getWrapper().getBackpackTankCapacity()) {
                tooltip.add(this.crateFluidWarning(rightFluidStack, this.getWrapper().getBackpackTankCapacity()));
            }
            guiGraphics.m_280677_(this.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
            CommonFluid.getFluidName(leftFluidStack);
        }
    }

    public Component crateFluidWarning(FluidStack fluidStack, int backpackCapacity) {
        return Component.m_237113_((String)(CommonFluid.getFluidName(fluidStack).getString() + " " + fluidStack.getAmount() + "/" + backpackCapacity + "mB")).m_130940_(ChatFormatting.RED);
    }
}

