/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.RitualFluteHandler;

public class SMessageRitualFlutePlayedNote {
    private final byte note;

    public SMessageRitualFlutePlayedNote(int note) {
        this.note = (byte)(note & 0xFF);
    }

    static SMessageRitualFlutePlayedNote fromBytes(FriendlyByteBuf buf) {
        return new SMessageRitualFlutePlayedNote(buf.readUnsignedByte());
    }

    static void toBytes(SMessageRitualFlutePlayedNote msg, FriendlyByteBuf buf) {
        buf.writeByte((int)msg.note);
    }

    public static class Handler {
        static void handle(final SMessageRitualFlutePlayedNote message, Supplier<NetworkEvent.Context> contextSupplier) {
            final NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        @Nullable ServerPlayer serverPlayer = ctx.getSender();
                        if (serverPlayer == null) {
                            return;
                        }
                        RitualFluteHandler.playNote(serverPlayer, message.note);
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

