/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class RandomPotionFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "random_potion");
    public static final Serializer SERIALIZER = new Serializer();

    protected RandomPotionFunction(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public LootItemFunctionType m_7162_() {
        return ModLootFunctions.RANDOM_POTION;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        Potion potion = Helper.getRandomInList(ForgeRegistries.POTIONS.getValues()).orElse(Potions.f_43623_);
        if (!EffectHelper.isPotionEnabled(potion)) {
            return ItemStack.f_41583_;
        }
        int random = Helper.RANDOM.nextInt(3);
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)(random == 0 ? Items.f_42589_ : (random == 1 ? Items.f_42736_ : Items.f_42739_))), (Potion)potion);
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomPotionFunction> {
        public RandomPotionFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            return new RandomPotionFunction(conditionsIn);
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new RandomPotionFunction(this.m_80699_());
        }
    }
}

