/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumdynamiclights;

import java.util.HashMap;
import net.minecraftforge.common.ForgeConfigSpec;
import toni.sodiumdynamiclights.DynamicLightsMode;
import toni.sodiumdynamiclights.ExplosiveLightingMode;

public class DynamicLightsConfig {
    public static final ForgeConfigSpec SPECS;
    public static final ForgeConfigSpec.EnumValue<DynamicLightsMode> DYNAMIC_LIGHTS_MODE;
    public static final ForgeConfigSpec.BooleanValue ENTITIES_LIGHT_SOURCE;
    public static final ForgeConfigSpec.BooleanValue SELF_LIGHT_SOURCE;
    public static final ForgeConfigSpec.BooleanValue BLOCK_ENTITIES_LIGHT_SOURCE;
    public static final ForgeConfigSpec.BooleanValue WATER_SENSITIVE_CHECK;
    public static final ForgeConfigSpec.EnumValue<ExplosiveLightingMode> CREEPER_LIGHTING_MODE;
    public static final ForgeConfigSpec.EnumValue<ExplosiveLightingMode> TNT_LIGHTING_MODE;
    public static final HashMap<String, Boolean> ENTITIES_SETTINGS;

    public DynamicLightsMode getDynamicLightsMode() {
        return (DynamicLightsMode)((Object)DYNAMIC_LIGHTS_MODE.get());
    }

    public ForgeConfigSpec.BooleanValue getEntitiesLightSource() {
        return ENTITIES_LIGHT_SOURCE;
    }

    public ForgeConfigSpec.BooleanValue getSelfLightSource() {
        return SELF_LIGHT_SOURCE;
    }

    public ForgeConfigSpec.BooleanValue getBlockEntitiesLightSource() {
        return BLOCK_ENTITIES_LIGHT_SOURCE;
    }

    public ForgeConfigSpec.BooleanValue getWaterSensitiveCheck() {
        return WATER_SENSITIVE_CHECK;
    }

    public ForgeConfigSpec.EnumValue<ExplosiveLightingMode> getCreeperLightingMode() {
        return CREEPER_LIGHTING_MODE;
    }

    public ForgeConfigSpec.EnumValue<ExplosiveLightingMode> getTntLightingMode() {
        return TNT_LIGHTING_MODE;
    }

    public HashMap<String, Boolean> getLightSettings() {
        return ENTITIES_SETTINGS;
    }

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.push("sodiumdynamiclights");
        DYNAMIC_LIGHTS_MODE = BUILDER.comment("Lighting mode").defineEnum("mode", (Enum)DynamicLightsMode.REALTIME);
        ENTITIES_LIGHT_SOURCE = BUILDER.comment("Enable entities light source.").define("entities", false);
        SELF_LIGHT_SOURCE = BUILDER.comment("Enable first-person player light source.").define("self", true);
        BLOCK_ENTITIES_LIGHT_SOURCE = BUILDER.comment("Enable block entities light source.").define("block_entities", true);
        WATER_SENSITIVE_CHECK = BUILDER.comment("Enables water-sensitive light sources check. This means that water-sensitive items will not light up when submerged in water.").define("water_sensitive_check", true);
        TNT_LIGHTING_MODE = BUILDER.comment("TNT lighting mode. May be off, simple or fancy.").defineEnum("tnt", (Enum)ExplosiveLightingMode.SIMPLE);
        CREEPER_LIGHTING_MODE = BUILDER.comment("Creeper lighting mode. May be off, simple or fancy.").defineEnum("creeper", (Enum)ExplosiveLightingMode.OFF);
        ENTITIES_SETTINGS = new HashMap();
        BUILDER.pop();
        SPECS = BUILDER.build();
    }
}

