/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.init;

import com.mongoose.royalvariations.client.render.CuriosRenderer;
import com.mongoose.royalvariations.client.render.NetRenderer;
import com.mongoose.royalvariations.client.render.RVModelLayer;
import com.mongoose.royalvariations.client.render.RoyalArrowRenderer;
import com.mongoose.royalvariations.client.render.RoyalBombProjectileRenderer;
import com.mongoose.royalvariations.client.render.RoyalBombRenderer;
import com.mongoose.royalvariations.client.render.RoyalCreeperRenderer;
import com.mongoose.royalvariations.client.render.RoyalEndermanRenderer;
import com.mongoose.royalvariations.client.render.RoyalSkeletonRenderer;
import com.mongoose.royalvariations.client.render.RoyalZombieRenderer;
import com.mongoose.royalvariations.client.render.SpectralAnvilRenderer;
import com.mongoose.royalvariations.client.render.model.GloveModel;
import com.mongoose.royalvariations.client.render.model.NetModel;
import com.mongoose.royalvariations.client.render.model.RoyalBombModel;
import com.mongoose.royalvariations.client.render.model.RoyalBombProjectileModel;
import com.mongoose.royalvariations.client.render.model.RoyalCreeperModel;
import com.mongoose.royalvariations.client.render.model.RoyalEndermanModel;
import com.mongoose.royalvariations.client.render.model.RoyalKnightBootsModel;
import com.mongoose.royalvariations.client.render.model.RoyalKnightCuirassModel;
import com.mongoose.royalvariations.client.render.model.RoyalKnightHelmetModel;
import com.mongoose.royalvariations.client.render.model.RoyalKnightLeggingsModel;
import com.mongoose.royalvariations.client.render.model.RoyalSkeletonModel;
import com.mongoose.royalvariations.client.render.model.RoyalZombieModel;
import com.mongoose.royalvariations.client.render.model.SpectralAnvilModel;
import com.mongoose.royalvariations.common.entities.RVEntityType;
import com.mongoose.royalvariations.common.items.RVItems;
import com.mongoose.royalvariations.common.items.RoyalTelelocator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="royalvariations", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientInitEvents {
    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent event) {
        CuriosRenderer.register();
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)RVItems.ROYAL_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, world, living, seed) -> {
                if (living == null) {
                    return 0.0f;
                }
                return living.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - living.m_21212_()) / 20.0f;
            });
            ItemProperties.register((Item)((Item)RVItems.ROYAL_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (stack, world, living, seed) -> living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)RVItems.ROYAL_TELELOCATOR.get()), (ResourceLocation)new ResourceLocation("active"), (stack, world, living, seed) -> RoyalTelelocator.hasBlock(stack) ? 1.0f : 0.0f);
        });
    }

    @SubscribeEvent
    public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(RVModelLayer.ROYAL_BOMB_PROJECTILE, RoyalBombProjectileModel::createBodyLayer);
        event.registerLayerDefinition(RVModelLayer.ROYAL_BOMB, RoyalBombModel::createBodyLayer);
        event.registerLayerDefinition(RVModelLayer.NET, NetModel::createBodyLayer);
        event.registerLayerDefinition(RVModelLayer.SPECTRAL_ANVIL, SpectralAnvilModel::createBodyLayer);
        event.registerLayerDefinition(RVModelLayer.ROYAL_ZOMBIE, RoyalZombieModel::createBodyLayer);
        event.registerLayerDefinition(RVModelLayer.ROYAL_SKELETON, RoyalSkeletonModel::createBodyLayer);
        event.registerLayerDefinition(RVModelLayer.ROYAL_CREEPER, () -> RoyalCreeperModel.createBodyLayer(CubeDeformation.f_171458_));
        event.registerLayerDefinition(RVModelLayer.ROYAL_CREEPER_ARMOR, () -> RoyalCreeperModel.createBodyLayer(new CubeDeformation(0.5f)));
        event.registerLayerDefinition(RVModelLayer.ROYAL_ENDERMAN, RoyalEndermanModel::createBodyLayer);
        event.registerLayerDefinition(RVModelLayer.GLOVE, GloveModel::createBodyLayer);
        event.registerLayerDefinition(RVModelLayer.ROYAL_KNIGHT_HELMET, RoyalKnightHelmetModel::createBodyLayer);
        event.registerLayerDefinition(RVModelLayer.ROYAL_KNIGHT_CUIRASS, RoyalKnightCuirassModel::createBodyLayer);
        event.registerLayerDefinition(RVModelLayer.ROYAL_KNIGHT_LEGGINGS, RoyalKnightLeggingsModel::createBodyLayer);
        event.registerLayerDefinition(RVModelLayer.ROYAL_KNIGHT_BOOTS, RoyalKnightBootsModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void onRegisterRenders(EntityRenderersEvent.RegisterRenderers event) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        event.registerEntityRenderer((EntityType)RVEntityType.ROYAL_ARROW.get(), RoyalArrowRenderer::new);
        event.registerEntityRenderer((EntityType)RVEntityType.ROYAL_BOMB_PROJECTILE.get(), RoyalBombProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)RVEntityType.ROYAL_BOMB.get(), RoyalBombRenderer::new);
        event.registerEntityRenderer((EntityType)RVEntityType.ROYAL_ENDER_PEARL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)RVEntityType.NET.get(), NetRenderer::new);
        event.registerEntityRenderer((EntityType)RVEntityType.SPECTRAL_ANVIL.get(), SpectralAnvilRenderer::new);
        event.registerEntityRenderer((EntityType)RVEntityType.ROYAL_ZOMBIE.get(), RoyalZombieRenderer::new);
        event.registerEntityRenderer((EntityType)RVEntityType.ROYAL_SKELETON.get(), RoyalSkeletonRenderer::new);
        event.registerEntityRenderer((EntityType)RVEntityType.ROYAL_CREEPER.get(), RoyalCreeperRenderer::new);
        event.registerEntityRenderer((EntityType)RVEntityType.ROYAL_ENDERMAN.get(), RoyalEndermanRenderer::new);
    }
}

