/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.compat.curios;

import com.google.common.collect.ImmutableMap;
import com.mongoose.royalvariations.common.items.GloveItem;
import com.mongoose.royalvariations.common.items.RVItems;
import com.mongoose.royalvariations.compat.ICompatable;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CuriosIntegration
implements ICompatable {
    private static final Map<Item, String> TYPES = ImmutableMap.builder().put((Object)((Item)RVItems.SPECTRAL_GAUNTLET.get()), (Object)"hands").build();

    @Override
    public void setup(FMLCommonSetupEvent event) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sendImc);
        MinecraftForge.EVENT_BUS.addListener(this::registerCapabilities);
    }

    private void sendImc(InterModEnqueueEvent event) {
        TYPES.values().stream().distinct().forEach(t -> InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(t).build()));
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        TYPES.keySet().forEach(entry -> {
            if (entry instanceof GloveItem) {
                GloveItem item = (GloveItem)((Object)entry);
                CuriosApi.registerCurio((Item)item, (ICurioItem)new GloveItem());
            }
        });
    }
}

