/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.world;

import com.mongoose.royalvariations.common.entities.RVEntityType;
import com.mongoose.royalvariations.config.RVConfig;
import com.mongoose.royalvariations.init.RVTags;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.common.world.ModifiableStructureInfo;

public class RVLevelRegistry {
    public static void addBiomeSpawns(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (!biome.containsTag(RVTags.Biomes.COMMON_BLACKLIST) && !biome.m_203425_(biomeResourceKey -> biomeResourceKey.m_211136_().m_135827_().contains("alexscaves"))) {
            if (biome.m_203656_(RVTags.Biomes.ROYAL_ZOMBIE_SPAWN) && (Integer)RVConfig.RoyalZombieSpawnWeight.get() > 0) {
                builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)RVEntityType.ROYAL_ZOMBIE.get(), ((Integer)RVConfig.RoyalZombieSpawnWeight.get()).intValue(), ((Integer)RVConfig.RoyalZombieSpawnMinCount.get()).intValue(), ((Integer)RVConfig.RoyalZombieSpawnMaxCount.get()).intValue()));
            }
            if (biome.m_203656_(RVTags.Biomes.ROYAL_SKELETON_SPAWN) && (Integer)RVConfig.RoyalSkeletonSpawnWeight.get() > 0) {
                builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)RVEntityType.ROYAL_SKELETON.get(), ((Integer)RVConfig.RoyalSkeletonSpawnWeight.get()).intValue(), ((Integer)RVConfig.RoyalSkeletonSpawnMinCount.get()).intValue(), ((Integer)RVConfig.RoyalSkeletonSpawnMaxCount.get()).intValue()));
            }
            if (biome.m_203656_(RVTags.Biomes.ROYAL_CREEPER_SPAWN) && (Integer)RVConfig.RoyalCreeperSpawnWeight.get() > 0) {
                builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)RVEntityType.ROYAL_CREEPER.get(), ((Integer)RVConfig.RoyalCreeperSpawnWeight.get()).intValue(), ((Integer)RVConfig.RoyalCreeperSpawnMinCount.get()).intValue(), ((Integer)RVConfig.RoyalCreeperSpawnMaxCount.get()).intValue()));
            }
            if (biome.m_203656_(RVTags.Biomes.ROYAL_ENDERMAN_SPAWN) && (Integer)RVConfig.RoyalEndermanSpawnWeight.get() > 0) {
                builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)RVEntityType.ROYAL_ENDERMAN.get(), ((Integer)RVConfig.RoyalEndermanSpawnWeight.get()).intValue(), ((Integer)RVConfig.RoyalEndermanSpawnMinCount.get()).intValue(), ((Integer)RVConfig.RoyalEndermanSpawnMaxCount.get()).intValue()));
            }
        }
    }

    public static boolean startName(ResourceKey<Biome> biomeResourceKey, String string) {
        return biomeResourceKey.m_211136_().m_135827_().startsWith(string);
    }

    public static boolean containsName(ResourceKey<Biome> biomeResourceKey, String string) {
        return biomeResourceKey.m_211136_().m_135827_().contains(string);
    }

    public static void addStructureSpawns(Holder<Structure> structure, ModifiableStructureInfo.StructureInfo.Builder builder) {
    }
}

