/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.network.server;

import com.mongoose.royalvariations.RoyalVariations;
import com.mongoose.royalvariations.utils.MobUtil;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SInstaLookPacket {
    public int looker;
    public int target;

    public SInstaLookPacket(int lookerId, int targetId) {
        this.looker = lookerId;
        this.target = targetId;
    }

    public SInstaLookPacket(Mob looker, Entity target) {
        this.looker = looker.m_19879_();
        this.target = target.m_19879_();
    }

    public static void encode(SInstaLookPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.looker);
        buffer.writeInt(packet.target);
    }

    public static SInstaLookPacket decode(FriendlyByteBuf buffer) {
        return new SInstaLookPacket(buffer.readInt(), buffer.readInt());
    }

    public static void consume(SInstaLookPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (level = RoyalVariations.PROXY.getLevel()) instanceof ClientLevel) {
                ClientLevel clientWorld = (ClientLevel)level;
                Entity looker = clientWorld.m_6815_(packet.looker);
                Entity target = clientWorld.m_6815_(packet.target);
                if (looker instanceof Mob) {
                    Mob mob = (Mob)looker;
                    if (target != null) {
                        MobUtil.instaLook(mob, target);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

