/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.network;

import com.mongoose.royalvariations.common.capabilities.misc.RVCapUpdatePacket;
import com.mongoose.royalvariations.common.network.client.CSetDeltaMovement;
import com.mongoose.royalvariations.common.network.server.SInstaLookPacket;
import com.mongoose.royalvariations.common.network.server.SRemoveEffectPacket;
import com.mongoose.royalvariations.common.network.server.SRepositionPacket;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class RVNetwork {
    public static SimpleChannel INSTANCE;
    private static int id;

    public static int nextID() {
        return id++;
    }

    public static void init() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("royalvariations", "channel"), () -> "1.0", s -> true, s -> true);
        INSTANCE.registerMessage(RVNetwork.nextID(), CSetDeltaMovement.class, CSetDeltaMovement::encode, CSetDeltaMovement::decode, CSetDeltaMovement::consume, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        INSTANCE.registerMessage(RVNetwork.nextID(), SRepositionPacket.class, SRepositionPacket::encode, SRepositionPacket::decode, SRepositionPacket::consume);
        INSTANCE.registerMessage(RVNetwork.nextID(), SInstaLookPacket.class, SInstaLookPacket::encode, SInstaLookPacket::decode, SInstaLookPacket::consume);
        INSTANCE.registerMessage(RVNetwork.nextID(), SRemoveEffectPacket.class, SRemoveEffectPacket::encode, SRemoveEffectPacket::decode, SRemoveEffectPacket::consume);
        INSTANCE.registerMessage(RVNetwork.nextID(), RVCapUpdatePacket.class, RVCapUpdatePacket::encode, RVCapUpdatePacket::decode, RVCapUpdatePacket::consume);
    }

    public static <MSG> void sendTo(Player player, MSG msg) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), msg);
    }

    public static <MSG> void sendToServer(MSG msg) {
        INSTANCE.sendToServer(msg);
    }

    public static <MSG> void sentToTrackingChunk(LevelChunk chunk, MSG msg) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), msg);
    }

    public static <MSG> void sentToTrackingEntity(Entity entity, MSG msg) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), msg);
    }

    public static <MSG> void sentToTrackingEntityAndPlayer(Entity entity, MSG msg) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), msg);
    }

    public static <MSG> void sendToALL(MSG msg) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), msg);
    }

    public static <MSG> void sendToClient(ServerPlayer player, MSG msg) {
        INSTANCE.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    static {
        id = 0;
    }
}

