/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.entities.projectile;

import com.mongoose.royalvariations.common.effects.RVEffects;
import com.mongoose.royalvariations.common.network.RVNetwork;
import com.mongoose.royalvariations.common.network.client.CSetDeltaMovement;
import com.mongoose.royalvariations.common.network.server.SRepositionPacket;
import com.mongoose.royalvariations.utils.MobUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.NetworkHooks;

public abstract class TangleEntity
extends Entity {
    protected int warmupDelayTicks;
    protected int activeTick;
    public int lifeSpan = 80;
    @Nullable
    protected LivingEntity target;
    @Nullable
    protected UUID targetUUID;
    @Nullable
    protected LivingEntity owner;
    @Nullable
    protected UUID ownerUUID;

    public TangleEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public TangleEntity(EntityType<?> p_19870_, Level p_19871_, @Nullable LivingEntity owner, Entity target) {
        this(p_19870_, p_19871_);
        this.setOwner(owner);
        this.m_146884_(target.m_20182_());
    }

    public TangleEntity(EntityType<?> p_19870_, Level p_19871_, @Nullable LivingEntity owner, BlockPos blockPos) {
        this(p_19870_, p_19871_);
        this.setOwner(owner);
        this.m_146884_(blockPos.m_252807_());
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128441_("Warmup")) {
            this.warmupDelayTicks = pCompound.m_128451_("Warmup");
        }
        if (pCompound.m_128441_("ActiveTick")) {
            this.activeTick = pCompound.m_128451_("ActiveTick");
        }
        if (pCompound.m_128441_("LifeSpan")) {
            this.lifeSpan = pCompound.m_128451_("LifeSpan");
        }
        if (pCompound.m_128403_("Target")) {
            this.targetUUID = pCompound.m_128342_("Target");
        }
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("Warmup", this.warmupDelayTicks);
        pCompound.m_128405_("ActiveTick", this.activeTick);
        pCompound.m_128405_("LifeSpan", this.lifeSpan);
        if (this.targetUUID != null) {
            pCompound.m_128362_("Target", this.targetUUID);
        }
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void setLifeSpan(int lifeSpan) {
        this.lifeSpan = lifeSpan;
    }

    public int getLifeSpan() {
        return this.lifeSpan;
    }

    public void setTarget(@Nullable LivingEntity p_36939_) {
        this.target = p_36939_;
        this.targetUUID = p_36939_ == null ? null : p_36939_.m_20148_();
    }

    @Nullable
    public LivingEntity getTarget() {
        Entity entity;
        if (this.target == null && this.targetUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.targetUUID)) instanceof LivingEntity) {
            this.target = (LivingEntity)entity;
        }
        return this.target;
    }

    public void setOwner(@Nullable LivingEntity p_36939_) {
        this.owner = p_36939_;
        this.ownerUUID = p_36939_ == null ? null : p_36939_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public boolean m_20145_() {
        return super.m_20145_() || this.activeTick < 1;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            MobUtil.moveDownToGround(this);
            if (this.warmupDelayTicks > 0) {
                --this.warmupDelayTicks;
            } else {
                ++this.activeTick;
                this.m_9236_().m_7605_((Entity)this, (byte)6);
                this.entangleTick();
            }
        }
    }

    public void entangleTick() {
        if (this.activeTick == 1) {
            this.burst();
        } else {
            if (this.activeTick < 5) {
                this.findTarget();
            }
            if (this.activeTick < this.lifeSpan) {
                this.tangleTarget();
            } else if (this.activeTick == this.lifeSpan) {
                this.burrow();
            } else if (this.activeTick >= this.lifeSpan + 20) {
                this.m_146870_();
            }
        }
    }

    public void burst() {
    }

    public void findTarget() {
        if (this.getTarget() == null) {
            for (LivingEntity livingEntity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_())) {
                Entity entity;
                if (!EntitySelector.f_20406_.test(livingEntity)) continue;
                LivingEntity target = livingEntity;
                if (target.m_20159_() && (entity = target.m_20202_()) instanceof LivingEntity) {
                    LivingEntity vehicle;
                    target = vehicle = (LivingEntity)entity;
                }
                if (!this.canHitEntity((Entity)target)) continue;
                this.setTarget(target);
            }
        }
    }

    public void tangleTarget() {
        if (this.getTarget() != null && this.getTarget().m_6084_() && !this.getTarget().m_6095_().m_204039_(Tags.EntityTypes.BOSSES) && this.getTarget().m_21233_() <= 100.0f && this.getTarget().m_7301_(new MobEffectInstance((MobEffect)RVEffects.TRAPPED.get()))) {
            this.getTarget().m_146884_(this.m_20182_());
            this.getTarget().m_20256_(Vec3.f_82478_);
            this.getTarget().m_6478_(MoverType.SELF, Vec3.f_82478_);
            this.getTarget().m_19920_(0.0f, Vec3.f_82478_);
            if (this.m_9236_().f_46443_) {
                RVNetwork.sendToServer(new CSetDeltaMovement(this.getTarget().m_19879_(), 0.0, 0.0, 0.0));
            } else if (this.activeTick < 10) {
                RVNetwork.sentToTrackingEntityAndPlayer((Entity)this.getTarget(), new SRepositionPacket(this.getTarget().m_19879_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_));
            }
            this.getTarget().m_7292_(new MobEffectInstance((MobEffect)RVEffects.TRAPPED.get(), 2, 0, false, false, false));
        }
    }

    public void burrow() {
    }

    public void m_7822_(byte pId) {
        if (pId == 6) {
            ++this.activeTick;
        } else {
            super.m_7822_(pId);
        }
    }

    protected boolean canHitEntity(Entity pEntity) {
        if (this.getOwner() != null) {
            Mob mob;
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return true;
            }
            if (MobUtil.areAllies((Entity)this.getOwner(), pEntity)) {
                return false;
            }
            return !(this.getOwner() instanceof Enemy) || !(pEntity instanceof Enemy);
        }
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

