/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.entities.projectile;

import com.mongoose.royalvariations.client.particles.EndSplashParticleOption;
import com.mongoose.royalvariations.client.particles.RVParticleTypes;
import com.mongoose.royalvariations.common.effects.RVEffects;
import com.mongoose.royalvariations.common.entities.RVEntityType;
import com.mongoose.royalvariations.init.RVSounds;
import com.mongoose.royalvariations.utils.MobUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class SpectralAnvil
extends Entity {
    private LivingEntity owner;
    private UUID ownerUUID;
    private boolean isDropping;
    public int hovering = 0;
    public AnimationState spawnAnimationState = new AnimationState();
    public AnimationState fallAnimationState = new AnimationState();

    public SpectralAnvil(EntityType<? extends Entity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public SpectralAnvil(Level pLevel, LivingEntity pOwner) {
        this((EntityType<? extends Entity>)((EntityType)RVEntityType.SPECTRAL_ANVIL.get()), pLevel);
        this.owner = pOwner;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
        this.hovering = pCompound.m_128451_("hovering");
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
        pCompound.m_128405_("hovering", this.hovering);
    }

    public void setOwner(@Nullable LivingEntity p_190549_1_) {
        this.owner = p_190549_1_;
        this.ownerUUID = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        if (this.owner == null && this.ownerUUID != null && (level = this.m_9236_()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    private void onHit() {
        if (!this.m_9236_().m_5776_()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 20; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    double d3 = 10.0;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.END_POOF.get()), this.m_20165_(1.0) - d0 * d3, this.m_20187_() - d1 * d3, this.m_20262_(1.0) - d2 * d3, 0, d0, d1, d2, 1.0);
                }
                serverLevel.m_8767_((ParticleOptions)new EndSplashParticleOption(4.0f, 2), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.isDropping) {
                for (LivingEntity livingEntity : this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(4.0), this::canHitEntity)) {
                    this.damageTargets(livingEntity);
                }
            }
            this.m_5496_((SoundEvent)RVSounds.END_SPLASH.get(), 2.0f, 1.0f);
            this.m_5496_(SoundEvents.f_11668_, 0.5f, 1.0f);
        }
        this.m_146870_();
    }

    /*
     * Unable to fully structure code
     */
    public void damageTargets(LivingEntity livingEntity) {
        block4: {
            if (livingEntity == null || (this.getOwner() == null || MobUtil.areAllies((Entity)this.getOwner(), (Entity)livingEntity)) && this.getOwner() != null) break block4;
            flag = false;
            duration = 140;
            var6_4 = this.getOwner();
            if (!(var6_4 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var6_4;
            if (!(livingEntity instanceof OwnableEntity) || (ownable = (OwnableEntity)livingEntity).m_269323_() != player) {
                duration = 200;
                flag = true;
            } else if (livingEntity instanceof Player || livingEntity.m_21023_((MobEffect)RVEffects.PRESSING_GAZE.get())) {
                flag = true;
            }
            if (flag && livingEntity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.getOwner()), 8.0f)) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)RVEffects.HEAVINESS_OF_THE_END.get(), duration));
            }
        }
    }

    public void m_7601_(BlockState p_20006_, Vec3 p_20007_) {
        super.m_7601_(p_20006_, Vec3.f_82478_);
    }

    public void m_8119_() {
        Level result1;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            ++this.hovering;
            HitResult result = ProjectileUtil.m_278158_((Entity)this, this::canHitEntity);
            if (result.m_6662_() != HitResult.Type.MISS) {
                if (result.m_6662_() == HitResult.Type.ENTITY && (result1 = (EntityHitResult)result).m_82443_() instanceof LivingEntity) {
                    this.damageTargets((LivingEntity)result1.m_82443_());
                }
                this.onHit();
            }
            if (this.m_20096_() || this.m_5830_() || this.f_19863_ || this.f_19862_) {
                this.onHit();
            }
        } else {
            ++this.hovering;
        }
        if (this.hovering == 1) {
            result1 = this.m_9236_();
            if (result1 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)result1;
                for (int i = 0; i < 20; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    double d3 = 10.0;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.END_POOF.get()), this.m_20185_() - d0 * d3, this.m_20187_() - d1 * d3, this.m_20189_() - d2 * d3, 0, d0, d1, d2, 1.0);
                }
                this.m_5496_(SoundEvents.f_11862_, 2.0f, 1.0f);
            } else {
                this.spawnAnimationState.m_216982_(this.f_19797_);
            }
        }
        int hoverTime = 20;
        if (this.getOwner() instanceof Player) {
            hoverTime = 15;
        }
        boolean bl = this.isDropping = this.hovering > hoverTime;
        if (!this.isDropping) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.25, 0.0));
            if (this.m_9236_().f_46443_) {
                this.spawnAnimationState.m_216973_();
                this.fallAnimationState.m_216982_(this.f_19797_);
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public boolean m_6097_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    protected boolean canHitEntity(Entity entity) {
        if (!entity.m_5833_() && entity.m_6084_() && entity.m_6087_() && !entity.f_19794_) {
            LivingEntity owner = this.getOwner();
            return owner == null || !owner.m_20365_(entity);
        }
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

