/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.entities.projectile;

import com.mongoose.royalvariations.client.particles.RVParticleTypes;
import com.mongoose.royalvariations.common.effects.RVEffects;
import com.mongoose.royalvariations.common.entities.RVEntityType;
import com.mongoose.royalvariations.init.RVSounds;
import com.mongoose.royalvariations.utils.CustomExplosion;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RoyalBomb
extends Mob
implements TraceableEntity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(RoyalBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity owner;
    public AnimationState startAnimationState = new AnimationState();

    public RoyalBomb(EntityType<? extends RoyalBomb> p_32076_, Level p_32077_) {
        super(p_32076_, p_32077_);
        this.f_19850_ = true;
    }

    public RoyalBomb(Level p_32079_, double p_32080_, double p_32081_, double p_32082_, @Nullable LivingEntity p_32083_) {
        this((EntityType<? extends RoyalBomb>)((EntityType)RVEntityType.ROYAL_BOMB.get()), p_32079_);
        this.m_6034_(p_32080_, p_32081_, p_32082_);
        this.setFuse(40);
        this.f_19854_ = p_32080_;
        this.f_19855_ = p_32081_;
        this.f_19856_ = p_32082_;
        this.owner = p_32083_;
    }

    public RoyalBomb(Level p_32079_, Vec3 vec3, @Nullable LivingEntity p_32083_) {
        this(p_32079_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, p_32083_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)80);
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6673_(DamageSource p_20122_) {
        return true;
    }

    public boolean m_5789_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.startAnimationState.m_216982_(this.f_19797_);
        } else {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.f_19797_ == 1) {
                    for (int i = 0; i < 5; ++i) {
                        double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                        double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                        double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.GOLDEN_TRAIL.get()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
            }
        }
        if (this.f_19797_ == 1) {
            this.m_216990_((SoundEvent)RVSounds.ROYAL_BOMB.get());
        }
        int i = this.getFuse() - 1;
        this.setFuse(i);
        if (i <= 0) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                this.explode();
            }
        } else {
            this.m_20073_();
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.SPARKLE.get()), this.m_20185_(), this.m_20186_() + 0.9, this.m_20189_(), 1, 0.2, 0.2, 0.2, 0.1);
            }
        }
    }

    protected void explode() {
        float f = 9.0f;
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), f, Level.ExplosionInteraction.TNT);
        new CustomExplosion(this.m_9236_(), (Entity)this, this.m_269291_().m_269036_((Entity)this, (Entity)this), this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0f + f, 1.0f){

            @Override
            public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                if (target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    if (EntitySelector.f_20406_.test(target) && target != RoyalBomb.this) {
                        livingEntity.m_7292_(new MobEffectInstance((MobEffect)RVEffects.DAZED.get(), 200));
                    }
                }
            }
        };
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128376_("Fuse", (short)this.getFuse());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setFuse(compoundTag.m_128448_("Fuse"));
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return 0.15f;
    }

    public void setFuse(int p_32086_) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)p_32086_);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }
}

