/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.entities.neutral;

import com.mongoose.royalvariations.client.particles.EndSplashParticleOption;
import com.mongoose.royalvariations.client.particles.RVParticleTypes;
import com.mongoose.royalvariations.common.effects.RVEffects;
import com.mongoose.royalvariations.common.entities.hostile.RoyalMonster;
import com.mongoose.royalvariations.common.entities.projectile.SpectralAnvil;
import com.mongoose.royalvariations.init.RVSounds;
import com.mongoose.royalvariations.utils.MathHelper;
import com.mongoose.royalvariations.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class RoyalEnderman
extends RoyalMonster
implements NeutralMob {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(RoyalEnderman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_CREEPY = SynchedEntityData.m_135353_(RoyalEnderman.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_STARED_AT = SynchedEntityData.m_135353_(RoyalEnderman.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("a3d6ab3a-7fae-4881-a86a-224f42e15b6f");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private int lastStareSound = Integer.MIN_VALUE;
    private int targetChangeTime;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String BLESS = "bless";
    private boolean isWalking;
    private int attackTick;
    private int toIdleTick;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState toIdleAnimationState = new AnimationState();
    public AnimationState tremorAnimationState = new AnimationState();
    public AnimationState crownAnimationState = new AnimationState();
    public AnimationState blinkAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState blessAnimationState = new AnimationState();

    public RoyalEnderman(EntityType<? extends RoyalEnderman> p_32485_, Level p_32486_) {
        super(p_32485_, p_32486_);
        this.f_21364_ = 40;
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AnvilGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new EndermanFreezeWhenLookedAt(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new EndermanLookForPlayerGoal(this, arg_0 -> ((RoyalEnderman)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, (double)0.24f).m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22284_, 17.0).m_22268_(Attributes.f_22282_, 0.7).m_22268_(Attributes.f_22278_, 0.7);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_CREEPY, (Object)false);
        this.f_19804_.m_135372_(DATA_STARED_AT, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag p_32520_) {
        super.m_7380_(p_32520_);
        this.m_21678_(p_32520_);
    }

    @Override
    public void m_7378_(CompoundTag p_32511_) {
        super.m_7378_(p_32511_);
        this.m_147285_(this.m_9236_(), p_32511_);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 0;
        }
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        if (Objects.equals(animation, "bless")) {
            return 2;
        }
        return 0;
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAnimations()) {
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.blessAnimationState);
        return animationStates;
    }

    public boolean isCurrentAnimation(String string) {
        return this.getCurrentAnimation() == this.getAnimationState(string);
    }

    public void m_6710_(@Nullable LivingEntity p_32537_) {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (p_32537_ == null) {
            this.targetChangeTime = 0;
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)false);
            this.f_19804_.m_135381_(DATA_STARED_AT, (Object)false);
            if (attributeinstance != null) {
                attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
            }
        } else {
            this.targetChangeTime = this.f_19797_;
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)true);
            if (attributeinstance != null && !attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        }
        super.m_6710_(p_32537_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int p_32515_) {
        this.remainingPersistentAngerTime = p_32515_;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@Nullable UUID p_32509_) {
        this.persistentAngerTarget = p_32509_;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void playStareSound() {
        if (this.f_19797_ >= this.lastStareSound + 400) {
            this.lastStareSound = this.f_19797_;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_11851_, this.m_5720_(), 2.5f, 1.0f, false);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_32513_) {
        if (DATA_CREEPY.equals(p_32513_) && this.hasBeenStaredAt() && this.m_9236_().f_46443_) {
            this.playStareSound();
        }
        if (ANIM_STATE.equals(p_32513_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.stopAllAnimation();
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimation();
                    this.blessAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_32513_);
    }

    boolean isLookingAtMe(Player p_32535_) {
        ItemStack itemstack = (ItemStack)p_32535_.m_150109_().f_35975_.get(3);
        if (ForgeHooks.shouldSuppressEnderManAnger((EnderMan)new EnderMan(EntityType.f_20566_, this.m_9236_()), (Player)p_32535_, (ItemStack)itemstack)) {
            return false;
        }
        Vec3 vec3 = p_32535_.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - p_32535_.m_20185_(), this.m_20188_() - p_32535_.m_20188_(), this.m_20189_() - p_32535_.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? p_32535_.m_142582_((Entity)this) : false;
    }

    protected float m_6431_(Pose p_32517_, EntityDimensions p_32518_) {
        return 2.55f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (!this.f_267362_.m_267780_()) {
                if (this.isWalking) {
                    this.isWalking = false;
                    this.toIdleTick = MathHelper.secondsToTicks(0.5f);
                }
            } else {
                this.isWalking = true;
            }
            if (this.toIdleTick > 0) {
                --this.toIdleTick;
            }
            boolean flag = !this.f_267362_.m_267780_() && this.isCurrentAnimation(IDLE);
            this.toIdleAnimationState.m_246184_(this.toIdleTick > 0 && flag, this.f_19797_);
            this.idleAnimationState.m_246184_(this.toIdleTick <= 0 && flag, this.f_19797_);
            this.tremorAnimationState.m_246184_(this.isCreepy(), this.f_19797_);
            this.crownAnimationState.m_216982_(this.f_19797_);
            this.blinkAnimationState.m_216982_(this.f_19797_);
        } else {
            if (this.attackTick > 0) {
                --this.attackTick;
            } else if (this.isCurrentAnimation(ATTACK)) {
                this.setAnimationState(IDLE);
            }
            if (this.m_5448_() != null && this.m_5448_().m_20270_((Entity)this) >= 100.0f) {
                this.m_6710_(null);
            }
        }
    }

    @Override
    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        this.f_20899_ = false;
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        super.m_8107_();
    }

    public boolean m_6126_() {
        return true;
    }

    protected void m_8024_() {
        float f;
        if (this.m_9236_().m_46461_() && this.f_19797_ >= this.targetChangeTime + 600 && (f = this.m_213856_()) > 0.5f && this.m_9236_().m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f) {
            this.m_6710_(null);
            this.teleport();
        }
        super.m_8024_();
    }

    protected boolean teleport() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    boolean teleportTowards(Entity p_32501_) {
        Vec3 vec3 = new Vec3(this.m_20185_() - p_32501_.m_20185_(), this.m_20227_(0.5) - p_32501_.m_20188_(), this.m_20189_() - p_32501_.m_20189_());
        vec3 = vec3.m_82541_();
        double d0 = 16.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 20; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        double d3 = 10.0;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.END_POOF.get()), this.m_20185_() - d0 * d3, this.m_20187_() - d1 * d3, this.m_20189_() - d2 * d3, 0, d0, d1, d2, 1.0);
                    }
                    serverLevel.m_8767_((ParticleOptions)new EndSplashParticleOption(4.0f, 2), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                for (LivingEntity livingEntity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(4.0))) {
                    if (MobUtil.areAllies((Entity)livingEntity, (Entity)this) || !(livingEntity instanceof Player) && !livingEntity.m_21023_((MobEffect)RVEffects.PRESSING_GAZE.get()) || !livingEntity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this), 4.0f)) continue;
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)RVEffects.HEAVINESS_OF_THE_END.get(), 80));
                }
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                    this.m_5496_((SoundEvent)RVSounds.END_SPLASH.get(), 2.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (p_32665_ instanceof EnderMan) {
            return this.m_5647_() == null && p_32665_.m_5647_() == null;
        }
        return super.m_7307_(p_32665_);
    }

    protected SoundEvent m_7515_() {
        return this.isCreepy() ? SoundEvents.f_11850_ : SoundEvents.f_11899_;
    }

    protected SoundEvent m_7975_(DamageSource p_32527_) {
        return SoundEvents.f_11849_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        boolean isWaterBottle = damageSource.m_7640_() instanceof ThrownPotion;
        if (!damageSource.m_269533_(DamageTypeTags.f_268524_) && !isWaterBottle) {
            Entity entity;
            boolean flag2 = super.m_6469_(damageSource, amount);
            if (!this.m_9236_().m_5776_() && !(damageSource.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(10) != 0) {
                this.teleport();
            }
            if ((entity = damageSource.m_7639_()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)RVEffects.PRESSING_GAZE.get(), 400));
            }
            return flag2;
        }
        boolean flag1 = isWaterBottle && this.hurtWithCleanWater(damageSource, (ThrownPotion)damageSource.m_7640_(), amount);
        for (int i = 0; i < 64; ++i) {
            if (!this.teleport()) continue;
            return true;
        }
        return flag1;
    }

    private boolean hurtWithCleanWater(DamageSource damageSource, ThrownPotion thrownPotion, float amount) {
        Entity entity;
        boolean flag;
        ItemStack itemstack = thrownPotion.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
        List list = PotionUtils.m_43547_((ItemStack)itemstack);
        boolean bl = flag = potion == Potions.f_43599_ && list.isEmpty();
        if (flag && (entity = thrownPotion.m_19749_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)RVEffects.PRESSING_GAZE.get(), 400));
        }
        return flag && super.m_6469_(damageSource, amount);
    }

    public boolean isCreepy() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CREEPY);
    }

    public boolean hasBeenStaredAt() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STARED_AT);
    }

    public void setBeingStaredAt() {
        this.f_19804_.m_135381_(DATA_STARED_AT, (Object)true);
    }

    public void m_6674_(InteractionHand p_21007_) {
        super.m_6674_(p_21007_);
        this.setAnimationState(ATTACK);
        this.attackTick = MathHelper.secondsToTicks(0.5f);
    }

    static class AnvilGoal
    extends Goal {
        public RoyalEnderman royal;
        public int blessTick;

        public AnvilGoal(RoyalEnderman enderman) {
            this.royal = enderman;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.royal.m_5448_() != null && this.royal.knightCool <= 0) {
                return this.royal.m_5448_().m_142582_((Entity)this.royal) && this.royal.m_21223_() <= this.royal.m_21233_() * 0.85f;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.blessTick > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.royal.setAnimationState(BLESS);
            this.royal.m_5496_((SoundEvent)RVSounds.ROYAL_ENDERMAN_CAST.get(), 1.0f, this.royal.m_6100_());
            this.royal.m_21573_().m_26573_();
            this.royal.m_21566_().m_24988_(0.0f, 0.0f);
            this.blessTick = 20;
            if (this.royal.m_5448_() != null) {
                this.royal.m_21563_().m_24960_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
                this.royal.m_21391_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
            }
        }

        public void m_8037_() {
            super.m_8037_();
            --this.blessTick;
            this.royal.m_21573_().m_26573_();
            this.royal.m_21566_().m_24988_(0.0f, 0.0f);
            if (this.royal.m_5448_() != null) {
                this.royal.m_21563_().m_24960_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
                this.royal.m_21391_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
            }
            if (this.royal.m_5448_() != null && this.blessTick == 10) {
                SpectralAnvil anvil = new SpectralAnvil(this.royal.m_9236_(), (LivingEntity)this.royal);
                float height = Math.max(this.royal.m_20206_(), this.royal.m_5448_().m_20206_());
                anvil.m_146884_(this.royal.m_5448_().m_20182_().m_82520_(0.0, (double)(height + 1.0f), 0.0));
                this.royal.m_9236_().m_7967_((Entity)anvil);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.blessTick = 0;
            this.royal.knightCool = 180;
            this.royal.setAnimationState(IDLE);
        }
    }

    static class EndermanFreezeWhenLookedAt
    extends Goal {
        private final RoyalEnderman enderman;
        @Nullable
        private LivingEntity target;

        public EndermanFreezeWhenLookedAt(RoyalEnderman p_32550_) {
            this.enderman = p_32550_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.enderman.m_5448_();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.m_20280_((Entity)this.enderman);
            return !(d0 > 256.0) && this.enderman.isLookingAtMe((Player)this.target);
        }

        public void m_8056_() {
            this.enderman.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.target != null) {
                this.enderman.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
        }
    }

    static class EndermanLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final RoyalEnderman enderman;
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();
        private final Predicate<LivingEntity> isAngerInducing;

        public EndermanLookForPlayerGoal(RoyalEnderman p_32573_, @Nullable Predicate<LivingEntity> p_32574_) {
            super((Mob)p_32573_, Player.class, 10, false, false, p_32574_);
            this.enderman = p_32573_;
            this.isAngerInducing = p_269940_ -> (p_32573_.isLookingAtMe((Player)p_269940_) || p_32573_.m_21674_((LivingEntity)p_269940_)) && !p_32573_.m_20367_((Entity)p_269940_);
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(this.isAngerInducing);
        }

        public boolean m_8036_() {
            this.pendingTarget = this.enderman.m_9236_().m_45946_(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = this.m_183277_(5);
            this.teleportTime = 0;
            this.enderman.setBeingStaredAt();
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.isAngerInducing.test((LivingEntity)this.pendingTarget)) {
                    return false;
                }
                this.enderman.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            if (this.f_26050_ != null) {
                if (this.enderman.m_20367_((Entity)this.f_26050_)) {
                    return false;
                }
                if (this.continueAggroTargetConditions.m_26885_((LivingEntity)this.enderman, this.f_26050_)) {
                    return true;
                }
            }
            return super.m_8045_();
        }

        public void m_8037_() {
            if (this.enderman.m_5448_() == null) {
                super.m_26070_(null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.enderman.m_20159_()) {
                    if (this.enderman.isLookingAtMe((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.enderman) < 16.0) {
                            this.enderman.teleport();
                        }
                        this.f_26050_.m_7292_(new MobEffectInstance((MobEffect)RVEffects.PRESSING_GAZE.get(), 400, 0));
                        this.teleportTime = 0;
                    } else if (((double)this.f_26050_.m_20270_((Entity)this.enderman) >= 8.0 || !this.enderman.m_142582_((Entity)this.f_26050_)) && this.teleportTime++ >= this.m_183277_(30) && this.enderman.teleportTowards((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

