/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.entities.hostile;

import com.mojang.serialization.DynamicOps;
import com.mongoose.royalvariations.client.particles.RVParticleTypes;
import com.mongoose.royalvariations.common.capabilities.misc.RVCapHelper;
import com.mongoose.royalvariations.common.effects.RVEffects;
import com.mongoose.royalvariations.common.entities.hostile.RoyalMonster;
import com.mongoose.royalvariations.common.items.RVItems;
import com.mongoose.royalvariations.utils.MathHelper;
import com.mongoose.royalvariations.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class RoyalZombie
extends RoyalMonster {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(RoyalZombie.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = p_34284_ -> p_34284_ == Difficulty.HARD;
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String BLESS = "bless";
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
    private boolean canBreakDoors;
    private boolean isWalking;
    private int attackTick;
    private int toIdleTick;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState toIdleAnimationState = new AnimationState();
    public AnimationState crownAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState blessAnimationState = new AnimationState();

    public RoyalZombie(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new KnightingGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false));
        this.f_21345_.m_25352_(4, (Goal)new ZombieAttackTurtleEggGoal((PathfinderMob)this, 1.0, 3));
        this.f_21345_.m_25352_(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, this::canBreakDoors));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{ZombifiedPiglin.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22278_, 0.6);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 0;
        }
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        if (Objects.equals(animation, "bless")) {
            return 2;
        }
        return 0;
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAnimations()) {
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.stopAllAnimation();
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimation();
                    this.blessAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.blessAnimationState);
        return animationStates;
    }

    public boolean isCurrentAnimation(String string) {
        return this.getCurrentAnimation() == this.getAnimationState(string);
    }

    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (p_32665_ instanceof Zombie) {
            return this.m_5647_() == null && p_32665_.m_5647_() == null;
        }
        return super.m_7307_(p_32665_);
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean p_34337_) {
        if (this.supportsBreakDoorGoal() && GoalUtils.m_26894_((Mob)this)) {
            if (this.canBreakDoors != p_34337_) {
                this.canBreakDoors = p_34337_;
                ((GroundPathNavigation)this.m_21573_()).m_26477_(p_34337_);
                if (p_34337_) {
                    this.f_21345_.m_25352_(1, (Goal)this.breakDoorGoal);
                } else {
                    this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    protected boolean supportsBreakDoorGoal() {
        return true;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return SoundEvents.f_12608_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("CanBreakDoors", this.canBreakDoors());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setCanBreakDoors(compoundTag.m_128471_("CanBreakDoors"));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        SpawnGroupData data = super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 2, false, false));
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_() != Direction.Axis.X) continue;
            Vec3 vec3 = this.m_20182_().m_231075_(direction, 2.0);
            Zombie zombie = new Zombie((Level)p_21434_.m_6018_());
            zombie.m_6518_(p_21434_, p_21435_, MobSpawnType.MOB_SUMMONED, p_21437_, p_21438_);
            zombie.m_146884_(vec3);
            if (!p_21434_.m_7967_((Entity)zombie)) continue;
            p_21434_.m_6018_().m_8767_((ParticleOptions)ParticleTypes.f_123759_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 8, 0.2, 0.3, 0.2, 0.1);
        }
        return data;
    }

    @Override
    protected boolean isSunSensitive() {
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (!this.f_267362_.m_267780_()) {
                if (this.isWalking) {
                    this.isWalking = false;
                    this.toIdleTick = MathHelper.secondsToTicks(0.5f);
                }
            } else {
                this.isWalking = true;
            }
            if (this.toIdleTick > 0) {
                --this.toIdleTick;
            }
            boolean flag = !this.f_267362_.m_267780_() && this.isCurrentAnimation(IDLE);
            this.toIdleAnimationState.m_246184_(this.toIdleTick > 0 && flag, this.f_19797_);
            this.idleAnimationState.m_246184_(this.toIdleTick <= 0 && flag, this.f_19797_);
            this.crownAnimationState.m_216982_(this.f_19797_);
        } else {
            if (this.m_5448_() != null) {
                this.m_21561_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)4);
            } else {
                this.m_21561_(false);
                this.m_9236_().m_7605_((Entity)this, (byte)5);
            }
            if (this.attackTick > 0) {
                --this.attackTick;
            } else if (this.isCurrentAnimation(ATTACK)) {
                this.setAnimationState(IDLE);
            }
        }
    }

    public void m_6674_(InteractionHand p_21007_) {
        super.m_6674_(p_21007_);
        this.setAnimationState(ATTACK);
        this.attackTick = MathHelper.secondsToTicks(0.75f);
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)RVEffects.CHOSEN_VICTIM.get(), 400, 0));
        }
        return flag;
    }

    public boolean m_214076_(ServerLevel p_219160_, LivingEntity p_219161_) {
        boolean flag = super.m_214076_(p_219160_, p_219161_);
        if ((p_219160_.m_46791_() == Difficulty.NORMAL || p_219160_.m_46791_() == Difficulty.HARD) && p_219161_ instanceof Villager) {
            Villager villager = (Villager)p_219161_;
            if (ForgeEventFactory.canLivingConvert((LivingEntity)p_219161_, (EntityType)EntityType.f_20530_, timer -> {})) {
                if (p_219160_.m_46791_() != Difficulty.HARD && this.f_19796_.m_188499_()) {
                    return flag;
                }
                ZombieVillager zombievillager = (ZombieVillager)villager.m_21406_(EntityType.f_20530_, false);
                if (zombievillager != null) {
                    zombievillager.m_6518_((ServerLevelAccessor)p_219160_, p_219160_.m_6436_(zombievillager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), (CompoundTag)null);
                    zombievillager.m_34375_(villager.m_7141_());
                    zombievillager.m_34391_((Tag)villager.m_35517_().m_262795_((DynamicOps)NbtOps.f_128958_));
                    zombievillager.m_34411_(villager.m_6616_().m_45388_());
                    zombievillager.m_34373_(villager.m_7809_());
                    ForgeEventFactory.onLivingConvert((LivingEntity)p_219161_, (LivingEntity)zombievillager);
                    if (!this.m_20067_()) {
                        p_219160_.m_5898_((Player)null, 1026, this.m_20183_(), 0);
                    }
                    flag = false;
                }
            }
        }
        return flag;
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.m_21561_(true);
        } else if (p_21375_ == 5) {
            this.m_21561_(false);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    static class KnightingGoal
    extends Goal {
        public static int FLASH_TIME = 15;
        public RoyalZombie royal;
        public List<Zombie> list = new ArrayList<Zombie>();
        public int blessTick;

        public KnightingGoal(RoyalZombie zombie) {
            this.royal = zombie;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.royal.m_5448_() != null && this.royal.knightCool <= 0) {
                List list = this.royal.m_9236_().m_45976_(Zombie.class, this.royal.m_20191_().m_82400_(10.0));
                list.removeIf(zombie -> !zombie.m_142582_((Entity)this.royal) && MobUtil.areAllies((Entity)zombie, (Entity)this.royal.m_5448_()));
                this.list = list;
                return !this.list.isEmpty();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.blessTick > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.royal.setAnimationState(BLESS);
            this.royal.m_21573_().m_26573_();
            this.royal.m_21566_().m_24988_(0.0f, 0.0f);
            this.blessTick = FLASH_TIME + 1;
            if (this.royal.m_5448_() != null) {
                this.royal.m_21563_().m_24960_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
                this.royal.m_21391_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
            }
            if (!this.list.isEmpty()) {
                for (Zombie zombie : this.list) {
                    if (!zombie.m_6844_(EquipmentSlot.HEAD).m_41619_() && !zombie.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) continue;
                    RVCapHelper.setFlashTick((LivingEntity)zombie, FLASH_TIME);
                }
            }
        }

        public void m_8037_() {
            super.m_8037_();
            --this.blessTick;
            this.royal.m_21573_().m_26573_();
            this.royal.m_21566_().m_24988_(0.0f, 0.0f);
            if (this.royal.m_5448_() != null) {
                this.royal.m_21563_().m_24960_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
                this.royal.m_21391_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
            }
            if (this.blessTick == 1 && !this.list.isEmpty()) {
                for (Zombie zombie : this.list) {
                    Level level = this.royal.m_9236_();
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (zombie.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                        zombie.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RVItems.ROYAL_KNIGHT_HELMET.get()));
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.SPARKLE.get()), zombie.m_20185_(), zombie.m_20186_() + (double)zombie.m_20206_(), zombie.m_20189_(), serverLevel.m_213780_().m_216332_(5, 6), 0.2, 0.3, 0.2, 0.1);
                    } else {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.SHINE.get()), zombie.m_20185_(), zombie.m_20186_() + 1.3, zombie.m_20189_(), serverLevel.m_213780_().m_216332_(5, 6), 0.2, 0.3, 0.2, 0.1);
                    }
                    if (zombie.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                        Item item = Items.f_42383_;
                        if (this.royal.m_9236_().m_213780_().m_188501_() <= 0.25f) {
                            item = Items.f_42386_;
                        }
                        zombie.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)item));
                    }
                    zombie.m_7292_(new MobEffectInstance((MobEffect)RVEffects.KNIGHTLY_FORTITUDE.get(), 400, 0, false, false));
                    zombie.m_5496_(SoundEvents.f_144051_, 0.9f, 1.0f);
                    serverLevel.m_6263_(null, zombie.m_20185_(), zombie.m_20186_(), zombie.m_20189_(), SoundEvents.f_144051_, SoundSource.HOSTILE, 0.9f, 1.0f);
                    for (int i = 0; i <= serverLevel.m_213780_().m_188503_(10) + 10; ++i) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.HOLY.get()), zombie.m_20208_(1.5), zombie.m_20187_(), zombie.m_20262_(1.5), 0, 0.0, 1.0, 0.0, 1.0);
                    }
                    zombie.m_6710_(this.royal.m_5448_());
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.blessTick = 0;
            this.royal.knightCool = 100;
            this.royal.setAnimationState(IDLE);
            this.list.clear();
        }
    }

    class ZombieAttackTurtleEggGoal
    extends RemoveBlockGoal {
        ZombieAttackTurtleEggGoal(PathfinderMob p_34344_, double p_34345_, int p_34346_) {
            super(Blocks.f_50578_, p_34344_, p_34345_, p_34346_);
        }

        public void m_7659_(LevelAccessor p_34351_, BlockPos p_34352_) {
            p_34351_.m_5594_(null, p_34352_, SoundEvents.f_12604_, SoundSource.HOSTILE, 0.5f, 0.9f + RoyalZombie.this.f_19796_.m_188501_() * 0.2f);
        }

        public void m_5777_(Level p_34348_, BlockPos p_34349_) {
            p_34348_.m_5594_(null, p_34349_, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + p_34348_.f_46441_.m_188501_() * 0.2f);
        }

        public double m_8052_() {
            return 1.14;
        }
    }
}

