/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.entities.hostile;

import com.mongoose.royalvariations.client.particles.RVParticleTypes;
import com.mongoose.royalvariations.common.capabilities.misc.RVCapHelper;
import com.mongoose.royalvariations.common.effects.RVEffects;
import com.mongoose.royalvariations.common.entities.hostile.RoyalMonster;
import com.mongoose.royalvariations.utils.CustomExplosion;
import com.mongoose.royalvariations.utils.MathHelper;
import com.mongoose.royalvariations.utils.MobUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class RoyalCreeper
extends RoyalMonster
implements PowerableMob {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(RoyalCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(RoyalCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(RoyalCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(RoyalCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID DETONATE_SPEED_MODIFIER_UUID = UUID.fromString("d6f81dab-e48d-4eab-bcba-23a27b7e392b");
    private static final AttributeModifier DETONATE_SPEED_MODIFIER = new AttributeModifier(DETONATE_SPEED_MODIFIER_UUID, "Detonate Slow", -0.4, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static String IDLE = "idle";
    public static String BLESS = "bless";
    public static String DETONATE = "detonate";
    private boolean isWalking;
    private int toIdleTick;
    private int oldSwell;
    private int swell;
    private int maxSwell = 45;
    private int droppedSkulls;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState toIdleAnimationState = new AnimationState();
    public AnimationState blessAnimationState = new AnimationState();
    public AnimationState detonateAnimationState = new AnimationState();
    public AnimationState blinkAnimationState = new AnimationState();
    public AnimationState crownAnimationState = new AnimationState();

    public RoyalCreeper(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new KnightingGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RoyalSwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22278_, 0.2).m_22268_(Attributes.f_22284_, 9.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            compoundTag.m_128379_("powered", true);
        }
        compoundTag.m_128376_("Fuse", (short)this.maxSwell);
        compoundTag.m_128379_("ignited", this.isIgnited());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)compoundTag.m_128471_("powered"));
        if (compoundTag.m_128425_("Fuse", 99)) {
            this.maxSwell = compoundTag.m_128448_("Fuse");
        }
        if (compoundTag.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, IDLE)) {
            return 0;
        }
        if (Objects.equals(animation, BLESS)) {
            return 1;
        }
        if (Objects.equals(animation, DETONATE)) {
            return 2;
        }
        return 0;
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAnimations()) {
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.stopAllAnimation();
                    this.blessAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimation();
                    this.detonateAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.blessAnimationState);
        animationStates.add(this.detonateAnimationState);
        return animationStates;
    }

    public boolean isCurrentAnimation(String string) {
        return this.getCurrentAnimation() == this.getAnimationState(string);
    }

    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (p_32665_ instanceof Creeper) {
            return this.m_5647_() == null && p_32665_.m_5647_() == null;
        }
        return super.m_7307_(p_32665_);
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return SoundEvents.f_11836_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    public boolean m_142535_(float p_149687_, float p_149688_, DamageSource p_149689_) {
        boolean flag = super.m_142535_(p_149687_, p_149688_, p_149689_);
        this.swell += (int)(p_149687_ * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return flag;
    }

    public void m_6710_(@Nullable LivingEntity p_149691_) {
        if (!(p_149691_ instanceof Goat)) {
            super.m_6710_(p_149691_);
        }
    }

    public boolean m_7327_(Entity p_32281_) {
        return true;
    }

    @Override
    public void m_8119_() {
        int i;
        if (this.m_6084_()) {
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (!this.f_267362_.m_267780_()) {
                if (this.isWalking) {
                    this.isWalking = false;
                    this.toIdleTick = MathHelper.secondsToTicks(0.5f);
                }
            } else {
                this.isWalking = true;
            }
            if (this.toIdleTick > 0) {
                --this.toIdleTick;
            }
            boolean flag = !this.f_267362_.m_267780_() && this.isCurrentAnimation(IDLE);
            this.toIdleAnimationState.m_246184_(this.toIdleTick > 0 && flag, this.f_19797_);
            this.idleAnimationState.m_246184_(this.toIdleTick <= 0 && flag, this.f_19797_);
            this.blinkAnimationState.m_216982_(this.f_19797_);
            this.crownAnimationState.m_216982_(this.f_19797_);
        } else {
            i = this.getSwellDir();
            if (i > 0) {
                this.setAnimationState(DETONATE);
            } else if (this.isCurrentAnimation(DETONATE)) {
                this.setAnimationState(IDLE);
            }
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                AttributeInstance instance = this.m_21051_(Attributes.f_22279_);
                if (instance != null) {
                    if (i > 0) {
                        instance.m_22130_(DETONATE_SPEED_MODIFIER);
                        instance.m_22118_(DETONATE_SPEED_MODIFIER);
                    } else if (instance.m_22109_(DETONATE_SPEED_MODIFIER)) {
                        instance.m_22130_(DETONATE_SPEED_MODIFIER);
                    }
                }
                if (i > 0) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.SPARKLE.get()), this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), 1, 0.2, 0.2, 0.2, 0.1);
                }
            }
        }
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    public void m_8038_(ServerLevel p_32286_, LightningBolt p_32287_) {
        super.m_8038_(p_32286_, p_32287_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    private void explodeCreeper() {
        if (!this.m_9236_().f_46443_) {
            float f = this.m_7090_() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0f * f, Level.ExplosionInteraction.MOB);
            new CustomExplosion(this.m_9236_(), (Entity)this, this.m_269291_().m_269036_((Entity)this, (Entity)this), this.m_20185_(), this.m_20186_(), this.m_20189_(), 12.0f * f, 1.0f){

                @Override
                public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                    if (target instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)target;
                        if (EntitySelector.f_20406_.test(target) && target != RoyalCreeper.this) {
                            livingEntity.m_7292_(new MobEffectInstance((MobEffect)RVEffects.DAZED.get(), 300));
                        }
                    }
                }
            };
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.m_9236_().m_7967_((Entity)areaeffectcloud);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public boolean canDropMobsSkull() {
        return this.m_7090_() && this.droppedSkulls < 1;
    }

    public void increaseDroppedSkulls() {
        ++this.droppedSkulls;
    }

    static class KnightingGoal
    extends Goal {
        public static int FLASH_TIME = 15;
        public RoyalCreeper royal;
        public List<Mob> list = new ArrayList<Mob>();
        public int blessTick;

        public KnightingGoal(RoyalCreeper creeper) {
            this.royal = creeper;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.royal.getSwellDir() > 0) {
                return false;
            }
            if (this.royal.m_5448_() != null && this.royal.knightCool <= 0) {
                List list = this.royal.m_9236_().m_6443_(Mob.class, this.royal.m_5448_().m_20191_().m_82400_(6.0), mob -> !(mob instanceof RoyalCreeper) && mob instanceof Enemy);
                list.removeIf(mob -> MobUtil.areAllies((Entity)mob, (Entity)this.royal.m_5448_()));
                list.removeIf(mob -> !mob.m_142582_((Entity)this.royal));
                this.list = list;
                return !this.list.isEmpty();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.blessTick > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.royal.setAnimationState(BLESS);
            this.royal.m_21573_().m_26573_();
            this.royal.m_21566_().m_24988_(0.0f, 0.0f);
            this.blessTick = FLASH_TIME + 1;
            if (this.royal.m_5448_() != null) {
                this.royal.m_21563_().m_24960_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
                this.royal.m_21391_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
            }
            if (!this.list.isEmpty()) {
                for (Mob mob : this.list) {
                    if (mob.m_21023_((MobEffect)RVEffects.TIME_BOMB.get())) continue;
                    RVCapHelper.setFlashTick((LivingEntity)mob, FLASH_TIME);
                }
            }
        }

        public void m_8037_() {
            super.m_8037_();
            --this.blessTick;
            this.royal.m_21573_().m_26573_();
            this.royal.m_21566_().m_24988_(0.0f, 0.0f);
            if (this.royal.m_5448_() != null) {
                this.royal.m_21563_().m_24960_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
                this.royal.m_21391_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
            }
            if (this.blessTick == 1 && !this.list.isEmpty()) {
                Level level = this.royal.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i <= serverLevel.m_213780_().m_188503_(10) + 10; ++i) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.HOLY.get()), this.royal.m_20208_(1.5), this.royal.m_20187_(), this.royal.m_20262_(1.5), 0, 0.0, 1.0, 0.0, 1.0);
                    }
                }
                this.royal.m_5496_(SoundEvents.f_11862_, 0.9f, 1.0f);
                for (Mob mob : this.list) {
                    Level level2 = this.royal.m_9236_();
                    if (!(level2 instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level2;
                    mob.m_7292_(new MobEffectInstance((MobEffect)RVEffects.TIME_BOMB.get(), 100, 0, false, false));
                    mob.m_5496_(SoundEvents.f_144051_, 0.9f, 1.0f);
                    serverLevel.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), SoundEvents.f_144051_, SoundSource.HOSTILE, 0.9f, 1.0f);
                    for (int i = 0; i <= serverLevel.m_213780_().m_188503_(10) + 10; ++i) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.HOLY.get()), mob.m_20208_(1.5), mob.m_20187_(), mob.m_20262_(1.5), 0, 0.0, 1.0, 0.0, 1.0);
                    }
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.blessTick = 0;
            this.royal.knightCool = 350;
            this.royal.setAnimationState(IDLE);
            this.list.clear();
        }
    }

    public static class RoyalSwellGoal
    extends Goal {
        private final RoyalCreeper creeper;
        @Nullable
        private LivingEntity target;

        public RoyalSwellGoal(RoyalCreeper p_25919_) {
            this.creeper = p_25919_;
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.creeper.m_5448_();
            return this.creeper.getSwellDir() > 0 || livingentity != null && (double)this.creeper.m_20270_((Entity)livingentity) < 3.0;
        }

        public void m_8056_() {
            this.target = this.creeper.m_5448_();
            if (this.target != null) {
                this.creeper.m_21573_().m_5624_((Entity)this.target, 1.0);
            }
        }

        public void m_8041_() {
            this.target = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target == null) {
                this.creeper.setSwellDir(-1);
            } else if ((double)this.creeper.m_20270_((Entity)this.target) > 7.0) {
                this.creeper.setSwellDir(-1);
            } else if (!this.creeper.m_21574_().m_148306_((Entity)this.target)) {
                this.creeper.setSwellDir(-1);
            } else {
                this.creeper.setSwellDir(1);
            }
        }
    }
}

