/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.capabilities.misc;

import com.mongoose.royalvariations.common.capabilities.misc.IRVCap;
import com.mongoose.royalvariations.common.capabilities.misc.RVCapImp;
import com.mongoose.royalvariations.common.capabilities.misc.RVCapProvider;
import com.mongoose.royalvariations.common.capabilities.misc.RVCapUpdatePacket;
import com.mongoose.royalvariations.common.network.RVNetwork;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class RVCapHelper {
    public static IRVCap getCapability(LivingEntity livingEntity) {
        return (IRVCap)livingEntity.getCapability(RVCapProvider.CAPABILITY).orElse((Object)new RVCapImp());
    }

    public static boolean isFlashing(LivingEntity livingEntity) {
        return RVCapHelper.getCapability(livingEntity).getFlashTick() > 0;
    }

    public static int getFlashTick(LivingEntity livingEntity) {
        return RVCapHelper.getCapability(livingEntity).getFlashTick();
    }

    public static void setFlashTick(LivingEntity livingEntity, int tick) {
        RVCapHelper.getCapability(livingEntity).setFlashTick(tick);
        if (!livingEntity.m_9236_().f_46443_) {
            RVCapHelper.sendMiscUpdatePacket(livingEntity);
        }
    }

    public static void decreaseFlashTick(LivingEntity livingEntity) {
        RVCapHelper.setFlashTick(livingEntity, RVCapHelper.getFlashTick(livingEntity) - 1);
    }

    public static boolean isMarked(LivingEntity livingEntity) {
        return RVCapHelper.getCapability(livingEntity).getMarkedTick() > 0;
    }

    public static void setMarkedTick(LivingEntity livingEntity, int tick) {
        RVCapHelper.getCapability(livingEntity).setMarkedTick(tick);
        if (!livingEntity.m_9236_().f_46443_) {
            RVCapHelper.sendMiscUpdatePacket(livingEntity);
        }
    }

    public static boolean isGazed(LivingEntity livingEntity) {
        return RVCapHelper.getCapability(livingEntity).getPressingGazeTick() > 0;
    }

    public static void setGazeTick(LivingEntity livingEntity, int tick) {
        RVCapHelper.getCapability(livingEntity).setPressingGazeTick(tick);
        if (!livingEntity.m_9236_().f_46443_) {
            RVCapHelper.sendMiscUpdatePacket(livingEntity);
        }
    }

    public static CompoundTag save(CompoundTag tag, IRVCap misc) {
        tag.m_128405_("flashTick", misc.getFlashTick());
        tag.m_128405_("markedTick", misc.getMarkedTick());
        tag.m_128405_("gazeTick", misc.getPressingGazeTick());
        return tag;
    }

    public static IRVCap load(CompoundTag tag, IRVCap misc) {
        if (tag.m_128441_("flashTick")) {
            misc.setFlashTick(tag.m_128451_("flashTick"));
        }
        if (tag.m_128441_("markedTick")) {
            misc.setMarkedTick(tag.m_128451_("markedTick"));
        }
        if (tag.m_128441_("gazeTick")) {
            misc.setPressingGazeTick(tag.m_128451_("gazeTick"));
        }
        return misc;
    }

    public static void sendMiscUpdatePacket(LivingEntity livingEntity) {
        if (!livingEntity.m_9236_().f_46443_) {
            RVNetwork.sentToTrackingEntityAndPlayer((Entity)livingEntity, new RVCapUpdatePacket(livingEntity));
        }
    }
}

