/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.client.highlights.base.Highlight;
import com.teamresourceful.resourcefullib.client.highlights.base.Highlightable;
import com.teamresourceful.resourcefullib.client.highlights.state.HighlightStates;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class HighlightHandler
extends SimpleJsonResourceReloadListener {
    private static final Map<BlockState, Highlight> STATE_CACHE = new HashMap<BlockState, Highlight>();
    private static final Map<ResourceLocation, Highlight> BOX_CACHE = new HashMap<ResourceLocation, Highlight>();
    public static final Codec<Highlight> HIGHLIGHT_CODEC = ResourceLocation.f_135803_.xmap(HighlightHandler::getOrThrow, Highlight::id);

    public HighlightHandler() {
        super(new Gson(), "resourcefullib/highlights");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> jsons, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        BOX_CACHE.clear();
        STATE_CACHE.clear();
        HashMap<ResourceLocation, JsonElement> highlights = new HashMap<ResourceLocation, JsonElement>();
        HashMap<ResourceLocation, JsonElement> blocks = new HashMap<ResourceLocation, JsonElement>();
        jsons.forEach((key, json) -> (json.isJsonObject() && json.getAsJsonObject().has("lines") ? highlights : blocks).put(key, json));
        highlights.forEach((key, value) -> Highlight.codec(key).parse((DynamicOps)JsonOps.INSTANCE, value).result().ifPresent(box -> BOX_CACHE.put((ResourceLocation)key, (Highlight)box)));
        blocks.forEach((key, value) -> BuiltInRegistries.f_256975_.m_6612_(key).flatMap(block -> HighlightStates.codec(block).parse((DynamicOps)JsonOps.INSTANCE, value).result()).ifPresent(variants -> variants.states().forEach((states, box) -> states.forEach(state -> STATE_CACHE.put((BlockState)state, (Highlight)box)))));
    }

    public static boolean onBlockHighlight(Vec3 cameraPos, Entity cameraEntity, PoseStack stack, BlockPos blockPos, BlockState state, VertexConsumer consumer) {
        Highlightable highlightable;
        Highlight highlight;
        Block block = state.m_60734_();
        if (block instanceof Highlightable && (highlight = (highlightable = (Highlightable)block).getHighlight(cameraEntity.m_9236_(), blockPos, state)) != null) {
            highlight.render(consumer, stack, cameraPos, state.m_60824_((BlockGetter)cameraEntity.m_9236_(), blockPos), blockPos);
            return true;
        }
        if (STATE_CACHE.containsKey(state)) {
            STATE_CACHE.get(state).render(consumer, stack, cameraPos, state.m_60824_((BlockGetter)cameraEntity.m_9236_(), blockPos), blockPos);
            return true;
        }
        return false;
    }

    private static Highlight getOrThrow(ResourceLocation id) {
        Highlight highlight = BOX_CACHE.get(id);
        if (highlight == null) {
            throw new RuntimeException("No highlight with the id '" + id + "' was found!");
        }
        return highlight;
    }
}

