/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model.baked;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.Cover;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.refinedmods.refinedstorage.item.CoverItem;
import com.refinedmods.refinedstorage.render.model.baked.CableCoverBakedModel;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class CableCoverItemBakedModel
implements BakedModel {
    private static final LoadingCache<CacheKey, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            CableCoverBakedModel.addCover(quads, new Cover(key.stack, key.type), Direction.NORTH, key.side, key.random, null, null, true);
            return quads;
        }
    });
    private final ItemStack stack;
    private final CoverType type;

    public CableCoverItemBakedModel(ItemStack stack, CoverType type) {
        this.stack = stack;
        this.type = type;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        if (this.stack.m_41619_()) {
            return Collections.emptyList();
        }
        CacheKey key = new CacheKey(state, CoverItem.getItem(this.stack), side, this.type, rand);
        return (List)CACHE.getUnchecked((Object)key);
    }

    public ItemOverrides m_7343_() {
        return new ItemOverrides(){

            public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p) {
                return new CableCoverItemBakedModel(stack, CableCoverItemBakedModel.this.type);
            }
        };
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        return List.of(this);
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return null;
    }

    public boolean useAmbientOcclusion(BlockState state) {
        return true;
    }

    public ItemTransforms m_7442_() {
        return RenderUtils.getDefaultBlockTransforms();
    }

    public boolean m_7547_() {
        return true;
    }

    private static class CacheKey {
        private final BlockState state;
        private final ItemStack stack;
        private final Direction side;
        private final CoverType type;
        private final RandomSource random;

        CacheKey(BlockState state, ItemStack stack, Direction side, CoverType type, RandomSource rand) {
            this.state = state;
            this.stack = stack;
            this.side = side;
            this.type = type;
            this.random = rand;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return cacheKey.type == this.type && cacheKey.stack.m_41720_() == this.stack.m_41720_() && cacheKey.side == this.side && Objects.equals(cacheKey.state, this.state);
        }

        public int hashCode() {
            int result = this.stack.m_41720_().hashCode();
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

