/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.network.ClientProxy;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class GridCraftingPreviewResponseMessage {
    private final List<ICraftingPreviewElement> elements;
    private final UUID id;
    private final int quantity;
    private final boolean fluids;

    public GridCraftingPreviewResponseMessage(List<ICraftingPreviewElement> elements, UUID id, int quantity, boolean fluids) {
        this.elements = elements;
        this.id = id;
        this.quantity = quantity;
        this.fluids = fluids;
    }

    public static GridCraftingPreviewResponseMessage decode(FriendlyByteBuf buf) {
        UUID id = buf.m_130259_();
        int quantity = buf.readInt();
        boolean fluids = buf.readBoolean();
        LinkedList<ICraftingPreviewElement> elements = new LinkedList<ICraftingPreviewElement>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation type = buf.m_130281_();
            elements.add(API.instance().getCraftingPreviewElementRegistry().get(type).apply(buf));
        }
        return new GridCraftingPreviewResponseMessage(elements, id, quantity, fluids);
    }

    public static void encode(GridCraftingPreviewResponseMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.id);
        buf.writeInt(message.quantity);
        buf.writeBoolean(message.fluids);
        buf.writeInt(message.elements.size());
        for (ICraftingPreviewElement element : message.elements) {
            buf.m_130085_(element.getId());
            element.write(buf);
        }
    }

    public static void handle(GridCraftingPreviewResponseMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientProxy.onReceivedCraftingPreviewResponseMessage(message));
        ctx.get().setPacketHandled(true);
    }

    public List<ICraftingPreviewElement> getElements() {
        return this.elements;
    }

    public UUID getId() {
        return this.id;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public boolean isFluids() {
        return this.fluids;
    }
}

