/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.integration.jei.Ingredient;
import com.refinedmods.refinedstorage.item.PatternItem;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.ItemGridStack;
import com.refinedmods.refinedstorage.screen.grid.view.IGridView;
import com.refinedmods.refinedstorage.util.ItemStackKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class IngredientTracker {
    private static IngredientTracker INSTANCE;
    private final Map<ItemStackKey, Integer> storedItems = new HashMap<ItemStackKey, Integer>();
    private final Map<ItemStackKey, Integer> patternItems = new HashMap<ItemStackKey, Integer>();
    private final Map<ItemStackKey, UUID> craftableItems = new HashMap<ItemStackKey, UUID>();

    public static IngredientTracker getTracker(GridContainerMenu gridContainer) {
        if (INSTANCE == null) {
            INSTANCE = new IngredientTracker(gridContainer);
        }
        return INSTANCE;
    }

    public static void invalidate() {
        INSTANCE = null;
    }

    public IngredientTracker(GridContainerMenu gridContainer) {
        IGridView view = ((GridScreen)gridContainer.getScreenInfoProvider()).getView();
        view.addDeltaListener(iGridStack -> {
            if (iGridStack instanceof ItemGridStack) {
                ItemGridStack stack = (ItemGridStack)iGridStack;
                if (stack.isCraftable()) {
                    this.craftableItems.put(new ItemStackKey(stack.getStack()), stack.getId());
                } else {
                    this.addStack(stack.getStack());
                }
            }
        });
        Collection<IGridStack> gridStacks = view.getAllStacks();
        if (gridContainer.getGrid().isGridActive()) {
            for (IGridStack gridStack : gridStacks) {
                if (!(gridStack instanceof ItemGridStack)) continue;
                ItemGridStack stackInGrid = (ItemGridStack)gridStack;
                if (stackInGrid.isCraftable()) {
                    this.craftableItems.put(new ItemStackKey(stackInGrid.getStack()), gridStack.getId());
                    continue;
                }
                this.addStack(stackInGrid.getStack());
            }
        }
    }

    public void addStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_41720_() instanceof ICraftingPatternProvider) {
            ICraftingPattern pattern = PatternItem.fromCache((Level)Minecraft.m_91087_().f_91073_, stack);
            if (pattern.isValid()) {
                for (ItemStack outputStack : pattern.getOutputs()) {
                    this.patternItems.merge(new ItemStackKey(outputStack), 1, Integer::sum);
                }
            }
        } else {
            this.storedItems.merge(new ItemStackKey(stack), stack.m_41613_(), Integer::sum);
        }
    }

    public ItemStack findBestMatch(GridContainerMenu gridContainer, Player player, List<ItemStack> list) {
        ItemStack resultStack = ItemStack.f_41583_;
        int count = 0;
        for (ItemStack listStack : list) {
            CraftingContainer craftingMatrix;
            if (gridContainer.getGrid().getGridType().equals((Object)GridType.CRAFTING) && (craftingMatrix = gridContainer.getGrid().getCraftingMatrix()) != null) {
                for (int matrixSlot = 0; matrixSlot < craftingMatrix.m_6643_(); ++matrixSlot) {
                    ItemStack stackInSlot = craftingMatrix.m_8020_(matrixSlot);
                    if (!API.instance().getComparer().isEqual(listStack, stackInSlot, 1) || stackInSlot.m_41613_() <= count) continue;
                    count = stackInSlot.m_41613_();
                    resultStack = stackInSlot;
                }
            }
            for (int inventorySlot = 0; inventorySlot < player.m_150109_().m_6643_(); ++inventorySlot) {
                ItemStack stackInSlot = player.m_150109_().m_8020_(inventorySlot);
                if (!API.instance().getComparer().isEqual(listStack, stackInSlot, 1) || stackInSlot.m_41613_() <= count) continue;
                count = stackInSlot.m_41613_();
                resultStack = stackInSlot;
            }
            Integer stored = this.storedItems.get(new ItemStackKey(listStack));
            if (stored == null || stored <= count) continue;
            resultStack = listStack;
            count = stored;
        }
        if (count == 0) {
            for (ItemStack itemStack : list) {
                ItemStackKey key = new ItemStackKey(itemStack);
                if (this.craftableItems.get(key) != null) {
                    resultStack = itemStack;
                    break;
                }
                if (this.patternItems.get(key) == null) continue;
                resultStack = itemStack;
                break;
            }
        }
        return resultStack;
    }

    public void updateAvailability(Ingredient.IngredientList ingredientList, GridContainerMenu gridContainer, Player player) {
        HashMap usedMatrixStacks = new HashMap();
        HashMap usedInventoryStacks = new HashMap();
        HashMap usedStoredStacks = new HashMap();
        for (Ingredient ingredient : ingredientList.ingredients) {
            ingredient.getSlotView().getItemStacks().takeWhile(stack -> !ingredient.isAvailable()).forEach(stack -> {
                CraftingContainer craftingMatrix;
                if (ingredient.getCraftStackId() == null) {
                    ingredient.setCraftStackId(this.craftableItems.get(new ItemStackKey((ItemStack)stack)));
                }
                if (gridContainer.getGrid().getGridType().equals((Object)GridType.CRAFTING) && (craftingMatrix = gridContainer.getGrid().getCraftingMatrix()) != null) {
                    for (int matrixSlot = 0; matrixSlot < craftingMatrix.m_6643_(); ++matrixSlot) {
                        if (!this.checkStack(usedMatrixStacks, ingredient, (ItemStack)stack, matrixSlot, craftingMatrix.m_8020_(matrixSlot))) continue;
                        return;
                    }
                }
                for (int inventorySlot = 0; inventorySlot < player.m_150109_().m_6643_(); ++inventorySlot) {
                    if (!this.checkStack(usedInventoryStacks, ingredient, (ItemStack)stack, inventorySlot, player.m_150109_().m_8020_(inventorySlot))) continue;
                    return;
                }
                ItemStackKey key = new ItemStackKey((ItemStack)stack);
                Integer stored = this.storedItems.get(key);
                if (stored != null) {
                    Integer used = (Integer)usedStoredStacks.get(key);
                    int amount = Math.min(ingredient.getMissingAmount(), used == null ? stored : stored - used);
                    if (amount > 0) {
                        ingredient.fulfill(amount);
                        usedStoredStacks.put(key, used == null ? amount : used + amount);
                    }
                }
            });
        }
    }

    private boolean checkStack(Map<Integer, Integer> usedMatrixStacks, Ingredient ingredient, ItemStack stack, int slot, ItemStack stackInSlot) {
        if (API.instance().getComparer().isEqual(stack, stackInSlot, 1)) {
            Integer used = usedMatrixStacks.get(slot);
            int amount = Math.min(ingredient.getMissingAmount(), used == null ? stackInSlot.m_41613_() : stackInSlot.m_41613_() - used);
            if (amount > 0) {
                ingredient.fulfill(amount);
                usedMatrixStacks.put(slot, used == null ? amount : used + amount);
            }
            return ingredient.isAvailable();
        }
        return false;
    }
}

