/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;

class Ingredient {
    private final IRecipeSlotView slotView;
    private final int required;
    private UUID craftStackId;
    private int fulfilled;

    public Ingredient(IRecipeSlotView view, int count) {
        this.slotView = view;
        this.required = count;
    }

    public boolean isAvailable() {
        return this.getMissingAmount() <= 0;
    }

    public int getMissingAmount() {
        return this.required - this.fulfilled;
    }

    public boolean isCraftable() {
        return this.craftStackId != null;
    }

    public IRecipeSlotView getSlotView() {
        return this.slotView;
    }

    public UUID getCraftStackId() {
        return this.craftStackId;
    }

    public void setCraftStackId(UUID craftStackId) {
        this.craftStackId = craftStackId;
    }

    public void fulfill(int amount) {
        this.fulfilled += amount;
    }

    static class IngredientList {
        List<Ingredient> ingredients = new ArrayList<Ingredient>();

        IngredientList() {
        }

        void add(Ingredient ingredient) {
            this.ingredients.add(ingredient);
        }

        public boolean hasMissing() {
            return this.ingredients.stream().anyMatch(ingredient -> !ingredient.isAvailable());
        }

        public boolean hasMissingButAutocraftingAvailable() {
            return this.ingredients.stream().anyMatch(ingredient -> !ingredient.isAvailable() && ingredient.isCraftable());
        }

        public boolean isAutocraftingAvailable() {
            return this.ingredients.stream().anyMatch(Ingredient::isCraftable);
        }

        public Map<UUID, Integer> createCraftingRequests() {
            HashMap<UUID, Integer> toRequest = new HashMap<UUID, Integer>();
            for (Ingredient ingredient : this.ingredients) {
                if (ingredient.isAvailable() || !ingredient.isCraftable()) continue;
                toRequest.merge(ingredient.getCraftStackId(), ingredient.getMissingAmount(), Integer::sum);
            }
            return toRequest;
        }
    }
}

