/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import com.mojang.datafixers.util.Pair;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PickaxeHeaterItem
extends WearableRelicItem {
    private static final Container container = new SimpleContainer(3);
    @Nullable
    private static ResourceLocation lastRecipe;

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"heater").active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder((String)"capacity").initialValue(20.0, 25.0).upgradeModifier(UpgradeOperation.ADD, 5.0).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"duration").initialValue(140.0, 120.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.083).formatValue(value -> MathUtils.round((double)(value / 20.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-7103326).borderBottom(-9868420).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        block3: {
            block2: {
                if (!(entity instanceof Player)) break block2;
                Player player = (Player)entity;
                if ((long)player.f_19797_ % Math.round(this.getAbilityValue(stack, "heater", "duration")) == 0L && (long)PickaxeHeaterItem.getCharges(stack) < Math.round(this.getAbilityValue(stack, "heater", "capacity"))) break block3;
            }
            return;
        }
        PickaxeHeaterItem.addCharges(stack, 1);
    }

    public static void addCharges(ItemStack stack, int amount) {
        NBTUtils.setInt((ItemStack)stack, (String)"charge", (int)(PickaxeHeaterItem.getCharges(stack) + amount));
    }

    public static int getCharges(ItemStack stack) {
        return NBTUtils.getInt((ItemStack)stack, (String)"charge", (int)0);
    }

    public static ObjectArrayList<ItemStack> getModifiedBlockDrops(ObjectArrayList<ItemStack> items, LootContext context) {
        Object object;
        if (context.m_78936_(LootContextParams.f_81461_) && context.m_78936_(LootContextParams.f_81455_) && context.m_78936_(LootContextParams.f_81460_) && (object = context.m_165124_(LootContextParams.f_81455_)) instanceof Player) {
            PickaxeHeaterItem relic;
            Item item;
            Player player = (Player)object;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.PICKAXE_HEATER.get()));
            Level level = player.m_20193_();
            if (level.m_5776_() || !((item = stack.m_41720_()) instanceof PickaxeHeaterItem) || !(relic = (PickaxeHeaterItem)item).isAbilityTicking(stack, "heater") || PickaxeHeaterItem.getCharges(stack) <= 1) {
                return items;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            ObjectArrayList result = new ObjectArrayList(items.size());
            boolean hasSmeltableItems = false;
            ObjectListIterator objectListIterator = items.iterator();
            while (objectListIterator.hasNext()) {
                ItemStack item2;
                ItemStack resultItem = item2 = (ItemStack)objectListIterator.next();
                Optional<AbstractCookingRecipe> recipe = PickaxeHeaterItem.getRecipeFor(item2, (Level)serverLevel);
                if (recipe.isPresent()) {
                    resultItem = recipe.get().m_5874_(container, serverLevel.m_9598_());
                    resultItem.m_41764_(resultItem.m_41613_() * item2.m_41613_());
                    hasSmeltableItems = true;
                }
                result.add((Object)resultItem);
            }
            if (hasSmeltableItems) {
                Vec3 center = (Vec3)context.m_165124_(LootContextParams.f_81460_);
                RandomSource random = level.m_213780_();
                if (!level.m_5776_()) {
                    serverLevel.m_8767_(ParticleUtils.constructSimpleSpark((Color)new Color(150 + random.m_188503_(106), random.m_188503_(50), 50 + random.m_188503_(51), 255), (float)0.6f, (int)20, (float)0.85f), center.m_7096_(), center.m_7098_(), center.m_7094_(), 25, 0.3, 0.3, 0.3, 0.01);
                }
                PickaxeHeaterItem.addCharges(stack, -1);
                relic.spreadExperience((LivingEntity)player, stack, 1);
                return result;
            }
        }
        return items;
    }

    public static Optional<AbstractCookingRecipe> getRecipeFor(ItemStack item, Level level) {
        container.m_6211_();
        container.m_6836_(0, item);
        RecipeManager recipeManager = level.m_7465_();
        Optional optional = recipeManager.m_220248_(RecipeType.f_44108_, container, level, lastRecipe);
        if (optional.isPresent()) {
            Pair pair = (Pair)optional.get();
            lastRecipe = (ResourceLocation)pair.getFirst();
            return Optional.of((AbstractCookingRecipe)pair.getSecond());
        }
        return Optional.empty();
    }
}

