/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class DiggingClawsItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"passive").maxLevel(0).build()).ability(AbilityData.builder((String)"fast_mining").stat(StatData.builder((String)"modifier").initialValue(0.15, 0.35).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.4).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)0)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-15961632).borderBottom(-15394423).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    @Mod.EventBusSubscriber
    public static class DiggingClawsEvent {
        @SubscribeEvent
        public static void onDiggingClawsHarvestCheck(PlayerEvent.HarvestCheck event) {
            BlockState blockState = event.getTargetBlock();
            Player player = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.DIGGING_CLAWS.get()));
            if (player.m_20193_().m_5776_() || !(stack.m_41720_() instanceof DiggingClawsItem) || event.canHarvest()) {
                return;
            }
            Item item = player.m_21205_().m_41720_();
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                int tier = DiggingClawsEvent.getTierFromString(tieredItem.m_43314_());
                if (tier + 1 >= DiggingClawsEvent.getRequiredToolTier(blockState)) {
                    event.setCanHarvest(true);
                }
            } else if (!blockState.m_60834_() || DiggingClawsEvent.getRequiredToolTier(blockState) <= 1) {
                event.setCanHarvest(true);
            }
        }

        @SubscribeEvent
        public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            DiggingClawsItem relic;
            Player player = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.DIGGING_CLAWS.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof DiggingClawsItem) || !(relic = (DiggingClawsItem)item).canPlayerUseActiveAbility(player, stack, "fast_mining")) {
                return;
            }
            float original = event.getOriginalSpeed();
            event.setNewSpeed((float)((double)original + (double)original * relic.getAbilityValue(stack, "fast_mining", "modifier")));
        }

        @SubscribeEvent
        public static void onBlockDestroy(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.DIGGING_CLAWS.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof DiggingClawsItem)) {
                return;
            }
            DiggingClawsItem relic = (DiggingClawsItem)item;
            float hardness = event.getState().m_60800_((BlockGetter)player.m_9236_(), player.m_20183_()) / 20.0f;
            if (player.m_217043_().m_188500_() <= (double)hardness) {
                relic.spreadExperience((LivingEntity)player, stack, 1);
            }
        }

        public static int getTierFromString(Tier tier) {
            if (tier == Tiers.STONE) {
                return 2;
            }
            if (tier == Tiers.IRON) {
                return 3;
            }
            if (tier == Tiers.GOLD) {
                return 4;
            }
            if (tier == Tiers.DIAMOND) {
                return 5;
            }
            if (tier == Tiers.NETHERITE) {
                return 6;
            }
            return 1;
        }

        public static int getRequiredToolTier(BlockState state) {
            if (!state.m_60834_()) {
                return 0;
            }
            if (state.m_204336_(BlockTags.f_144284_)) {
                return 5;
            }
            if (state.m_204336_(BlockTags.f_144285_)) {
                return 3;
            }
            if (state.m_204336_(BlockTags.f_144286_)) {
                return 2;
            }
            return 1;
        }
    }
}

