/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.ForegroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Position;
import net.minecraft.client.gui.Font;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiText
extends GuiElement<GuiText>
implements ForegroundRender {
    private Supplier<Component> text;
    private Supplier<Boolean> shadow = () -> true;
    private Supplier<Integer> textColour = () -> -1;
    private Supplier<Double> rotation = null;
    private Position rotatePoint = Position.create(() -> this.xSize() / 2.0, () -> this.ySize() / 2.0);
    private boolean trim = false;
    private boolean wrap = false;
    private boolean scroll = true;
    private Align alignment = Align.CENTER;

    public GuiText(@NotNull GuiParent<?> parent) {
        this(parent, () -> null);
    }

    public GuiText(@NotNull GuiParent<?> parent, @Nullable Component text) {
        this(parent, () -> text);
    }

    public GuiText(@NotNull GuiParent<?> parent, @NotNull Supplier<@Nullable Component> text) {
        super(parent);
        this.text = text;
    }

    public GuiText autoHeight() {
        this.constrain(GeoParam.HEIGHT, Constraint.dynamic(() -> {
            double d;
            if (this.wrap) {
                d = this.font().m_239133_((FormattedText)this.getText(), (int)this.xSize());
            } else {
                Objects.requireNonNull(this.font());
                d = 9.0;
            }
            return d;
        }));
        return this;
    }

    public GuiText setTextSupplier(@NotNull Supplier<@Nullable Component> textSupplier) {
        this.text = textSupplier;
        return this;
    }

    public GuiText setText(@Nullable Component text) {
        this.text = () -> text;
        return this;
    }

    public GuiText setText(@NotNull String text) {
        this.text = () -> Component.m_237113_((String)text);
        return this;
    }

    public GuiText setTranslatable(@NotNull String translationKey) {
        this.text = () -> Component.m_237115_((String)translationKey);
        return this;
    }

    @Nullable
    public Component getText() {
        return this.text.get();
    }

    public GuiText setAlignment(Align alignment) {
        this.alignment = alignment;
        return this;
    }

    public Align getAlignment() {
        return this.alignment;
    }

    public GuiText setTrim(boolean trim) {
        this.trim = trim;
        if (trim) {
            this.scroll = false;
            this.wrap = false;
        }
        return this;
    }

    public boolean getTrim() {
        return this.trim;
    }

    public GuiText setWrap(boolean wrap) {
        this.wrap = wrap;
        if (wrap) {
            this.scroll = false;
            this.trim = false;
        }
        return this;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public GuiText setScroll(boolean scroll) {
        this.scroll = scroll;
        if (scroll) {
            this.wrap = false;
            this.trim = false;
        }
        return this;
    }

    public boolean getScroll() {
        return this.scroll;
    }

    public GuiText setShadow(@NotNull Supplier<Boolean> shadow) {
        this.shadow = shadow;
        return this;
    }

    public GuiText setShadow(boolean shadow) {
        this.shadow = () -> shadow;
        return this;
    }

    public boolean getShadow() {
        return this.shadow.get();
    }

    public GuiText setTextColour(Supplier<Integer> textColour) {
        this.textColour = textColour;
        return this;
    }

    public GuiText setTextColour(int textColour) {
        this.textColour = () -> textColour;
        return this;
    }

    public int getTextColour() {
        return this.textColour.get();
    }

    public GuiText setRotation(double rotation) {
        return this.setRotation(() -> rotation);
    }

    public GuiText setRotation(@Nullable Supplier<Double> rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiText setRotatePoint(Position rotatePoint) {
        this.rotatePoint = rotatePoint;
        return this;
    }

    @Override
    public double getForegroundDepth() {
        return 0.05;
    }

    @Override
    public void renderInFront(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        Component component = this.getText();
        if (component == null) {
            return;
        }
        Font font = render.font();
        Objects.requireNonNull(font);
        int textHeight = 9;
        int textWidth = font.m_92852_((FormattedText)component);
        boolean tooLong = (double)textWidth > this.xSize();
        double yPos = this.yMin() + this.ySize() / 2.0 - (double)textHeight / 2.0 + 1.0;
        PoseStack stack = render.pose();
        if (this.rotation != null) {
            stack.m_85836_();
            stack.m_85837_(this.xMin() + this.rotatePoint.x(), this.yMin() + this.rotatePoint.y(), 0.0);
            stack.m_252781_(Axis.f_252403_.m_252977_(this.rotation.get().floatValue()));
            stack.m_85837_(-this.xMin() - this.rotatePoint.x(), -this.yMin() - this.rotatePoint.y(), 0.0);
        }
        if (tooLong && this.getTrim()) {
            MutableComponent tail = Component.m_237113_((String)"...").m_6270_(this.getText().m_7383_());
            FormattedText head = font.m_92865_().m_92389_((FormattedText)component, (int)this.xSize() - font.m_92852_((FormattedText)tail), this.getText().m_7383_());
            FormattedCharSequence formatted = Language.m_128107_().m_5536_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{head, tail}));
            textWidth = font.m_92724_(formatted);
            double xPos = this.alignment == Align.MIN ? this.xMin() : (this.alignment == Align.MAX ? this.xMax() - (double)textWidth : this.xMin() + this.xSize() / 2.0 - (double)textWidth / 2.0);
            render.drawString(formatted, xPos, yPos, this.getTextColour(), this.getShadow());
        } else if ((tooLong || this.font().m_92923_((FormattedText)component, Integer.MAX_VALUE).size() > 1) && this.wrap) {
            textHeight = font.m_239133_((FormattedText)component, (int)this.xSize());
            List list = font.m_92923_((FormattedText)component, (int)this.xSize());
            yPos = this.yMin() + this.ySize() / 2.0 - (double)textHeight / 2.0;
            for (FormattedCharSequence line : list) {
                int lineWidth = font.m_92724_(line);
                double xPos = this.alignment == Align.MIN ? this.xMin() : (this.alignment == Align.MAX ? this.xMax() - (double)lineWidth : this.xMin() + this.xSize() / 2.0 - (double)lineWidth / 2.0);
                render.drawString(line, xPos, yPos, this.getTextColour(), this.getShadow());
                Objects.requireNonNull(font);
                yPos += 9.0;
            }
        } else if (tooLong && this.scroll) {
            render.pushScissorRect(this.getRectangle());
            render.drawScrollingString(component, this.xMin(), yPos, this.xMax(), this.getTextColour(), this.getShadow(), false);
            render.popScissor();
        } else {
            double xPos = this.alignment == Align.MIN ? this.xMin() : (this.alignment == Align.MAX ? this.xMax() - (double)textWidth : this.xMin() + this.xSize() / 2.0 - (double)textWidth / 2.0);
            render.drawString(component, xPos, yPos, this.getTextColour(), this.getShadow());
        }
        if (this.rotation != null) {
            stack.m_85849_();
        }
    }
}

