/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.element.effect;

import com.mojang.serialization.Codec;
import dev.obscuria.tooltips.client.element.effect.IconParticleEffect;
import dev.obscuria.tooltips.client.element.effect.InwardParticleEffect;
import dev.obscuria.tooltips.client.element.effect.RayGlowEffect;
import dev.obscuria.tooltips.client.element.effect.RimLightEffect;
import dev.obscuria.tooltips.client.renderer.TooltipContext;
import dev.obscuria.tooltips.registry.TooltipsRegistries;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;

public interface TooltipEffect {
    public static final Codec<TooltipEffect> DIRECT_CODEC = TooltipsRegistries.TOOLTIP_EFFECT_TYPE.byNameCodec().dispatch(TooltipEffect::codec, Function.identity());
    public static final Codec<TooltipEffect> CODEC = TooltipsRegistries.Resource.TOOLTIP_EFFECT.byNameCodec();

    public Codec<? extends TooltipEffect> codec();

    public boolean canApply(List<TooltipEffect> var1);

    default public void renderIcon(GuiGraphics graphics, TooltipContext context, int x, int y) {
    }

    default public void renderBack(GuiGraphics graphics, TooltipContext context, int x, int y, int width, int height) {
    }

    default public void renderFront(GuiGraphics graphics, TooltipContext context, int x, int y, int width, int height) {
    }

    public static void bootstrap(BiConsumer<String, Supplier<Codec<? extends TooltipEffect>>> registrar) {
        registrar.accept("rim_light", () -> RimLightEffect.CODEC);
        registrar.accept("ray_glow", () -> RayGlowEffect.CODEC);
        registrar.accept("inward_particle", () -> InwardParticleEffect.CODEC);
        registrar.accept("icon_particle", () -> IconParticleEffect.CODEC);
    }
}

