/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.obscuria.obscureapi.api.client.ExternalData;
import com.obscuria.obscureapi.api.utils.ExceptionFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ExternalTexture
implements ExternalData<ResourceLocation> {
    public static final ResourceLocation BLANK = new ResourceLocation("obscure_api", "textures/blank_external_texture.png");
    private final String LINK;
    private final ResourceLocation OFFLINE;
    private final ResourceLocation ONLINE;
    private final String NAME;
    private final boolean AUTO_UPLOAD;
    private final Consumer<ExternalTexture> CALLBACK;
    private boolean uploaded = false;
    @Nullable
    private CompletableFuture<?> future = null;

    private ExternalTexture(ResourceLocation location, String name, ResourceLocation offline, String link, boolean autoUpload, @Nullable Consumer<ExternalTexture> callback) {
        this.OFFLINE = offline;
        this.ONLINE = new ResourceLocation(location.m_135827_(), location.m_135815_() + "/" + name);
        this.NAME = name;
        this.AUTO_UPLOAD = autoUpload;
        this.CALLBACK = callback;
        this.LINK = link;
        if (this.AUTO_UPLOAD) {
            this.upload();
        }
    }

    @Nonnull
    public static ExternalTexture create(ResourceLocation location, String name, String link) {
        return ExternalTexture.create(location, name, BLANK, link, false);
    }

    @Nonnull
    public static ExternalTexture create(ResourceLocation location, String name, ResourceLocation offline, String link) {
        return ExternalTexture.create(location, name, offline, link, false);
    }

    @Nonnull
    public static ExternalTexture create(ResourceLocation location, String name, ResourceLocation offline, String link, boolean autoUpload) {
        return ExternalTexture.create(location, name, offline, link, autoUpload, externalTexture -> {});
    }

    @Nonnull
    public static ExternalTexture create(ResourceLocation location, String name, ResourceLocation offline, String link, boolean autoUpload, Consumer<ExternalTexture> callback) {
        return new ExternalTexture(location, name, offline, link, autoUpload, callback);
    }

    @Override
    public boolean isInProgress() {
        return this.future != null;
    }

    @Override
    public boolean isUploaded() {
        return this.uploaded;
    }

    @Override
    public ResourceLocation get() {
        if (this.uploaded) {
            return this.ONLINE;
        }
        if (this.AUTO_UPLOAD) {
            this.upload();
        }
        return this.OFFLINE;
    }

    public ExternalTexture upload() {
        if (this.isInProgress()) {
            return this;
        }
        this.future = CompletableFuture.runAsync(() -> {
            ExceptionFilter.of(() -> {
                HttpURLConnection httpurlconnection = (HttpURLConnection)new URL(this.LINK).openConnection(Minecraft.m_91087_().m_91096_());
                httpurlconnection.setDoInput(true);
                httpurlconnection.setDoOutput(false);
                httpurlconnection.connect();
                NativeImage nativeImage = NativeImage.m_85058_((InputStream)httpurlconnection.getInputStream());
                httpurlconnection.disconnect();
                Path path = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "Obscuria", "Data");
                ExceptionFilter.of(() -> Files.createDirectory(path, new FileAttribute[0]));
                File file = new File(String.valueOf(path) + "/" + this.NAME);
                nativeImage.m_85056_(file);
                Minecraft.m_91087_().m_91097_().m_118495_(this.ONLINE, (AbstractTexture)new Texture(this.ONLINE, String.valueOf(path) + "/" + this.NAME));
                this.uploaded = true;
                this.future = null;
            }, e -> {
                this.future = null;
            });
            if (this.uploaded) {
                this.CALLBACK.accept(this);
            }
        }, Util.m_183991_());
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Texture
    extends SimpleTexture {
        final String PATH;

        public Texture(ResourceLocation location, String path) {
            super(location);
            this.PATH = path;
        }

        protected SimpleTexture.TextureImage m_6335_(ResourceManager manager) {
            try {
                return new SimpleTexture.TextureImage(new TextureMetadataSection(true, true), NativeImage.m_85058_((InputStream)new FileInputStream(this.PATH)));
            }
            catch (IOException e) {
                return new SimpleTexture.TextureImage(e);
            }
        }
    }
}

