/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity.layer;

import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtils;

public class UmvuthanaSunLayer
extends GeoRenderLayer<EntityUmvuthana> {
    protected final EntityRenderDispatcher entityRenderDispatcher;

    public UmvuthanaSunLayer(GeoRenderer<EntityUmvuthana> entityRendererIn, EntityRendererProvider.Context context) {
        super(entityRendererIn);
        this.entityRenderDispatcher = context.m_174022_();
    }

    public void renderForBone(PoseStack poseStack, EntityUmvuthana animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        super.renderForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        if (animatable.f_20919_ < 27 && animatable.active && (animatable.getActiveAbilityType() != EntityUmvuthana.TELEPORT_ABILITY || animatable.getActiveAbility().getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY)) {
            if (bone.isHidden()) {
                return;
            }
            poseStack.m_85836_();
            RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
            String boneName = "head";
            if (bone.getName().equals(boneName)) {
                PoseStack.Pose matrixstack$entry = poseStack.m_85850_();
                Matrix4f matrix4f = matrixstack$entry.m_252922_();
                Vector4f vecTranslation = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                vecTranslation.mul((Matrix4fc)matrix4f);
                PoseStack newPoseStack = new PoseStack();
                newPoseStack.m_252880_(vecTranslation.x(), vecTranslation.y(), vecTranslation.z());
                Vector4f vecScale = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
                vecScale.mul((Matrix4fc)matrix4f);
                float scale = (float)new Vec3((double)(vecScale.x() - vecTranslation.x()), (double)(vecScale.y() - vecTranslation.y()), (double)(vecScale.z() - vecTranslation.z())).m_82553_();
                newPoseStack.m_85841_(scale, scale, scale);
                VertexConsumer ivertexbuilder = bufferSource.m_6299_(RenderType.m_110454_((ResourceLocation)new ResourceLocation("mowziesmobs", "textures/particle/sun_no_glow.png"), (boolean)true));
                PoseStack.Pose matrixstack$entry2 = newPoseStack.m_85850_();
                Matrix4f matrix4f2 = matrixstack$entry2.m_252922_();
                Matrix3f matrix3f = matrixstack$entry.m_252943_();
                this.drawSun(matrix4f2, matrix3f, ivertexbuilder, packedLight, (float)animatable.f_19797_ + partialTick);
            }
            bufferSource.m_6299_(renderType);
            poseStack.m_85849_();
        }
    }

    private void drawSun(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer builder, int packedLightIn, float time) {
        float sunRadius = 1.2f + (float)Math.sin(time * 4.0f) * 0.085f;
        this.drawVertex(matrix4f, matrix3f, builder, -sunRadius, -sunRadius, 0.0f, 0.0f, 0.0f, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -sunRadius, sunRadius, 0.0f, 0.0f, 1.0f, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, sunRadius, sunRadius, 0.0f, 1.0f, 1.0f, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, sunRadius, -sunRadius, 0.0f, 1.0f, 0.0f, 1.0f, packedLightIn);
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_252986_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normals, 1.0f, 1.0f, 1.0f).m_5752_();
    }
}

