/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.registry;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import sfiomn.legendarysurvivaloverhaul.api.block.ThermalTypeEnum;
import sfiomn.legendarysurvivaloverhaul.common.blocks.CoolerBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.HeaterBaseBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.HeaterTopBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.IceFernBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.IceFernGoldBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.SewingTableBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.SunFernBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.SunFernGoldBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.WaterPlantBlock;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"legendarysurvivaloverhaul");
    public static final RegistryObject<Block> HEATER = BlockRegistry.registerBlock("heater", () -> new HeaterBaseBlock(ThermalTypeEnum.HEATING));
    public static final RegistryObject<Block> HEATER_TOP = BLOCKS.register("heater_top", HeaterTopBlock::new);
    public static final RegistryObject<Block> COOLER = BlockRegistry.registerBlock("cooler", () -> new CoolerBlock(ThermalTypeEnum.COOLING));
    public static final RegistryObject<Block> SEWING_TABLE = BlockRegistry.registerBlock("sewing_table", SewingTableBlock::new);
    public static final RegistryObject<Block> SUN_FERN_CROP = BLOCKS.register("sun_fern_crop", SunFernBlock::new);
    public static final RegistryObject<Block> SUN_FERN_GOLD = BlockRegistry.registerBlock("sun_fern_gold", SunFernGoldBlock::new);
    public static final RegistryObject<Block> ICE_FERN_CROP = BLOCKS.register("ice_fern_crop", IceFernBlock::new);
    public static final RegistryObject<Block> ICE_FERN_GOLD = BlockRegistry.registerBlock("ice_fern_gold", IceFernGoldBlock::new);
    public static final RegistryObject<Block> WATER_PLANT_CROP = BLOCKS.register("water_plant_crop", WaterPlantBlock::new);

    private static <T extends Block> RegistryObject<Block> registerBlock(String name, Supplier<T> block) {
        RegistryObject newBlock = BLOCKS.register(name, block);
        BlockRegistry.registerBlockItem(name, newBlock);
        return newBlock;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ItemRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

