/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureConsumableBlock;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureConsumableBlockListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncTemperatureConsumableBlocksPacket {
    private final Map<ResourceLocation, List<JsonTemperatureConsumableBlock>> temperatureConsumableBlocks;
    private final int size;

    public SyncTemperatureConsumableBlocksPacket(Map<ResourceLocation, List<JsonTemperatureConsumableBlock>> temperatureConsumableBlocks) {
        this.temperatureConsumableBlocks = Map.copyOf(temperatureConsumableBlocks);
        this.size = temperatureConsumableBlocks.size();
    }

    public static void encode(SyncTemperatureConsumableBlocksPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, List<JsonTemperatureConsumableBlock>> e : message.temperatureConsumableBlocks.entrySet()) {
            buffer.m_130085_(e.getKey());
            buffer.writeInt(e.getValue().size());
            DataResult r = JsonTemperatureConsumableBlock.LIST_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, e.getValue());
            r.result().ifPresent(j -> ((ListTag)j).forEach(k -> buffer.m_130079_((CompoundTag)k)));
        }
    }

    public static SyncTemperatureConsumableBlocksPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, List<JsonTemperatureConsumableBlock>> temperatureConsumables = new HashMap<ResourceLocation, List<JsonTemperatureConsumableBlock>>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            int jtcSize = buffer.readInt();
            ArrayList jtcList = new ArrayList();
            for (int j = 0; j < jtcSize; ++j) {
                CompoundTag tag = buffer.m_130260_();
                if (tag == null) continue;
                DataResult r = JsonTemperatureConsumableBlock.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
                r.result().ifPresent(jtcList::add);
            }
            temperatureConsumables.put(key, jtcList);
        }
        return new SyncTemperatureConsumableBlocksPacket(temperatureConsumables);
    }

    public static void handle(SyncTemperatureConsumableBlocksPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncTemperatureConsumableBlocksPacket.syncTemperatureConsumableBlocks(message.temperatureConsumableBlocks)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncTemperatureConsumableBlocks(final Map<ResourceLocation, List<JsonTemperatureConsumableBlock>> temperatureConsumableBlocks) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                TemperatureConsumableBlockListener.acceptServerTemperatureConsumableBlocks(temperatureConsumableBlocks);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, List<JsonTemperatureConsumableBlock>> temperatureConsumableBlocks) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncTemperatureConsumableBlocksPacket(temperatureConsumableBlocks));
    }
}

