/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonBodyPartsDamageSource;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyPartsDamageSourceListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncBodyPartsDamageSourcesPacket {
    private final Map<ResourceLocation, JsonBodyPartsDamageSource> damageSources;
    private final int size;

    public SyncBodyPartsDamageSourcesPacket(Map<ResourceLocation, JsonBodyPartsDamageSource> damageSources) {
        this.damageSources = Map.copyOf(damageSources);
        this.size = damageSources.size();
    }

    public static void encode(SyncBodyPartsDamageSourcesPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, JsonBodyPartsDamageSource> e : message.damageSources.entrySet()) {
            buffer.m_130085_(e.getKey());
            DataResult r = JsonBodyPartsDamageSource.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)e.getValue());
            r.result().ifPresent(j -> buffer.m_130079_((CompoundTag)j));
        }
    }

    public static SyncBodyPartsDamageSourcesPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, JsonBodyPartsDamageSource> damageSources = new HashMap<ResourceLocation, JsonBodyPartsDamageSource>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            CompoundTag tag = buffer.m_130260_();
            if (tag == null) continue;
            DataResult r = JsonBodyPartsDamageSource.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            r.result().ifPresent(t -> damageSources.put(key, (JsonBodyPartsDamageSource)t));
        }
        return new SyncBodyPartsDamageSourcesPacket(damageSources);
    }

    public static void handle(SyncBodyPartsDamageSourcesPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncBodyPartsDamageSourcesPacket.syncTemperatureItems(message.damageSources)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncTemperatureItems(final Map<ResourceLocation, JsonBodyPartsDamageSource> damageSources) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                BodyPartsDamageSourceListener.acceptServerDamageSources(damageSources);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, JsonBodyPartsDamageSource> damageSources) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncBodyPartsDamageSourcesPacket(damageSources));
    }
}

