/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonHealingConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.BodyDamageDataManager;
import sfiomn.legendarysurvivaloverhaul.common.integration.supplementaries.SupplementariesUtil;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;

public class BodyPartHealingTimeMessage {
    private CompoundTag compound;

    public BodyPartHealingTimeMessage(BodyPartEnum bodyPart, String healingItem, InteractionHand hand, boolean consumeItem, boolean applyEffect) {
        CompoundTag bodyPartHealNbt = new CompoundTag();
        bodyPartHealNbt.m_128359_("bodyPartEnum", bodyPart.name());
        bodyPartHealNbt.m_128359_("healingItem", healingItem);
        bodyPartHealNbt.m_128379_("mainHand", hand == InteractionHand.MAIN_HAND);
        bodyPartHealNbt.m_128379_("consumeItem", consumeItem);
        bodyPartHealNbt.m_128379_("applyEffect", applyEffect);
        this.compound = bodyPartHealNbt;
    }

    public BodyPartHealingTimeMessage(Tag nbt) {
        this.compound = (CompoundTag)nbt;
    }

    public BodyPartHealingTimeMessage() {
    }

    public static void encode(BodyPartHealingTimeMessage message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.compound);
    }

    public static BodyPartHealingTimeMessage decode(FriendlyByteBuf buffer) {
        return new BodyPartHealingTimeMessage((Tag)buffer.m_130260_());
    }

    public static void handle(BodyPartHealingTimeMessage message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer player;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (player = context.getSender()) != null) {
            context.enqueueWork(() -> BodyPartHealingTimeMessage.applyHealingItemOnServer(player, message.compound));
        }
        supplier.get().setPacketHandled(true);
    }

    public static void applyHealingItemOnServer(ServerPlayer player, CompoundTag nbt) {
        ItemStack itemStackInBasket;
        BodyPartEnum bodyPartEnum = BodyPartEnum.valueOf(nbt.m_128461_("bodyPartEnum"));
        String healingItem = nbt.m_128461_("healingItem");
        InteractionHand hand = nbt.m_128471_("mainHand") ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        boolean shouldConsume = nbt.m_128471_("consumeItem");
        boolean shouldApplyEffect = nbt.m_128471_("applyEffect");
        ItemStack usedItemStack = player.m_21120_(hand);
        if (LegendarySurvivalOverhaul.supplementariesLoaded && (itemStackInBasket = SupplementariesUtil.getSelectedItemInLunchBasket(player.m_21120_(hand))) != ItemStack.f_41583_) {
            usedItemStack = itemStackInBasket;
        }
        ResourceLocation itemStackRegistryName = new ResourceLocation(healingItem);
        JsonHealingConsumable jhc = BodyDamageDataManager.getHealingItem(itemStackRegistryName);
        player.m_284548_().m_6269_(null, (Entity)player, (SoundEvent)SoundRegistry.HEAL_BODY_PART.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (shouldConsume && !player.m_7500_()) {
            usedItemStack.m_41774_(1);
        }
        if (jhc != null) {
            if (shouldApplyEffect) {
                player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.RECOVERY.get(), jhc.recoveryEffectDuration, jhc.recoveryEffectAmplifier, false, false, true));
            }
            BodyDamageUtil.applyHealingTimeBodyPart((Player)player, bodyPartEnum, jhc.healingValue, jhc.healingTime);
        }
    }

    public static void sendToServer(BodyPartEnum bodyPart, String healingItem, InteractionHand hand, boolean consumeItem, boolean applyEffect) {
        BodyPartHealingTimeMessage bodyPartHealingTimeMessageToServer = new BodyPartHealingTimeMessage(bodyPart, healingItem, hand, consumeItem, applyEffect);
        NetworkHandler.INSTANCE.sendToServer((Object)bodyPartHealingTimeMessageToServer);
    }
}

